/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products.ReportProductAirFieldsProcessor;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.RestProductType;
import java.util.Optional;

public class ReportProductInsuranceAccidentFieldsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        InsuranceAccident product = (InsuranceAccident)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        record.setProductType(RestProductType.INSURANCE_ACCIDENT);
        record.setComments(TextUtil.nonNullStr((String)product.getComments()));
        BaseProduct airProduct = BookingHelper.findProduct((BookingFile)product.getReservation().getBookingFile(), (String)product.getRelatedProductUid());
        if (airProduct instanceof Product) {
            ReportProductAirFieldsProcessor.updateLocations((Product)airProduct, record, isDemon);
        }
        if (product.getSalesPoint() != null) {
            record.setSalesPoint(RestReportsHelper.convertReference(Optional.ofNullable(EntityStorage.get().resolve(product.getSalesPoint())).map(EntityContainer::toReference).orElse(product.getSalesPoint())));
        }
    }
}

