/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products.ReportProductCommonFieldsProcessor;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.RestProductType;
import java.util.ArrayList;
import java.util.Optional;

public class ReportProductRailwayCrimeaMcoFieldsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        record.setProductType(RestProductType.RAILWAY);
        RailwayCrimeaMco product = (RailwayCrimeaMco)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        record.setComments(TextUtil.nonNullStr((String)product.getComments()));
        record.setValidatingCarrierCode("\u041f\u0440\u043e\u0434\u0430\u0436\u0430 \u0416\u0414");
        ReportProductRailwayCrimeaMcoFieldsProcessor.fillSegmentInfo(record, product, isDemon);
        this.setSegmentsData(product, record);
        if (product.getSalesPoint() != null) {
            record.setSalesPoint(RestReportsHelper.convertReference(Optional.ofNullable(EntityStorage.get().resolve(product.getSalesPoint())).map(EntityContainer::toReference).orElse(product.getSalesPoint())));
        }
    }

    private void setSegmentsData(RailwayCrimeaMco product, ReportProduct record) {
        ArrayList<String> sr = new ArrayList<String>();
        ArrayList<String> sd = new ArrayList<String>();
        ArrayList<String> sa = new ArrayList<String>();
        for (RailwaySegment segment : product.getSegments()) {
            StringBuilder route = new StringBuilder();
            DictionaryReference<GeoLocation> departureCity = ReportProductRailwayCrimeaMcoFieldsProcessor.getCity((DictionaryReference<RailwayStation>)segment.getDepartureStation());
            DictionaryReference<GeoLocation> arrivalCity = ReportProductRailwayCrimeaMcoFieldsProcessor.getCity((DictionaryReference<RailwayStation>)segment.getArriveStation());
            route.append(departureCity != null ? departureCity : "");
            route.append(" - ");
            route.append(arrivalCity != null ? arrivalCity : "");
            sr.add(route.toString());
            sd.add(segment.getDepartureDate() != null ? ReportProductCommonFieldsProcessor.strDTF.format(segment.getDepartureDate()) : " - ");
            sa.add(segment.getArriveDate() != null ? ReportProductCommonFieldsProcessor.strDTF.format(segment.getArriveDate()) : " - ");
        }
        record.setSegmentsRoute(String.join((CharSequence)", ", sr));
        record.setSegmentsDepartureDate(String.join((CharSequence)", ", sd));
        record.setSegmentsArrivalDate(String.join((CharSequence)", ", sa));
    }

    static void fillSegmentInfo(ReportProduct record, RailwayCrimeaMco product, boolean isDemon) {
        if (!product.getSegments().isEmpty()) {
            RailwaySegment railwaySegment = (RailwaySegment)product.getSegments().get(0);
            DictionaryReference<GeoLocation> departureCity = ReportProductRailwayCrimeaMcoFieldsProcessor.getCity((DictionaryReference<RailwayStation>)railwaySegment.getDepartureStation());
            DictionaryReference<GeoLocation> destinationCity = ReportProductRailwayCrimeaMcoFieldsProcessor.getCity((DictionaryReference<RailwayStation>)railwaySegment.getArriveStation());
            record.setDepartureCity(RestReportsHelper.convertReference(departureCity, isDemon));
            record.setDepartureCountry(RestReportsHelper.convertReference(ReportProductRailwayCrimeaMcoFieldsProcessor.getCountry((DictionaryReference<RailwayStation>)railwaySegment.getDepartureStation()), isDemon));
            railwaySegment = (RailwaySegment)product.getSegments().get(product.getSegments().size() - 1);
            record.setDestinationCity(RestReportsHelper.convertReference(destinationCity, isDemon));
            record.setDestinationCountry(RestReportsHelper.convertReference(ReportProductRailwayCrimeaMcoFieldsProcessor.getCountry((DictionaryReference<RailwayStation>)railwaySegment.getArriveStation()), isDemon));
            record.setRouteLine(RestReportsHelper.getRouteLine(departureCity, destinationCity, isDemon));
            if (isDemon) {
                record.setFullRouteLine(record.getRouteLine());
            }
        }
    }

    private static DictionaryReference<Country> getCountry(DictionaryReference<RailwayStation> departureStation) {
        RailwayStation railwayStation = (RailwayStation)DictionaryCache.get().resolveReference(departureStation);
        if (railwayStation == null) {
            return null;
        }
        if (railwayStation.getCountry() != null) {
            return railwayStation.getCountry();
        }
        GeoLocation geoLocation = (GeoLocation)DictionaryCache.get().resolveReference(railwayStation.getGeoLocation());
        if (geoLocation != null) {
            return geoLocation.getCountry();
        }
        return null;
    }

    private static DictionaryReference<GeoLocation> getCity(DictionaryReference<RailwayStation> departureStation) {
        RailwayStation railwayStation = (RailwayStation)DictionaryCache.get().resolveReference(departureStation);
        if (railwayStation == null) {
            return null;
        }
        if (railwayStation.getGeoLocation() != null) {
            return DictHelper.getCity((DictionaryReference)railwayStation.getGeoLocation());
        }
        return new GeoLocationReference(railwayStation.getCode(), railwayStation.toString());
    }
}

