/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.ContractRelationVatDetalization;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.railway.dict.RailwayServiceClass;
import com.gridnine.xtrip.common.model.ibecorp.railway.dict.RailwayServiceClassReference;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products.ReportProductCommonFieldsProcessor;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.RestProductType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ReportProductRailwayFieldsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        record.setProductType(RestProductType.RAILWAY);
        RailwayProduct product = (RailwayProduct)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        record.setValidatingCarrierCode("\u041f\u0440\u043e\u0434\u0430\u0436\u0430 \u0416\u0414");
        ReportProductRailwayFieldsProcessor.fillSegmentInfo(record, product, isDemon);
        this.setSegmentsData(product, record, isDemon);
        this.updateService(record, product);
        record.setClassOfService(this.getClassOfServiceName(product));
        record.setRailwaySubclassOfService(RestReportsHelper.convertReference(this.getRailwaySubclassOfService(product), isDemon));
        record.setTrainType(this.getTrainType(product));
        StatisticalData statisticalData = product.getStatisticalData();
        if (record.isServiceCompleted() && statisticalData != null) {
            record.setMinimumPrice(MiscUtil.guarded((BigDecimal)statisticalData.getMinPriceRailway()));
            RestReportsHelper.fillPossibleEconomy(record, record.getPrice());
        }
        record.setComments(TextUtil.nonNullStr((String)product.getComments()));
        product.getSegments().stream().filter(Objects::nonNull).findFirst().map(RailwaySegment::getCarrier).ifPresent(drc -> {
            Optional.ofNullable(isDemon.booleanValue() ? drc.toString(LocaleHelper.EN_LOCALE) : drc.getCaption()).ifPresent(arg_0 -> ((ReportProduct)record).setNameCarrier(arg_0));
            Optional.ofNullable(DictHelper.resolve((DictionaryReference)drc)).ifPresent(c -> {
                Optional.ofNullable(c.getInn()).ifPresent(arg_0 -> ((ReportProduct)record).setInnCarrier(arg_0));
                Optional.ofNullable(c.getKpp()).ifPresent(arg_0 -> ((ReportProduct)record).setKppCarrier(arg_0));
            });
        });
        if (product.getSalesPoint() != null) {
            record.setSalesPoint(RestReportsHelper.convertReference(Optional.ofNullable(EntityStorage.get().resolve(product.getSalesPoint())).map(EntityContainer::toReference).orElse(product.getSalesPoint())));
        }
    }

    private String getClassOfServiceName(RailwayProduct product) {
        if (!this.isSapsan(product)) {
            return ClassOfService.ECONOMY.name();
        }
        int cariageNumber = 0;
        for (RailwaySegment seg : product.getSegments()) {
            if (TextUtil.isBlank((String)seg.getCarriageNumber())) continue;
            try {
                cariageNumber = Integer.parseInt(seg.getCarriageNumber());
                break;
            }
            catch (Exception exception) {
            }
        }
        if (cariageNumber == 1 || cariageNumber == 11) {
            return ClassOfService.FIRST.name();
        }
        if (cariageNumber == 2 || cariageNumber == 12) {
            return ClassOfService.BUSINESS.name();
        }
        return ClassOfService.ECONOMY.name();
    }

    private DictionaryReference<RailwayServiceClass> getRailwaySubclassOfService(RailwayProduct product) {
        RailwayServiceClassReference result = new RailwayServiceClassReference("", "");
        Collection railwayServiceClasses = DictionaryCache.get().getAll(RailwayServiceClass.class).values();
        product.getSegments().stream().filter(Objects::nonNull).filter(arg_0 -> ReportProductRailwayFieldsProcessor.lambda$getRailwaySubclassOfService$6(railwayServiceClasses, (DictionaryReference)result, arg_0)).findFirst().orElse(null);
        return result;
    }

    private String getTrainType(RailwayProduct product) {
        List segments = product.getSegments();
        String result = segments.stream().filter(Objects::nonNull).map(seg -> seg.getBrand()).filter(Objects::nonNull).findFirst().orElse(null);
        if (result == null || result.length() >= 255) {
            result = "";
        }
        return result;
    }

    private boolean isSapsan(RailwayProduct product) {
        return product.getSegments().stream().anyMatch(it -> it.getBrand() != null && "\u0421\u0430\u043f\u0441\u0430\u043d".equalsIgnoreCase(it.getBrand()) || this.isSapsanTrainNumber(it.getTrainNumber()));
    }

    private boolean isSapsanTrainNumber(String trainNumber) {
        if (TextUtil.isBlank((String)trainNumber)) {
            return false;
        }
        try {
            int tn = Integer.parseInt(trainNumber);
            return tn >= 751 && tn <= 780;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void updateService(ReportProduct record, RailwayProduct product) {
        RailwayProductContractRelationData clientContractRelation = RailwayProductHelper.getClientContractRelation((RailwayProduct)product);
        if (clientContractRelation != null) {
            BigDecimal additionalFee = clientContractRelation.getServiceData().getDetalization().getAdditionalFee();
            record.setRailwayService(ReportProductCommonFieldsProcessor.calculateMeasure(additionalFee, product));
            ContractRelationVatDetalization vat = clientContractRelation.getServiceData().getDetalization().getVat();
            if (vat != null) {
                record.setRailwayServiceVAT(ReportProductCommonFieldsProcessor.calculateMeasure(vat.getComponents().stream().filter(c -> c.getSum() != null && c.getBasisTypes().contains(VatBasisType.SERVICE)).map(c -> c.getSum()).reduce(BigDecimal.ZERO, BigDecimal::add), product));
            }
        }
    }

    private void setSegmentsData(RailwayProduct product, ReportProduct record, boolean isDemon) {
        ArrayList<String> sr = new ArrayList<String>();
        ArrayList<String> sd = new ArrayList<String>();
        ArrayList<String> sa = new ArrayList<String>();
        for (RailwaySegment segment : product.getSegments()) {
            StringBuilder route = new StringBuilder();
            DictionaryReference<GeoLocation> departureCity = ReportProductRailwayFieldsProcessor.getCity((DictionaryReference<RailwayStation>)segment.getDepartureStation());
            DictionaryReference<GeoLocation> arrivalCity = ReportProductRailwayFieldsProcessor.getCity((DictionaryReference<RailwayStation>)segment.getArriveStation());
            route.append((Object)(departureCity != null ? (isDemon ? departureCity.toString(LocaleHelper.EN_LOCALE) : departureCity) : ""));
            route.append(" - ");
            route.append((Object)(arrivalCity != null ? (isDemon ? arrivalCity.toString(LocaleHelper.EN_LOCALE) : arrivalCity) : ""));
            sr.add(route.toString());
            sd.add(segment.getDepartureDate() != null ? ReportProductCommonFieldsProcessor.strDTF.format(segment.getDepartureDate()) : " - ");
            sa.add(segment.getArriveDate() != null ? ReportProductCommonFieldsProcessor.strDTF.format(segment.getArriveDate()) : " - ");
        }
        record.setSegmentsRoute(String.join((CharSequence)", ", sr));
        record.setSegmentsDepartureDate(String.join((CharSequence)", ", sd));
        record.setSegmentsArrivalDate(String.join((CharSequence)", ", sa));
    }

    static void fillSegmentInfo(ReportProduct record, RailwayProduct product, boolean isDemon) {
        DictionaryReference<GeoLocation> departureCity = null;
        DictionaryReference<GeoLocation> destinationCity = null;
        if (!product.getSegments().isEmpty()) {
            RailwaySegment railwaySegment = (RailwaySegment)product.getSegments().get(0);
            departureCity = ReportProductRailwayFieldsProcessor.getCity((DictionaryReference<RailwayStation>)railwaySegment.getDepartureStation());
            record.setDepartureCity(RestReportsHelper.convertReference(departureCity, isDemon));
            record.setDepartureCountry(RestReportsHelper.convertReference(ReportProductRailwayFieldsProcessor.getCountry((DictionaryReference<RailwayStation>)railwaySegment.getDepartureStation()), isDemon));
            railwaySegment = (RailwaySegment)product.getSegments().get(product.getSegments().size() - 1);
            destinationCity = ReportProductRailwayFieldsProcessor.getCity((DictionaryReference<RailwayStation>)railwaySegment.getArriveStation());
            record.setDestinationCity(RestReportsHelper.convertReference(destinationCity, isDemon));
            record.setDestinationCountry(RestReportsHelper.convertReference(ReportProductRailwayFieldsProcessor.getCountry((DictionaryReference<RailwayStation>)railwaySegment.getArriveStation()), isDemon));
            if (railwaySegment.getCarriageType() != null) {
                record.setRailwayCarriageType(railwaySegment.getCarriageType().name());
            }
        }
        record.setRouteLine(RestReportsHelper.getRouteLine(departureCity, destinationCity, isDemon));
        if (isDemon) {
            record.setFullRouteLine(record.getRouteLine());
        }
        record.setRouteDescription(TextUtil.nonNullStr((String)RailwayProductHelper.getRouteDescription((RailwayProduct)product)));
    }

    private static DictionaryReference<Country> getCountry(DictionaryReference<RailwayStation> departureStation) {
        RailwayStation railwayStation = (RailwayStation)DictionaryCache.get().resolveReference(departureStation);
        if (railwayStation == null) {
            return null;
        }
        if (railwayStation.getCountry() != null) {
            return railwayStation.getCountry();
        }
        GeoLocation geoLocation = (GeoLocation)DictionaryCache.get().resolveReference(railwayStation.getGeoLocation());
        if (geoLocation != null) {
            return geoLocation.getCountry();
        }
        return null;
    }

    private static DictionaryReference<GeoLocation> getCity(DictionaryReference<RailwayStation> departureStation) {
        RailwayStation railwayStation = (RailwayStation)DictionaryCache.get().resolveReference(departureStation);
        if (railwayStation == null) {
            return null;
        }
        if (railwayStation.getGeoLocation() != null) {
            return DictHelper.getCity((DictionaryReference)railwayStation.getGeoLocation());
        }
        return new GeoLocationReference(railwayStation.getCode(), railwayStation.toString());
    }

    private static /* synthetic */ boolean lambda$getRailwaySubclassOfService$6(Collection railwayServiceClasses, DictionaryReference result, RailwaySegment seg) {
        RailwayServiceClass railwayServiceClass = railwayServiceClasses.stream().filter(service -> service.getCarrier() != null).filter(service -> service.getCarrier().equals((Object)seg.getCarrier())).filter(service -> service.getServiceClass() != null).filter(service -> service.getServiceClass().equals((Object)seg.getServiceClass())).findFirst().orElse(null);
        if (railwayServiceClass != null && ((RailwayCarrier)DictionaryCache.get().resolveReference(seg.getCarrier())).isHasSubclasses()) {
            RailwayServiceClassReference railwayServiceClassReference = railwayServiceClass.toReference();
            result.setCode(railwayServiceClassReference.getCode());
            result.setCaption(railwayServiceClassReference.getCaption());
            if (result.getCode().length() >= 255 || result.getCaption().length() >= 255) {
                result.setCode("");
                result.setCaption("");
            }
            if (result.getCode().equals(result.getCaption())) {
                result.setCode("");
                result.setCaption("");
            }
            return true;
        }
        return false;
    }
}

