/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.RestDictionaryReference;
import com.gridnine.xtrip.server.model.rest.reports.RestProductType;
import java.util.Optional;

public class ReportProductTaxiProductFieldsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        TaxiProduct taxiProduct = (TaxiProduct)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        record.setProductType(RestProductType.TAXI);
        record.setComments(taxiProduct.getComments() != null ? taxiProduct.getComments() : "");
        RestDictionaryReference restCityReference = RestReportsHelper.convertReference(DictHelper.getCity((DictionaryReference)taxiProduct.getCity()), isDemon);
        record.setDepartureCity(restCityReference);
        record.setDestinationCity(restCityReference);
        if (taxiProduct.getCountry() != null) {
            RestDictionaryReference countryReference = RestReportsHelper.convertReference(taxiProduct.getCountry(), isDemon);
            record.setDepartureCity(countryReference);
            record.setDepartureCity(countryReference);
        }
        if (taxiProduct.getSalesPoint() != null) {
            record.setSalesPoint(RestReportsHelper.convertReference(Optional.ofNullable(EntityStorage.get().resolve(taxiProduct.getSalesPoint())).map(EntityContainer::toReference).orElse(taxiProduct.getSalesPoint())));
        }
    }
}

