/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.RestProductType;
import java.util.Optional;

public class ReportProductTransferFieldsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        record.setProductType(RestProductType.TRANSFER);
        Transfer product = (Transfer)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        record.setComments(TextUtil.nonNullStr((String)product.getComments()));
        record.setDepartureCity(RestReportsHelper.convertReference(DictHelper.getCity((DictionaryReference)product.getStartCity()), isDemon));
        record.setDepartureCountry(RestReportsHelper.convertReference(product.getStartCountry(), isDemon));
        record.setDestinationCity(RestReportsHelper.convertReference(DictHelper.getCity((DictionaryReference)product.getEndCity()), isDemon));
        record.setDestinationCountry(RestReportsHelper.convertReference(product.getEndCountry(), isDemon));
        if (product.getSalesPoint() != null) {
            record.setSalesPoint(RestReportsHelper.convertReference(Optional.ofNullable(EntityStorage.get().resolve(product.getSalesPoint())).map(EntityContainer::toReference).orElse(product.getSalesPoint())));
        }
    }
}

