/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductCustomParameterRole;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.RouteHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products.ReportProductCommonFieldsProcessor;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.RestProductType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class ReportProductUniversalProductFieldsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Country arrCountry;
        GeoLocation arrCity;
        Country depCountry;
        GeoLocation departureLoc;
        GeoLocation depCity;
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        UniversalProduct product = (UniversalProduct)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        record.setComments(TextUtil.nonNullStr((String)product.getComments()));
        if (product.getDescription() != null) {
            record.setUniversalProductDescription(RestReportsHelper.convertReference(product.getDescription()));
        }
        record.setFirstServiceDate(UniversalProductHelper.getFirstStartDate((UniversalProduct)product) == null ? "" : ReportProductCommonFieldsProcessor.dateFormat.format(MiscUtil.toLocalDate((Date)UniversalProductHelper.getFirstStartDate((UniversalProduct)product))));
        record.setLastServiceDate(UniversalProductHelper.getLastEndDate((UniversalProduct)product) == null ? "" : ReportProductCommonFieldsProcessor.dateFormat.format(MiscUtil.toLocalDate((Date)UniversalProductHelper.getLastEndDate((UniversalProduct)product))));
        List addressesData = UniversalProductHelper.getAddressesData((UniversalProduct)product, (Locale)(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE));
        String cityRoute = RouteHelper.getRoute((List)addressesData, Arrays.asList(RouteHelper.AddressElementType.CITY), Collections.emptyList(), null);
        if (!TextUtil.isBlank((String)cityRoute)) {
            record.setRouteLine(cityRoute);
        } else {
            record.setRouteLine(RouteHelper.getRoute((List)addressesData, Arrays.asList(RouteHelper.AddressElementType.COUNTRY), Collections.emptyList(), null));
        }
        if (TextUtil.isBlank((String)record.getRouteLine())) {
            record.setRouteLine("");
        }
        if (isDemon.booleanValue()) {
            record.setFullRouteLine(record.getRouteLine());
        }
        GeoLocation geoLocation = depCity = (departureLoc = (GeoLocation)DictionaryCache.get().resolveReference((DictionaryReference)UniversalProductHelper.getCustomValues((UniversalProduct)product, (UniversalProductCustomParameterRole)UniversalProductCustomParameterRole.LOCATION_START, GeoLocationReference.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues((UniversalProduct)product, (UniversalProductCustomParameterRole)UniversalProductCustomParameterRole.ROUTE_LINE, GeoLocationReference.class).stream().findFirst().orElse(null)))) == null ? null : DictHelper.findCity((GeoLocation)departureLoc);
        if (depCity != null) {
            record.setDepartureCity(RestReportsHelper.convertReference(depCity.toReference(), isDemon));
        }
        String departureLocation = departureLoc == null ? null : departureLoc.toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE);
        DictionaryReference depCountryRef = UniversalProductHelper.getCustomValues((UniversalProduct)product, (UniversalProductCustomParameterRole)UniversalProductCustomParameterRole.LOCATION_START, CountryReference.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues((UniversalProduct)product, (UniversalProductCustomParameterRole)UniversalProductCustomParameterRole.ROUTE_LINE, CountryReference.class).stream().findFirst().orElse(null));
        if (depCountryRef == null && depCity != null) {
            depCountryRef = depCity.getCountry();
        }
        Country country = depCountry = depCountryRef == null ? null : (Country)DictionaryCache.get().resolveReference(depCountryRef);
        if (depCountry != null) {
            record.setDepartureCountry(RestReportsHelper.convertReference(depCountry.toReference(), isDemon));
        }
        String departureCountry = depCountry == null ? null : depCountry.toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE);
        GeoLocation arrLoc = (GeoLocation)DictionaryCache.get().resolveReference((DictionaryReference)UniversalProductHelper.getCustomValues((UniversalProduct)product, (UniversalProductCustomParameterRole)UniversalProductCustomParameterRole.LOCATION_END, GeoLocationReference.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues((UniversalProduct)product, (UniversalProductCustomParameterRole)UniversalProductCustomParameterRole.ROUTE_LINE, GeoLocationReference.class).stream().findFirst().orElse(null)));
        GeoLocation geoLocation2 = arrCity = arrLoc == null ? null : DictHelper.findCity((GeoLocation)arrLoc);
        if (arrCity != null) {
            record.setDestinationCity(RestReportsHelper.convertReference(arrCity.toReference(), isDemon));
        }
        String arriveLocation = arrLoc == null ? null : arrLoc.toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE);
        DictionaryReference arrCountryRef = UniversalProductHelper.getCustomValues((UniversalProduct)product, (UniversalProductCustomParameterRole)UniversalProductCustomParameterRole.LOCATION_END, CountryReference.class).stream().findFirst().orElse(UniversalProductHelper.getCustomValues((UniversalProduct)product, (UniversalProductCustomParameterRole)UniversalProductCustomParameterRole.ROUTE_LINE, CountryReference.class).stream().findFirst().orElse(null));
        if (arrCountryRef == null && arrCity != null) {
            arrCountryRef = arrCity.getCountry();
        }
        Country country2 = arrCountry = arrCountryRef == null ? null : (Country)DictionaryCache.get().resolveReference(arrCountryRef);
        if (arrCountry != null) {
            record.setDestinationCountry(RestReportsHelper.convertReference(arrCountry.toReference(), isDemon));
        }
        String arriveCountry = arrCountry == null ? null : arrCountry.toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE);
        RouteHelper.AddressData departureAddressData = RouteHelper.AddressDataBuilder.get().country(departureCountry).city(departureLocation).build();
        RouteHelper.AddressData arriveAddressData = RouteHelper.AddressDataBuilder.get().country(arriveCountry).city(arriveLocation).build();
        record.setFullRouteLine(RouteHelper.getRoute(Arrays.asList(departureAddressData, arriveAddressData)));
        if (TextUtil.isBlank((String)record.getFullRouteLine())) {
            record.setFullRouteLine("");
        }
        record.setProductType(RestProductType.UNIVERSAL);
        if (product.getSalesPoint() != null) {
            record.setSalesPoint(RestReportsHelper.convertReference(Optional.ofNullable(EntityStorage.get().resolve(product.getSalesPoint())).map(EntityContainer::toReference).orElse(product.getSalesPoint())));
        }
    }
}

