/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products.ReportProductCommonFieldsProcessor;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.rest.reports.EnumWrapper;
import com.gridnine.xtrip.server.model.rest.reports.ReportPassengerData;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.ReportProductBillingItemData;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class ReportProductUpdateBillingItemProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        BaseProduct product = (BaseProduct)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusRestContextKeys.BOOKING_FILE_CONTAINER);
        AtomicBoolean setEmptyPassenger = new AtomicBoolean(false);
        Traveller traveller = new Traveller();
        ReportPassengerData passengerData = RestReportsHelper.getPassengersZero();
        passengerData.setTravellerUid(String.format("%s_%s", product.getUid(), traveller.getUid()));
        Map<NestedEntityReference<BookingFile, BaseProduct>, List<BillingItem>> billingItemsMap = ReportProductUpdateBillingItemProcessor.getBillingItemsMap(product, ctx);
        NestedEntityReference keyForMap = new NestedEntityReference(bookingFileCtr, (BaseEntity)product);
        List<BillingItem> billingItems = billingItemsMap.get(keyForMap);
        if (billingItems != null) {
            billingItems.forEach(billingItem -> {
                EntityContainer shipmentCtr;
                EntityReference shipmentRef;
                ReportProductBillingItemData billingItemReportData = RestReportsHelper.getReportProductBillingItemDataZero();
                billingItemReportData.setUidBillingItem(billingItem.getUid());
                if (billingItem.getName() != null) {
                    billingItemReportData.setNameBillingItem(billingItem.getName().length() > 1000 ? billingItem.getName().substring(0, 997) + "..." : billingItem.getName());
                }
                EnumWrapper paymentTypeEnumWrapper = RestReportsHelper.getEnumWrapperZero();
                if (billingItem.getPaymentType() != null) {
                    paymentTypeEnumWrapper.setName(billingItem.getPaymentType().name());
                    paymentTypeEnumWrapper.setCaption(billingItem.getPaymentType().toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE));
                }
                billingItemReportData.setPaymentType(paymentTypeEnumWrapper);
                if (billingItem.getAmount() != null) {
                    billingItemReportData.setAmountBillingItem(billingItem.getAmount().getTotal() != null ? billingItem.getAmount().getTotal() : BigDecimal.ZERO);
                    billingItemReportData.setVatAmountBillingItem(billingItem.getAmount().getVatAmount() != null ? billingItem.getAmount().getVatAmount() : BigDecimal.ZERO);
                    if (billingItem.getAmount().getVat() != null) {
                        BigDecimal vatRate = BigDecimal.valueOf(billingItem.getAmount().getVat()).setScale(0, RoundingMode.HALF_UP);
                        billingItemReportData.setVatRateBillingItem(vatRate.toString());
                    }
                }
                if ((shipmentRef = billingItem.getShipment()) != null && (shipmentCtr = EntityStorageHelper.resolve((EntityReference)shipmentRef, (EntityStorageContext)sc)) != null) {
                    Shipment shipment = (Shipment)shipmentCtr.getEntity();
                    for (EntityReference financeDocumentEntityRef : shipment.getFinanceDocuments()) {
                        FinanceDocument entity;
                        EntityContainer documentEntityCtr = EntityStorageHelper.resolve((EntityReference)financeDocumentEntityRef, (EntityStorageContext)sc);
                        if (documentEntityCtr == null || (entity = (FinanceDocument)documentEntityCtr.getEntity()) == null || !FinanceDocumentType.INVOICE_CONSOLIDATED.equals((Object)entity.getType())) continue;
                        String invoiceConsolidatedNumber = Optional.ofNullable(entity.getNumber()).orElse("");
                        billingItemReportData.setInvoiceConsolidatedNumber(invoiceConsolidatedNumber);
                    }
                    if (shipment.getNumber() != null) {
                        billingItemReportData.setNumberShipment(shipment.getNumber());
                    }
                    if (shipment.getDate() != null) {
                        billingItemReportData.setDateShipment(shipment.getDate() == null ? "" : ReportProductCommonFieldsProcessor.dateFormat.format(MiscUtil.toLocalDate((Date)shipment.getDate())));
                    }
                    billingItemReportData.setExportedToSbis(shipment.isExportedToSbis());
                    billingItemReportData.setCustomer(isDemon != false ? RestReportsHelper.convertReference(shipment.getCustomer(), RestReportsHelper.organizationNameGetter((EntityReference<Organization>)shipment.getCustomer(), sc)) : RestReportsHelper.convertReference(shipment.getCustomer()));
                    if (billingItem.getTraveller() != null) {
                        if (GeneralProductHelper.getHandler((BaseProduct)product).getTravellers(product).stream().noneMatch(t -> t.getUid().equals(billingItem.getTraveller().getNestedEntityUid()))) {
                            throw Xeption.forAdmin((String)Messages.TRAVELLER_UID_DIFFERS, (Object[])new Object[]{billingItem.getTraveller().getNestedEntityUid(), shipment.getNumber(), product.getUid(), product.getReservation().getBookingFile()});
                        }
                        billingItemReportData.setUidTraveller(String.format("%s_%s", product.getUid(), billingItem.getTraveller().getNestedEntityUid()));
                    } else {
                        billingItemReportData.setUidTraveller(String.format("%s_%s", product.getUid(), traveller.getUid()));
                        setEmptyPassenger.set(true);
                    }
                    record.getBillingItems().add(billingItemReportData);
                }
            });
        }
        if (setEmptyPassenger.get()) {
            record.getPassengers().add(passengerData);
        }
    }

    private static Map<NestedEntityReference<BookingFile, BaseProduct>, List<BillingItem>> getBillingItemsMap(BaseProduct product, MessageContext ctx) {
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        Map billingItemsMapCtx = (Map)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IbusReportsRestContextKeys.BILLING_ITEMS_LIST, HashMap::new);
        Set shipmentSetCtx = (Set)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IbusReportsRestContextKeys.SET_SHIPMENTS, HashSet::new);
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (component.getShipment() != null && !shipmentSetCtx.contains(component.getShipment())) {
                shipmentSetCtx.add(component.getShipment());
                EntityContainer ec = EntityStorageHelper.resolve((EntityReference)component.getShipment(), (EntityStorageContext)sc);
                if (ec != null) {
                    Shipment shipment = (Shipment)ec.getEntity();
                    FinanceDocumentHelper.getBillingItems((List)shipment.getBillingItems(), (EntityStorageContext)sc).forEach(billingItem -> {
                        if (billingItem.getProduct() != null) {
                            billingItemsMapCtx.computeIfAbsent(billingItem.getProduct(), billingItemsForNewProduct -> new ArrayList()).add(billingItem);
                        }
                    });
                }
            }
        });
        return billingItemsMapCtx;
    }
}

