/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.SpecialServiceRequest;
import com.gridnine.xtrip.common.model.booking.TechStopInfo;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MealServiceIndicatorGroup;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibecorp.rest.reports.RestReportsHelper;
import com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products.ReportProductCommonFieldsProcessor;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.EnumWrapper;
import com.gridnine.xtrip.server.model.rest.reports.ExtendedLuggageInfoRest;
import com.gridnine.xtrip.server.model.rest.reports.FareDetailsRest;
import com.gridnine.xtrip.server.model.rest.reports.LuggageInfoRest;
import com.gridnine.xtrip.server.model.rest.reports.MoneyRest;
import com.gridnine.xtrip.server.model.rest.reports.PricingParametersRest;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import com.gridnine.xtrip.server.model.rest.reports.ReportProductSegmentData;
import com.gridnine.xtrip.server.model.rest.reports.SpecialServiceRequestRest;
import com.gridnine.xtrip.server.model.rest.reports.TechStopInfoRest;
import java.util.Date;
import java.util.Locale;

public class ReportProductUpdateSegmentForAviaAeroRailProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Boolean isDemon = (Boolean)ctx.getObject((Enum)IbusReportsRestContextKeys.DEMON_KEY);
        ReportProduct record = (ReportProduct)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.RECORD);
        BaseProduct prod = (BaseProduct)ctx.getMandatoryObject((Enum)IBusRestContextKeys.PRODUCT);
        if (prod instanceof Product) {
            Product product = (Product)prod;
            product.getSegmentTariffs().forEach(segmentTariff -> segmentTariff.getSegments().forEach(segment -> {
                GeoLocation arrivalCity;
                GeoLocation departureCity;
                int co2;
                Object enumWrapper;
                ReportProductSegmentData reportProductSegmentData = RestReportsHelper.getReportProductSegmentDataZero();
                reportProductSegmentData.setSegmentUid(RestReportsHelper.checkString(segment.getUid()));
                reportProductSegmentData.setAirline(RestReportsHelper.convertReference(segment.getAirline(), isDemon));
                reportProductSegmentData.setArriveCityCode(RestReportsHelper.checkString(segment.getArriveCityCode()));
                reportProductSegmentData.setArriveLocation(RestReportsHelper.convertReference(segment.getArriveLocation(), isDemon));
                reportProductSegmentData.setArriveTerminal(RestReportsHelper.checkString(segment.getArriveTerminal()));
                reportProductSegmentData.setCheckinTime(segment.getCheckinTime() == null ? "" : ReportProductCommonFieldsProcessor.dateTimeFormat.format(MiscUtil.toLocalDateTime((Date)segment.getCheckinTime())));
                reportProductSegmentData.setDepartCityCode(RestReportsHelper.checkString(segment.getDepartCityCode()));
                reportProductSegmentData.setDepartureLocation(RestReportsHelper.convertReference(segment.getDepartureLocation(), isDemon));
                reportProductSegmentData.setDepartTerminal(RestReportsHelper.checkString(segment.getDepartTerminal()));
                reportProductSegmentData.setEndDate(segment.getEndDate() == null ? "" : ReportProductCommonFieldsProcessor.dateTimeFormat.format(MiscUtil.toLocalDateTime((Date)segment.getEndDate())));
                int duration = RestReportsHelper.intFromInteger(segment.getFlightDuration());
                if (duration > Short.MAX_VALUE) {
                    throw Xeption.forAdmin((String)Messages.FLIGHT_DURATION_TOO_BIG, (Object[])new Object[]{duration, segment.getRecordNumber(), product.getSystemNumber(), product.getReservation().getBookingFile().getNumber()});
                }
                reportProductSegmentData.setFlightDuration(duration);
                reportProductSegmentData.setFlightNo(RestReportsHelper.checkString(segment.getFlightNo()));
                int distance = RestReportsHelper.intFromInteger(segment.getFlightDistanceMiles());
                if (distance > Short.MAX_VALUE) {
                    throw Xeption.forAdmin((String)Messages.FLIGHT_DISTANCE_TOO_BIG, (Object[])new Object[]{distance, segment.getRecordNumber(), product.getSystemNumber(), product.getReservation().getBookingFile().getNumber()});
                }
                reportProductSegmentData.setFlightDistanceMiles(distance);
                reportProductSegmentData.setRecordNumber(segment.getRecordNumber());
                reportProductSegmentData.setStartDate(segment.getStartDate() == null ? "" : ReportProductCommonFieldsProcessor.dateTimeFormat.format(MiscUtil.toLocalDateTime((Date)segment.getStartDate())));
                reportProductSegmentData.setSeatNo(RestReportsHelper.checkString(segment.getSeatNo()));
                reportProductSegmentData.setSeatType(RestReportsHelper.checkString(segment.getSeatType()));
                reportProductSegmentData.setNoOfStops(RestReportsHelper.intFromInteger(segment.getNoOfStops()));
                reportProductSegmentData.setStarting(segment.isStarting());
                reportProductSegmentData.setBoard(RestReportsHelper.convertReference(segment.getBoard(), isDemon));
                reportProductSegmentData.setNotValidBefore(segment.getNotValidBefore() == null ? "" : ReportProductCommonFieldsProcessor.dateTimeFormat.format(MiscUtil.toLocalDateTime((Date)segment.getNotValidBefore())));
                reportProductSegmentData.setNotValidAfter(segment.getNotValidAfter() == null ? "" : ReportProductCommonFieldsProcessor.dateTimeFormat.format(MiscUtil.toLocalDateTime((Date)segment.getNotValidAfter())));
                if (segment.getDefaultCodeSystem() != null) {
                    EnumWrapper enumWrapper2 = new EnumWrapper();
                    enumWrapper2.setName(segment.getDefaultCodeSystem().name());
                    enumWrapper2.setCaption(segment.getDefaultCodeSystem().toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE));
                    reportProductSegmentData.setDefaultCodeSystem(enumWrapper2);
                }
                reportProductSegmentData.setStatus(RestReportsHelper.checkString(segment.getStatus()));
                LuggageInfoRest luggageInfo = RestReportsHelper.getLuggageInfoZero();
                if (segment.getLuggageInfo() != null) {
                    luggageInfo.setNil(segment.getLuggageInfo().isNil());
                    luggageInfo.setQuantity(RestReportsHelper.intFromInteger(segment.getLuggageInfo().getQuantity()));
                    luggageInfo.setUnit(RestReportsHelper.convertReference(segment.getLuggageInfo().getUnit(), isDemon));
                }
                reportProductSegmentData.setLuggageInfo(luggageInfo);
                reportProductSegmentData.setClassOfSvcCode(RestReportsHelper.checkString(segment.getClassOfSvcCode()));
                reportProductSegmentData.setClassOfService(RestReportsHelper.checkString(segment.getClassOfService()));
                if (segment.getServiceClass() != null) {
                    enumWrapper = new EnumWrapper();
                    enumWrapper.setName(segment.getServiceClass().name());
                    enumWrapper.setCaption(segment.getServiceClass().toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE));
                    reportProductSegmentData.setServiceClass((EnumWrapper)enumWrapper);
                }
                reportProductSegmentData.setFareBasis(RestReportsHelper.checkString(segment.getFareBasis()));
                if (segment.getCouponStatus() != null) {
                    enumWrapper = new EnumWrapper();
                    enumWrapper.setName(segment.getCouponStatus().name());
                    enumWrapper.setCaption(segment.getCouponStatus().toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE));
                    reportProductSegmentData.setCouponStatus((EnumWrapper)enumWrapper);
                }
                reportProductSegmentData.setAirlineLocator(RestReportsHelper.checkString(segment.getAirlineLocator()));
                reportProductSegmentData.setCodeShare(RestReportsHelper.booleanFromBoolean(segment.isCodeShare()));
                reportProductSegmentData.setCodeShareCarrier(RestReportsHelper.convertReference(segment.getCodeShareCarrier(), isDemon));
                reportProductSegmentData.setCodeShareFlightNo(RestReportsHelper.checkString(segment.getCodeShareFlightNo()));
                reportProductSegmentData.setOperatingAirlineCompanyShortName(RestReportsHelper.checkString(segment.getOperatingAirlineCompanyShortName()));
                reportProductSegmentData.setMealServiceIndicator(RestReportsHelper.convertReference(segment.getMealServiceIndicator(), isDemon));
                for (TechStopInfo info : segment.getTechStopInfos()) {
                    TechStopInfoRest infoRest = new TechStopInfoRest();
                    infoRest.setLocation(RestReportsHelper.convertReference(info.getLocation(), isDemon));
                    infoRest.setArrivalDateTime(info.getArrivalDateTime() == null ? "" : ReportProductCommonFieldsProcessor.dateTimeFormat.format(info.getArrivalDateTime()));
                    infoRest.setDepartureDateTime(info.getDepartureDateTime() == null ? "" : ReportProductCommonFieldsProcessor.dateTimeFormat.format(info.getDepartureDateTime()));
                    infoRest.setDuration(info.getDuration());
                    reportProductSegmentData.getTechStopInfos().add(infoRest);
                }
                for (SpecialServiceRequest specialServiceRequest : segment.getSsrs()) {
                    SpecialServiceRequestRest specialServiceRequestRest = new SpecialServiceRequestRest();
                    specialServiceRequestRest.setRequestDate(specialServiceRequest.getRequestDate() == null ? "" : ReportProductCommonFieldsProcessor.dateFormat.format(MiscUtil.toLocalDate((Date)specialServiceRequest.getRequestDate())));
                    specialServiceRequestRest.setStatus(specialServiceRequest.getStatus() == null ? "" : specialServiceRequest.getStatus().name());
                    specialServiceRequestRest.setRequestFreeText(TextUtil.nonNullStr((String)specialServiceRequest.getRequestFreeText()));
                    specialServiceRequestRest.setType(RestReportsHelper.convertReference(specialServiceRequest.getType(), isDemon));
                    specialServiceRequestRest.setResponseFreeText(TextUtil.nonNullStr((String)specialServiceRequest.getResponseFreeText()));
                    reportProductSegmentData.getSsrs().add(specialServiceRequestRest);
                }
                reportProductSegmentData.setGdsId(RestReportsHelper.checkString(segment.getGdsId()));
                if (segment.getFareDetails() != null) {
                    FareDetailsRest fareDetailsRest = new FareDetailsRest();
                    fareDetailsRest.setBrandName(GDSHelper.getDisplayBrandName((FareDetails)segment.getFareDetails(), (Locale)LocaleHelper.RU_LOCALE));
                    ExtendedLuggageInfoRest luggageInfoRest = RestReportsHelper.getExtendedLuggageInfoRestZero();
                    if (segment.getFareDetails().getLuggageInfo() != null) {
                        luggageInfoRest.setPieces(segment.getFareDetails().getLuggageInfo().getPieces() != null ? segment.getFareDetails().getLuggageInfo().getPieces() : 0);
                        luggageInfoRest.setWeight(segment.getFareDetails().getLuggageInfo().getWeight() != null ? segment.getFareDetails().getLuggageInfo().getWeight() : 0);
                    }
                    fareDetailsRest.setLuggageInfo(luggageInfoRest);
                    ExtendedLuggageInfoRest cabinLuggageInfoRest = RestReportsHelper.getExtendedLuggageInfoRestZero();
                    if (segment.getFareDetails().getCabinLuggageInfo() != null) {
                        cabinLuggageInfoRest.setPieces(segment.getFareDetails().getCabinLuggageInfo().getPieces() != null ? segment.getFareDetails().getCabinLuggageInfo().getPieces() : 0);
                        cabinLuggageInfoRest.setWeight(segment.getFareDetails().getCabinLuggageInfo().getWeight() != null ? segment.getFareDetails().getCabinLuggageInfo().getWeight() : 0);
                    }
                    fareDetailsRest.setCabinLuggageInfo(cabinLuggageInfoRest);
                    ExtendedLuggageInfoRest paidLuggageInfoRest = RestReportsHelper.getExtendedLuggageInfoRestZero();
                    if (segment.getFareDetails().getPaidLuggageInfo() != null) {
                        paidLuggageInfoRest.setPieces(segment.getFareDetails().getPaidLuggageInfo().getPieces() != null ? segment.getFareDetails().getPaidLuggageInfo().getPieces() : 0);
                        paidLuggageInfoRest.setWeight(segment.getFareDetails().getPaidLuggageInfo().getWeight() != null ? segment.getFareDetails().getPaidLuggageInfo().getWeight() : 0);
                    }
                    fareDetailsRest.setPaidLuggageInfo(paidLuggageInfoRest);
                    MoneyRest paidLuggagePrice = new MoneyRest();
                    if (segment.getFareDetails().getPaidLuggagePrice() != null) {
                        paidLuggagePrice.setCurrency(segment.getFareDetails().getPaidLuggagePrice().getCurrency());
                        paidLuggagePrice.setValue(segment.getFareDetails().getPaidLuggagePrice().getValue());
                    }
                    fareDetailsRest.setPaidLuggagePrice(paidLuggagePrice);
                    ExtendedLuggageInfoRest paidCabinLuggageInfoRest = RestReportsHelper.getExtendedLuggageInfoRestZero();
                    if (segment.getFareDetails().getPaidCabinLuggageInfo() != null) {
                        paidCabinLuggageInfoRest.setPieces(segment.getFareDetails().getPaidCabinLuggageInfo().getPieces().intValue());
                        paidCabinLuggageInfoRest.setWeight(segment.getFareDetails().getPaidCabinLuggageInfo().getWeight().intValue());
                    }
                    fareDetailsRest.setPaidCabinLuggageInfo(paidCabinLuggageInfoRest);
                    MoneyRest paidCabinLuggagePrice = RestReportsHelper.getMoneyZero();
                    if (segment.getFareDetails().getPaidCabinLuggagePrice() != null) {
                        paidCabinLuggagePrice.setCurrency(segment.getFareDetails().getPaidCabinLuggagePrice().getCurrency());
                        paidCabinLuggagePrice.setValue(segment.getFareDetails().getPaidCabinLuggagePrice().getValue());
                    }
                    fareDetailsRest.setPaidCabinLuggagePrice(paidCabinLuggagePrice);
                    fareDetailsRest.setBusinessLoungeAccess(RestReportsHelper.booleanFromBoolean(segment.getFareDetails().getBusinessLoungeAccess()));
                    fareDetailsRest.setMealService((segment.getFareDetails().getMealService() != null ? segment.getFareDetails().getMealService() : MealServiceIndicatorGroup.NOT_AVAILABLE).name());
                    fareDetailsRest.setSeatChoice(RestReportsHelper.booleanFromBoolean(segment.getFareDetails().getSeatChoice()));
                    fareDetailsRest.setPriorityBoarding(RestReportsHelper.booleanFromBoolean(segment.getFareDetails().getPriorityBoarding()));
                    fareDetailsRest.setExtraMileageBonus(RestReportsHelper.booleanFromBoolean(segment.getFareDetails().getExtraMileageBonus()));
                    fareDetailsRest.setClassUpgradeAvailable(RestReportsHelper.booleanFromBoolean(segment.getFareDetails().getClassUpgradeAvailable()));
                    fareDetailsRest.setTransferIncluded(RestReportsHelper.booleanFromBoolean(segment.getFareDetails().getTransferIncluded()));
                    PricingParametersRest pricingParametersRest = RestReportsHelper.getPricingParametersRestZero();
                    if (segment.getFareDetails().getPricingParameters() != null) {
                        pricingParametersRest.setDefaultPricing(RestReportsHelper.booleanFromBoolean(segment.getFareDetails().getPricingParameters().isDefaultPricing()));
                        pricingParametersRest.setBrandId(segment.getFareDetails().getPricingParameters().getBrandId());
                        pricingParametersRest.setPublicFare(RestReportsHelper.booleanFromBoolean(segment.getFareDetails().getPricingParameters().getPublicFare()));
                        pricingParametersRest.setRefundableAny(RestReportsHelper.booleanFromBoolean(segment.getFareDetails().getPricingParameters().getRefundableAny()));
                    }
                    fareDetailsRest.setPricingParameters(pricingParametersRest);
                    reportProductSegmentData.setFareDetails(fareDetailsRest);
                }
                if ((co2 = RestReportsHelper.intFromInteger(segment.getCo2EmissionsKg())) > Short.MAX_VALUE) {
                    throw Xeption.forAdmin((String)Messages.CO2_TOO_BIG, (Object[])new Object[]{co2, segment.getRecordNumber(), product.getSystemNumber(), product.getReservation().getBookingFile().getNumber()});
                }
                reportProductSegmentData.setCo2EmissionsKg(co2);
                String departureLocation = "";
                if (segment.getDepartureLocation() != null && (departureCity = DictHelper.findCity((DictionaryReference)segment.getDepartureLocation())) != null) {
                    departureLocation = isDemon != false ? departureCity.toString(LocaleHelper.EN_LOCALE) : departureCity.toString();
                }
                String arriveLocation = "";
                if (segment.getArriveLocation() != null && (arrivalCity = DictHelper.findCity((DictionaryReference)segment.getArriveLocation())) != null) {
                    arriveLocation = isDemon != false ? arrivalCity.toString(LocaleHelper.EN_LOCALE) : arrivalCity.toString();
                }
                reportProductSegmentData.setSegmentRouteLine(RestReportsHelper.getRoutForSegment(departureLocation, arriveLocation));
                reportProductSegmentData.setTravelersCount(product.getTraveller() != null ? 1 : 0);
                record.getSegments().add(reportProductSegmentData);
            }));
        } else if (prod instanceof RailwayProduct) {
            RailwayProduct product = (RailwayProduct)prod;
            product.getSegments().forEach(segment -> {
                EnumWrapper enumWrapper;
                ReportProductSegmentData reportProductSegmentData = RestReportsHelper.getReportProductSegmentDataZero();
                reportProductSegmentData.setSegmentUid(segment.getUid());
                reportProductSegmentData.setStartDate(segment.getDepartureDate() == null ? "" : ReportProductCommonFieldsProcessor.dateTimeFormat.format(MiscUtil.toLocalDateTime((Date)segment.getDepartureDate())));
                reportProductSegmentData.setEndDate(segment.getArriveDate() == null ? "" : ReportProductCommonFieldsProcessor.dateTimeFormat.format(MiscUtil.toLocalDateTime((Date)segment.getArriveDate())));
                reportProductSegmentData.setNumber(segment.getNumber());
                reportProductSegmentData.setCarriageNumber(RestReportsHelper.checkString(segment.getCarriageNumber()));
                if (segment.getCarriageType() != null) {
                    enumWrapper = new EnumWrapper();
                    enumWrapper.setName(segment.getCarriageType().name());
                    enumWrapper.setCaption(segment.getCarriageType().toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE));
                    reportProductSegmentData.setCarriageType(enumWrapper);
                }
                if (segment.getCompartmentType() != null) {
                    enumWrapper = new EnumWrapper();
                    enumWrapper.setName(segment.getCompartmentType().name());
                    enumWrapper.setCaption(segment.getCompartmentType().toString(isDemon != false ? LocaleHelper.EN_LOCALE : LocaleHelper.RU_LOCALE));
                    reportProductSegmentData.setCompartmentType(enumWrapper);
                }
                reportProductSegmentData.setClassOfService(segment.getServiceClass() != null ? segment.getServiceClass().name() : "");
                reportProductSegmentData.setTrainNumber(RestReportsHelper.checkString(segment.getTrainNumber()));
                reportProductSegmentData.setSlot(RestReportsHelper.checkString(segment.getSlot()));
                reportProductSegmentData.setDepartureStation(RestReportsHelper.convertReference(segment.getDepartureStation(), isDemon));
                reportProductSegmentData.setArriveStation(RestReportsHelper.convertReference(segment.getArriveStation(), isDemon));
                if (segment.getFare() != null) {
                    MoneyRest moneyRest = new MoneyRest();
                    moneyRest.setCurrency(segment.getFare().getCurrency());
                    moneyRest.setValue(segment.getFare().getValue());
                    reportProductSegmentData.setFare(moneyRest);
                }
                reportProductSegmentData.setEquivalentFare(RestReportsHelper.chekBigDecimal(segment.getEquivalentFare()));
                reportProductSegmentData.setEquivalentVAT(RestReportsHelper.chekBigDecimal(segment.getEquivalentVAT()));
                reportProductSegmentData.setERegEnabled(segment.isERegEnabled());
                reportProductSegmentData.setEReg(segment.isHasEReg());
                reportProductSegmentData.setRoute(RestReportsHelper.convertReference(segment.getRoute(), isDemon));
                reportProductSegmentData.setCarrier(RestReportsHelper.convertReference(segment.getCarrier(), isDemon));
                reportProductSegmentData.setTimeInfo(RestReportsHelper.checkString(segment.getTimeInfo()));
                reportProductSegmentData.setAddInfo(RestReportsHelper.checkString(segment.getAddInfo()));
                reportProductSegmentData.setDurationInMinutes(RestReportsHelper.intFromInteger(segment.getDurationInMinutes()));
                reportProductSegmentData.getPlaces().addAll(segment.getPlaces());
                reportProductSegmentData.setTrainCategory(RestReportsHelper.checkString(segment.getTrainCategory()));
                reportProductSegmentData.setBrand(RestReportsHelper.checkString(segment.getBrand()));
                reportProductSegmentData.setSegmentRouteLine(RestReportsHelper.getRoutForSegment(segment.getDepartureStation() != null ? segment.getDepartureStation().getCaption() : "", segment.getArriveStation() != null ? segment.getArriveStation().getCaption() : ""));
                reportProductSegmentData.setTravelersCount(product.getPassengers().size());
                record.getSegments().add(reportProductSegmentData);
            });
        } else if (prod instanceof AeroexpressTicket) {
            GeoLocation departureCity;
            GeoLocation arrivalCity;
            AeroexpressTicket product = (AeroexpressTicket)prod;
            ReportProductSegmentData reportSegment = RestReportsHelper.getReportProductSegmentDataZero();
            reportSegment.setSegmentUid(RestReportsHelper.checkString(product.getUid()));
            reportSegment.setDepartureLocation(RestReportsHelper.convertReference(product.getDepartureLocation(), isDemon));
            reportSegment.setArriveLocation(RestReportsHelper.convertReference(product.getArrivalLocation(), isDemon));
            reportSegment.setStartDate(product.getDepartureDate() == null ? "" : ReportProductCommonFieldsProcessor.dateTimeFormat.format(MiscUtil.toLocalDateTime((Date)product.getDepartureDate())));
            reportSegment.setClassOfService(RestReportsHelper.checkString(product.getClassOfService() != null ? product.getClassOfService().name() : ""));
            reportSegment.setArriveCityCode("");
            if (product.getArrivalLocation() != null && (arrivalCity = DictHelper.findCity((DictionaryReference)product.getArrivalLocation())) != null) {
                reportSegment.setArriveCityCode(arrivalCity.getCode());
            }
            reportSegment.setDepartCityCode("");
            if (product.getDepartureLocation() != null && (departureCity = DictHelper.findCity((DictionaryReference)product.getDepartureLocation())) != null) {
                reportSegment.setDepartCityCode(departureCity.getCode());
            }
            reportSegment.setStatus(RestReportsHelper.checkString(product.getStatus().name()));
            reportSegment.setSegmentRouteLine(RestReportsHelper.getRoutForSegment(product.getDepartureLocation() != null ? (isDemon.booleanValue() ? product.getDepartureLocation().toString(LocaleHelper.EN_LOCALE) : product.getDepartureLocation().getCaption()) : "", product.getArrivalLocation() != null ? (isDemon.booleanValue() ? product.getArrivalLocation().toString(LocaleHelper.EN_LOCALE) : product.getArrivalLocation().getCaption()) : ""));
            reportSegment.setTravelersCount(product.getTraveller() != null ? 1 : 0);
            record.getSegments().add(reportSegment);
        } else if (prod instanceof BusProduct) {
            BusProduct product = (BusProduct)prod;
            product.getSegments().forEach(segment -> {
                ReportProductSegmentData reportProductSegmentData = RestReportsHelper.getReportProductSegmentDataZero();
                reportProductSegmentData.setSegmentUid(RestReportsHelper.checkString(segment.getUid()));
                reportProductSegmentData.setStartDate(segment.getDepartureDate() == null ? "" : ReportProductCommonFieldsProcessor.dateTimeFormat.format(MiscUtil.toLocalDateTime((Date)segment.getDepartureDate())));
                reportProductSegmentData.setEndDate(segment.getArrivalDate() == null ? "" : ReportProductCommonFieldsProcessor.dateTimeFormat.format(MiscUtil.toLocalDateTime((Date)segment.getArrivalDate())));
                Integer segmentNumber = null;
                try {
                    segmentNumber = Integer.parseInt(segment.getNumber());
                }
                catch (NumberFormatException e) {
                    segmentNumber = 0;
                }
                reportProductSegmentData.setNumber(segmentNumber.intValue());
                reportProductSegmentData.setAddInfo(RestReportsHelper.checkString(segment.getAddInfo()));
                reportProductSegmentData.setDurationInMinutes(RestReportsHelper.intFromInteger(segment.getWayTimeMinutes()));
                reportProductSegmentData.getPlaces().addAll(segment.getPlaces());
                reportProductSegmentData.setBrand(RestReportsHelper.checkString(segment.getBrand()));
                reportProductSegmentData.setSegmentRouteLine(RestReportsHelper.getRoutForSegment(segment.getDeparture() != null ? segment.getDeparture().getCaption() : "", segment.getArrival() != null ? segment.getArrival().getCaption() : ""));
                reportProductSegmentData.setTravelersCount(product.getTravellers().size());
                record.getSegments().add(reportProductSegmentData);
            });
        }
    }
}

