/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.GetBookingFileResult;
import com.gridnine.xtrip.server.model.rest.reports.ReportPassengerData;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import java.math.BigDecimal;
import java.util.HashMap;

public class ReportProductUpdateTotalOfRelatedSellProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetBookingFileResult result = (GetBookingFileResult)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESULT);
        HashMap reportProductMap = new HashMap();
        result.getBookingFile().getProducts().forEach(reportProduct -> {
            if (ProductStatus.SELL.name().equals(reportProduct.getStatus())) {
                reportProductMap.put(reportProduct.getProductUid(), reportProduct);
            }
        });
        EntityContainer bfCont = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        HashMap productMap = new HashMap();
        ((BookingFile)bfCont.getEntity()).getReservations().stream().flatMap(it -> it.getProducts().stream()).forEach(prod -> productMap.put(prod.getUid(), prod));
        result.getBookingFile().getProducts().forEach(reportProduct -> {
            if (ProductStatus.REFUND.name().equals(reportProduct.getStatus())) {
                BaseProduct product = (BaseProduct)productMap.get(reportProduct.getProductUid());
                ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
                BaseProduct sell = handler.getPreviousProduct(product);
                ReportProduct sellProduct = sell == null ? null : (ReportProduct)reportProductMap.get(sell.getUid());
                reportProduct.setTotalOfRelatedSell(sellProduct == null || handler.getTicketType(sell) == TicketType.FAKE ? reportProduct.getTotal().negate() : sellProduct.getTotal());
                reportProduct.setPriceRetention(sellProduct == null || handler.getTicketType(sell) == TicketType.FAKE ? BigDecimal.ZERO : sellProduct.getEquivalentFare().add(sellProduct.getTaxesSum()).add(reportProduct.getEquivalentFare()).add(reportProduct.getTaxesSum()));
                for (ReportPassengerData refundPd : reportProduct.getPassengers()) {
                    if (sellProduct == null || handler.getTicketType(sell) == TicketType.FAKE) {
                        refundPd.setPriceRetention(BigDecimal.ZERO);
                        continue;
                    }
                    String stUid = refundPd.getTravellerUid().replace(reportProduct.getProductUid(), "");
                    ReportPassengerData sellPd = sellProduct.getPassengers().stream().filter(ep -> ep.getTravellerUid() != null && stUid.equals(ep.getTravellerUid().replace(sell.getUid(), ""))).findFirst().orElse(null);
                    if (sellPd == null && sellProduct.getPassengers().size() == 1) {
                        sellPd = (ReportPassengerData)sellProduct.getPassengers().get(0);
                    }
                    if (sellPd == null) continue;
                    refundPd.setPriceRetention(sellPd.getEquivalentFare().add(sellPd.getTaxesSum()).add(refundPd.getEquivalentFare()).add(refundPd.getTaxesSum()));
                }
            }
        });
    }
}

