/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getBookingFile.products;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.GetBookingFileResult;
import com.gridnine.xtrip.server.model.rest.reports.ReportPassengerData;
import com.gridnine.xtrip.server.model.rest.reports.ReportProduct;
import java.math.BigDecimal;
import java.util.HashMap;

public class SwapExchangeProductsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bfCont = (EntityContainer)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.BOOKING_FILE_CONTAINER);
        GetBookingFileResult result = (GetBookingFileResult)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESULT);
        HashMap reportProductMap = new HashMap();
        result.getBookingFile().getProducts().forEach(prod -> reportProductMap.put(prod.getProductUid(), prod));
        HashMap exchangeMap = new HashMap();
        ((BookingFile)bfCont.getEntity()).getReservations().forEach(res -> res.getProducts().forEach(prod -> {
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)prod);
            if (handler.getStatus(prod) == ProductStatus.SELL && handler.getPreviousProduct(prod) != null && handler.getStatus(handler.getPreviousProduct(prod)) == ProductStatus.EXCHANGE) {
                exchangeMap.put(prod.getUid(), handler.getPreviousProduct(prod).getUid());
            }
        }));
        exchangeMap.entrySet().forEach(entry -> {
            ReportProduct sell = (ReportProduct)reportProductMap.get(entry.getKey());
            ReportProduct exchange = (ReportProduct)reportProductMap.get(entry.getValue());
            result.getBookingFile().getProducts().remove(exchange);
            sell.setStatus(ProductStatus.EXCHANGE.name());
            sell.setInExchangeTo(exchange.getTicketNumber());
            sell.setSupplierCommission(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getSupplierCommission(), exchange.getSupplierCommission()}));
            sell.setAgencyFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getAgencyFee(), exchange.getAgencyFee()}));
            sell.setAgencyFeeVat(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getAgencyFeeVat(), exchange.getAgencyFeeVat()}));
            sell.setBaseFare(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getBaseFare(), exchange.getBaseFare()}));
            sell.setEquivalentFare(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getEquivalentFare(), exchange.getEquivalentFare()}));
            sell.setPrice(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getPrice(), exchange.getPrice()}));
            sell.setPriceVat(SwapExchangeProductsProcessor.getPriceVat(sell.getPriceVat(), exchange.getPriceVat()));
            sell.setSupplierFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getSupplierFee(), exchange.getSupplierFee()}));
            sell.setSupplierFeeVat(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getSupplierFeeVat(), exchange.getSupplierFeeVat()}));
            sell.setTaxesSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getTaxesSum(), exchange.getTaxesSum()}));
            sell.setTotal(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getTotal(), exchange.getTotal()}));
            sell.setFirstClientFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getFirstClientFee(), exchange.getFirstClientFee()}));
            sell.setSecondClientFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getSecondClientFee(), exchange.getSecondClientFee()}));
            sell.setSecondSubagencyFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getSecondSubagencyFee(), exchange.getSecondSubagencyFee()}));
            sell.setFirstSubagencyFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getFirstSubagencyFee(), exchange.getFirstSubagencyFee()}));
            sell.setTaxRI(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getTaxRI(), exchange.getTaxRI()}));
            sell.setRetailFopSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getRetailFopSum(), exchange.getRetailFopSum()}));
            sell.setCashFopSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getCashFopSum(), exchange.getCashFopSum()}));
            sell.setTaxForBlank(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getTaxForBlank(), exchange.getTaxForBlank()}));
            sell.setTaxForBlankVAT(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getTaxForBlankVAT(), exchange.getTaxForBlankVAT()}));
            sell.setAdditionalServicesSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getAdditionalServicesSum(), exchange.getAdditionalServicesSum()}));
            sell.setTripartiteDiscount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getTripartiteDiscount(), exchange.getTripartiteDiscount()}));
            sell.setEarlyCheckInCost(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getEarlyCheckInCost(), exchange.getEarlyCheckInCost()}));
            sell.setLateCheckOutCost(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sell.getLateCheckOutCost(), exchange.getLateCheckOutCost()}));
            sell.getPassengers().forEach(sp -> {
                String stUid = sp.getTravellerUid().replace(sell.getProductUid(), "");
                ReportPassengerData epd = exchange.getPassengers().stream().filter(ep -> ep.getTravellerUid() != null && stUid.equals(ep.getTravellerUid().replace(exchange.getProductUid(), ""))).findFirst().orElse(null);
                if (epd == null && exchange.getPassengers().size() == 1) {
                    epd = (ReportPassengerData)exchange.getPassengers().get(0);
                }
                if (epd != null) {
                    sp.setSupplierCommission(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getSupplierCommission(), epd.getSupplierCommission()}));
                    sp.setAgencyFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getAgencyFee(), epd.getAgencyFee()}));
                    sp.setAgencyFeeVat(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getAgencyFeeVat(), epd.getAgencyFeeVat()}));
                    sp.setSubagencyFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getSubagencyFee(), epd.getSubagencyFee()}));
                    sp.setBaseFare(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getBaseFare(), epd.getBaseFare()}));
                    sp.setEquivalentFare(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getEquivalentFare(), epd.getEquivalentFare()}));
                    sp.setPrice(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getPrice(), epd.getPrice()}));
                    sp.setSubagencyPrice(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getSubagencyPrice(), epd.getSubagencyPrice()}));
                    sp.setPriceVat(SwapExchangeProductsProcessor.getPriceVat(sp.getPriceVat(), epd.getPriceVat()));
                    sp.setSupplierFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getSupplierFee(), epd.getSupplierFee()}));
                    sp.setSupplierFeeVat(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getSupplierFeeVat(), epd.getSupplierFeeVat()}));
                    sp.setTaxesSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getTaxesSum(), epd.getTaxesSum()}));
                    sp.setTotal(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getTotal(), epd.getTotal()}));
                    sp.setSubagencyTotal(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getSubagencyTotal(), epd.getSubagencyTotal()}));
                    sp.setFirstClientFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getFirstClientFee(), epd.getFirstClientFee()}));
                    sp.setSecondClientFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getSecondClientFee(), epd.getSecondClientFee()}));
                    sp.setSecondSubagencyFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getSecondSubagencyFee(), epd.getSecondSubagencyFee()}));
                    sp.setTechnicalFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getTechnicalFee(), epd.getTechnicalFee()}));
                    sp.setAgencyBonusDiscount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getAgencyBonusDiscount(), epd.getAgencyBonusDiscount()}));
                    sp.setFirstSubagencyFee(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getFirstSubagencyFee(), epd.getFirstSubagencyFee()}));
                    sp.setTaxRI(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getTaxRI(), epd.getTaxRI()}));
                    sp.setRetailFopSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getRetailFopSum(), epd.getRetailFopSum()}));
                    sp.setCashFopSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getCashFopSum(), epd.getCashFopSum()}));
                    sp.setTaxForBlank(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getTaxForBlank(), epd.getTaxForBlank()}));
                    sp.setTaxForBlankVAT(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getTaxForBlankVAT(), epd.getTaxForBlankVAT()}));
                    sp.setAdditionalServicesSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getAdditionalServicesSum(), epd.getAdditionalServicesSum()}));
                    sp.setTripartiteDiscount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getTripartiteDiscount(), epd.getTripartiteDiscount()}));
                    sp.setEarlyCheckInCost(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getEarlyCheckInCost(), epd.getEarlyCheckInCost()}));
                    sp.setLateCheckOutCost(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sp.getLateCheckOutCost(), epd.getLateCheckOutCost()}));
                }
            });
        });
    }

    private static BigDecimal getPriceVat(BigDecimal sellPriceVat, BigDecimal exPriceVat) {
        BigDecimal priceVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{sellPriceVat, exPriceVat});
        if (MiscUtil.guarded((BigDecimal)priceVat).compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        return priceVat;
    }
}

