/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.getModifiedBookingsMarkerObjectsUids;

import com.gridnine.xtrip.common.ibecorp.storage.XreportsBookingMarkerObject;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.ibecorp.rest.reports.getModifiedBookingsMarkerObjectsUids.GetModifiedBookingsMarkerObjectsUidsValidator;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.GetModifiedBookingsMarkerObjectsUidsParameters;
import com.gridnine.xtrip.server.model.rest.reports.GetModifiedBookingsMarkerObjectsUidsResult;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GetModifiedBookingsMarkerObjectsUidsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetModifiedBookingsMarkerObjectsUidsResult result;
        GetModifiedBookingsMarkerObjectsUidsParameters params = (GetModifiedBookingsMarkerObjectsUidsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        List<String> messages = GetModifiedBookingsMarkerObjectsUidsValidator.validateParameters(params);
        if (this.log.isDebugEnabled()) {
            this.log.debug("searching booking files  limit = " + params.getLimit());
        }
        messages.forEach(s -> this.logError(ctx, (String)s, null, new Object[0]));
        if (messages.isEmpty()) {
            result = this.searchBookingFilesUids(params);
        } else {
            result = new GetModifiedBookingsMarkerObjectsUidsResult();
            result.getErrorMessages().addAll(messages);
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("got error message %s", messages.get(0)));
            }
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private GetModifiedBookingsMarkerObjectsUidsResult searchBookingFilesUids(GetModifiedBookingsMarkerObjectsUidsParameters params) {
        SearchQuery query = new SearchQuery();
        query.setLimit(params.getLimit());
        query.getCriteria().getOrders().put(BaseAsset.Property.modified.name(), SortOrder.DESC);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)XreportsBookingMarkerObject.Property.deleted.name(), (Object)Boolean.FALSE));
        HashSet<String> bookingUids = new HashSet<String>();
        LinkedHashMap<String, String> deletedUids = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> returnedUids = new LinkedHashMap<String, String>();
        List data = AssetsStorage.get().search(XreportsBookingMarkerObject.class, query).getData();
        GetModifiedBookingsMarkerObjectsUidsResult result = new GetModifiedBookingsMarkerObjectsUidsResult();
        for (XreportsBookingMarkerObject obj : data) {
            if (bookingUids.contains(obj.getBookingUid())) {
                AssetsStorage.get().delete((BaseAsset)obj);
                if (!this.log.isDebugEnabled()) continue;
                deletedUids.put(obj.getUid(), obj.getBookingUid());
                continue;
            }
            bookingUids.add(obj.getBookingUid());
            if (this.log.isDebugEnabled()) {
                returnedUids.put(obj.getUid(), obj.getBookingUid());
            }
            result.getMarkerObjectsUids().add(obj.getUid());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("duplicated objects:" + this.toText(deletedUids));
            this.log.debug("returned objects: " + this.toText(returnedUids));
        }
        return result;
    }

    private String toText(Map<String, String> deletedUids) {
        StringBuilder sb = new StringBuilder();
        deletedUids.forEach((key, value) -> sb.append(String.format("\n%s->%s", key, value)));
        return sb.toString();
    }
}

