/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.xreports;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.util.AuthUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.XreportsAuthorizeParameters;
import com.gridnine.xtrip.server.model.rest.reports.XreportsAuthorizeResponse;
import java.util.Locale;

public class XreportsAuthorizeProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        XreportsAuthorizeParameters params = (XreportsAuthorizeParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        XreportsAuthorizeResponse result = new XreportsAuthorizeResponse();
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        try {
            LogicalStorage.get().authorize(params.getLogin(), params.getPassword().toCharArray());
        }
        catch (Exception e) {
            result.setAuthorized(false);
            return;
        }
        EntityContainer personCtr = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)params.getLogin());
        if (personCtr == null) {
            result.setAuthorized(false);
            return;
        }
        EntityContainer employment = ProfileHelper.getMainEmployment((Person)((Person)personCtr.getEntity()));
        if (employment == null) {
            result.setAuthorized(false);
            return;
        }
        String authToken = AuthUtil.buildAuthToken((String)params.getLogin(), (char[])params.getPassword().toCharArray());
        result.setToken(authToken);
        result.setAuthorized(true);
        result.setDisplayName(PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)((PersonalLocalizableName)personCtr.getEntity()), (boolean)true, (Locale)LocaleHelper.RU_LOCALE, (boolean)false));
    }
}

