/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.xreports;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.XreportsClientStatisticsParameters;
import com.gridnine.xtrip.server.model.rest.reports.XreportsClientStatisticsResponse;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class XreportsClientStatisticsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        XreportsClientStatisticsParameters params = (XreportsClientStatisticsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        XreportsClientStatisticsResponse result = new XreportsClientStatisticsResponse();
        HashSet<String> udids = new HashSet<String>();
        HashSet<String> afs = new HashSet<String>();
        if ("HOLDING".equals(params.getType())) {
            List organizations = ProfileHelper.getHoldingOrganizations(Collections.singletonList(new EntityReference(params.getUid(), Holding.class, "")));
            for (EntityReference orgRef : organizations) {
                this.updateValues(udids, afs, (EntityReference<Organization>)orgRef);
            }
        } else {
            this.updateValues(udids, afs, (EntityReference<Organization>)new EntityReference(params.getUid(), Organization.class, null));
        }
        result.getAfs().addAll(afs);
        result.getUdids().addAll(udids);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private void updateValues(Set<String> udids, Set<String> afs, EntityReference<Organization> organizationEntityReference) {
        EntityContainer orgCtr = EntityStorage.get().resolve(organizationEntityReference);
        if (orgCtr == null) {
            return;
        }
        for (CostCode cc : ((Organization)orgCtr.getEntity()).getCostCodes()) {
            if (cc.getCostCodeProperties() == null || cc.getCostCodeProperties().getCategory() == null) continue;
            udids.add(cc.getCostCodeProperties().getCategory().getCode());
        }
        for (AFSType afsItem : StatisticsHelper.getInputableAfsTypesFromString((String)((Organization)orgCtr.getEntity()).getAfsSettings(), (boolean)false)) {
            afs.add(afsItem.name() + "_b");
        }
        for (AFSType afsItem : StatisticsHelper.getInputableAfsTypesFromString((String)((Organization)orgCtr.getEntity()).getAfsSettings(), (boolean)true)) {
            afs.add(afsItem.name() + "_t");
        }
        for (AFSType afsItem : ((Organization)orgCtr.getEntity()).getCalculatedStatisticSettings()) {
            afs.add(afsItem.name());
        }
    }
}

