/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.xreports;

import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.HoldingIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourceOperations;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.XreportsClientAutocompleteItem;
import com.gridnine.xtrip.server.model.rest.reports.XreportsClientAutocompleteParameters;
import com.gridnine.xtrip.server.model.rest.reports.XreportsClientAutocompleteResponse;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class XreportsClientsAutocompleteProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        XreportsClientAutocompleteParameters params = (XreportsClientAutocompleteParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        XreportsClientAutocompleteResponse result = new XreportsClientAutocompleteResponse();
        String login = (String)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.LOGIN);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        EntityContainer personCtr = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)login);
        EntityContainer employment = ProfileHelper.getMainEmployment((Person)((Person)personCtr.getEntity()));
        if (((Organization)employment.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT) && ((Organization)employment.getEntity()).getHolding() == null) {
            throw new Exception("client selection is not available");
        }
        List<XreportsClientAutocompleteItem> items = this.searchHoldings(params.getPattern(), params.getLimit(), params.getHoldingUid(), params.getSubagencyUid(), params.isSubagency(), (EntityContainer<Organization>)employment);
        ArrayList<XreportsClientAutocompleteItem> holdings = new ArrayList<XreportsClientAutocompleteItem>(items);
        if (items.size() < params.getLimit()) {
            items.addAll(this.searchOrganizations(params.getPattern(), params.getLimit() - items.size(), params.getHoldingUid(), params.getSubagencyUid(), params.isSubagency(), (EntityContainer<Organization>)employment, items));
        }
        if (!holdings.isEmpty()) {
            items.addAll(this.getHoldingsOrganizations(holdings));
        }
        if (((Organization)employment.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            ArrayList<XreportsClientAutocompleteItem> denyItems = new ArrayList<XreportsClientAutocompleteItem>();
            for (XreportsClientAutocompleteItem item : items) {
                EntityReference orgRef;
                Map proxyMap;
                if (employment.getUid().equals(item.getUid()) || AclHelper.isGranted((RestrictionResourceProxy)((RestrictionResourceProxy)(proxyMap = RestrictionsHelper.buildProxies((Object)(orgRef = new EntityReference(item.getUid(), Organization.class, "")), (String)IbeRestrictionEntityResources.ENTITY_REPORT_APPLICATION_HOLDING_ACCESS_ORGANIZATION.getId())).get(item.getUid())), (String)IbeRestrictionEntityResources.ENTITY_REPORT_APPLICATION_HOLDING_ACCESS_ORGANIZATION.getId(), (String)login, (String)StandardAclResourceOperations.VIEW.getId(), Collections.emptyList())) continue;
                denyItems.add(item);
            }
            items.removeAll(denyItems);
        }
        Collections.sort(items, new Comparator<XreportsClientAutocompleteItem>(){

            @Override
            public int compare(XreportsClientAutocompleteItem o1, XreportsClientAutocompleteItem o2) {
                int res = this.getTypeIndex(o1) - this.getTypeIndex(o2);
                if (res != 0) {
                    return res;
                }
                return TextUtil.compare((String)o1.getDisplayName(), (String)o1.getDisplayName(), (boolean)false, (boolean)false);
            }

            private int getTypeIndex(XreportsClientAutocompleteItem o1) {
                if ("HOLDING".equals(o1.getType())) {
                    return 0;
                }
                return 1;
            }
        });
        result.getItems().addAll(items);
    }

    private List<XreportsClientAutocompleteItem> getHoldingsOrganizations(List<XreportsClientAutocompleteItem> holdings) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)OrganizationIndex.Property.holding.name(), (Object[])holdings.stream().map(XreportsClientAutocompleteItem::getUid).toArray()));
        ArrayList<XreportsClientAutocompleteItem> result = new ArrayList<XreportsClientAutocompleteItem>();
        for (OrganizationIndex idx : EntityStorage.get().search(OrganizationIndex.class, query).getData()) {
            EntityReference holdingRef;
            XreportsClientAutocompleteItem item = new XreportsClientAutocompleteItem();
            item.setDisplayName(idx.getShortName().toString());
            if (item.getDisplayName() == null) {
                item.setDisplayName(idx.getName().toString());
            }
            if ((holdingRef = idx.getHolding()) != null) {
                item.setRelation(holdingRef.getCaption());
            } else {
                item.setRelation("");
            }
            item.setUid(idx.getSource().getUid());
            item.setType("ORGANIZATION");
            result.add(item);
        }
        return result;
    }

    private List<XreportsClientAutocompleteItem> searchOrganizations(String pattern, int limit, String holdingUid, String subagencyUid, Boolean isSubagency, EntityContainer<Organization> employment, List<XreportsClientAutocompleteItem> holdings) {
        if (((Organization)employment.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT) && ((Organization)employment.getEntity()).getHolding() == null) {
            return new ArrayList<XreportsClientAutocompleteItem>();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)(isSubagency != null && isSubagency != false ? OrganizationType.AGENCY : OrganizationType.CORPORATE_CLIENT)));
        EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
        if (allClientsProfile != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)"containerUid", (Object)allClientsProfile.getUid()));
        }
        if (holdingUid != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.holding.name(), (Object)holdingUid));
        }
        if (subagencyUid != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.supplierUids.name(), (Object)subagencyUid));
        }
        if (!TextUtil.isBlank((String)pattern)) {
            query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)OrganizationIndex.Property.shortName.name(), (String)String.format("%%%s%%", pattern)));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.isNotEmpty((String)OrganizationIndex.Property.shortName.name()));
        }
        if (!holdings.isEmpty()) {
            query.getCriteria().getCriterions().add(SearchCriterion.not((SearchCriterion)SearchCriterion.in((String)OrganizationIndex.Property.holding.name(), (Object[])holdings.stream().map(XreportsClientAutocompleteItem::getUid).toArray())));
        }
        query.setLimit(limit);
        ArrayList<XreportsClientAutocompleteItem> result = new ArrayList<XreportsClientAutocompleteItem>();
        HashSet<String> newHoldingUids = new HashSet<String>();
        for (OrganizationIndex idx : EntityStorage.get().search(OrganizationIndex.class, query).getData()) {
            EntityReference holdingRef;
            XreportsClientAutocompleteItem item = new XreportsClientAutocompleteItem();
            item.setDisplayName(idx.getShortName().toString());
            if (item.getDisplayName() == null) {
                item.setDisplayName(idx.getName().toString());
            }
            if ((holdingRef = idx.getHolding()) != null) {
                item.setRelation(holdingRef.getCaption());
                if (!newHoldingUids.contains(holdingRef.getUid())) {
                    newHoldingUids.add(holdingRef.getUid());
                    XreportsClientAutocompleteItem holdingItem = new XreportsClientAutocompleteItem();
                    holdingItem.setDisplayName(holdingRef.getCaption());
                    holdingItem.setUid(holdingRef.getUid());
                    holdingItem.setRelation("");
                    holdingItem.setType("HOLDING");
                    result.add(holdingItem);
                }
            } else {
                item.setRelation("");
            }
            item.setUid(idx.getSource().getUid());
            item.setType("ORGANIZATION");
            result.add(item);
        }
        return result;
    }

    private List<XreportsClientAutocompleteItem> searchHoldings(String pattern, int limit, String holdingUid, String subagencyUid, Boolean isSubagency, EntityContainer<Organization> employment) {
        if (((Organization)employment.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT) && ((Organization)employment.getEntity()).getHolding() == null || isSubagency.booleanValue()) {
            return new ArrayList<XreportsClientAutocompleteItem>();
        }
        SearchQuery query = new SearchQuery();
        if (!TextUtil.isBlank((String)pattern)) {
            query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)HoldingIndex.Property.shortName.name(), (String)String.format("%%%s%%", pattern)));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.isNotEmpty((String)HoldingIndex.Property.shortName.name()));
        }
        if (((Organization)employment.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)((Organization)employment.getEntity()).getHolding().getUid()));
        } else if (holdingUid != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)holdingUid));
        }
        if (subagencyUid != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)HoldingIndex.Property.subagencyUids.name(), (Object)subagencyUid));
        }
        ArrayList<XreportsClientAutocompleteItem> result = new ArrayList<XreportsClientAutocompleteItem>();
        query.setLimit(limit);
        for (HoldingIndex idx : EntityStorage.get().search(HoldingIndex.class, query).getData()) {
            XreportsClientAutocompleteItem item = new XreportsClientAutocompleteItem();
            item.setDisplayName(idx.getShortName().toString());
            item.setUid(idx.getSource().getUid());
            item.setRelation("");
            item.setType("HOLDING");
            result.add(item);
        }
        return result;
    }
}

