/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.xreports;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.XreportsClientUdidsParameters;
import com.gridnine.xtrip.server.model.rest.reports.XreportsClientUdidsResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class XreportsGetClientUdidsProcessor
extends BaseProcessor {
    private final String ORGANIZATION_UID = "navigationKey";

    public void process(MessageContext ctx) throws Exception {
        XreportsClientUdidsParameters params = (XreportsClientUdidsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        XreportsClientUdidsResponse result = new XreportsClientUdidsResponse();
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        if (TextUtil.nonBlank((String)params.getClientId())) {
            result.getClientUdids().addAll(this.getUdids(params.getClientId()));
        }
    }

    private Collection<String> getUdids(String client) {
        ArrayList<String> result = new ArrayList<String>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)client));
        List orgs = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        for (OrganizationIndex inorg : orgs) {
            if (inorg == null || inorg.getSource() == null) continue;
            List costCodesProperties = ProfileHelper.getCostCodesProperties((EntityReference)inorg.getSource());
            result.addAll(costCodesProperties.stream().filter(Objects::nonNull).filter(ccp -> ccp.getCategory() != null && TextUtil.nonBlank((String)ccp.getCategory().getCaption())).map(ccp -> ccp.getCategory().getCaption()).collect(Collectors.toSet()));
        }
        return result;
    }
}

