/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.xreports;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.rest.reports.Client;
import com.gridnine.xtrip.server.model.rest.reports.XreportsGetClientsAndAccountParameters;
import com.gridnine.xtrip.server.model.rest.reports.XreportsGetClientsAndAccountResponse;
import java.util.List;
import java.util.stream.Collectors;

public class XreportsGetClientsAndAccountProcessor
extends BaseProcessor {
    private static final String KAM = "\u041a\u0410\u041c";

    public void process(MessageContext ctx) throws Exception {
        XreportsGetClientsAndAccountParameters parameters = (XreportsGetClientsAndAccountParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        XreportsGetClientsAndAccountResponse result = new XreportsGetClientsAndAccountResponse();
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT));
        if (parameters.getHoldingUid() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.holding.name(), (Object)parameters.getHoldingUid()));
        }
        if (parameters.getSubagencyUid() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.supplierUids.name(), (Object)parameters.getSubagencyUid()));
        }
        List indices = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        result.getClients().addAll(indices.stream().map(oi -> {
            Client client = new Client();
            client.setUid(oi.getSource().getUid());
            client.setCaption(oi.getShortName() != null ? oi.getShortName().toString() : (oi.getName() != null ? oi.getName().toString() : ""));
            EntityContainer organization = EntityStorage.get().resolve(oi.getSource());
            if (EntityStorageHelper.nonEmpty((EntityContainer)organization)) {
                List managers = ((Organization)organization.getEntity()).getMetadata().stream().filter(m -> m.getKey().getCode().equals("KEY_ORGANIZATION_ACCOUNT_MANAGER") && TextUtil.isSame((String)m.getRemarks(), (String)KAM) && m.getValue() != null && m.getValue() instanceof EntityReference).map(m -> ((EntityReference)m.getValue()).getCaption()).collect(Collectors.toList());
                client.getAccountManagers().addAll(managers);
            } else {
                client.getAccountManagers().addAll(oi.getAccountManagers().stream().map(EntityReference::getCaption).collect(Collectors.toList()));
            }
            return client;
        }).collect(Collectors.toList()));
    }
}

