/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.xreports;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.xreports.XreportsIntegrationSettings;
import com.gridnine.xtrip.server.ibecorp.helpers.XreportsIntegrationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class XreportsOptimizeKettlePackSizeProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        boolean success;
        XreportsIntegrationSettings settings = XreportsIntegrationHelper.getSettings();
        if (settings.isCustomizePackSize()) {
            return;
        }
        int optimalSize = XreportsIntegrationHelper.getOptimalKettlePackSize();
        int currentSize = XreportsIntegrationHelper.getKettlePackSize();
        if ((double)Math.abs(currentSize - optimalSize) / (1.0 * (double)currentSize) > 0.1 && (success = XreportsIntegrationHelper.setKettlePackSize(optimalSize))) {
            settings.setPackSize(optimalSize);
            EntityContainer settingsCtr = EntityContainer.create((BaseEntity)settings, (String)"xreports-integration-settings-uid");
            settingsCtr.getVersionInfo().setDataSource("optimize-kettle");
            EntityStorage.get().save(settingsCtr, true);
        }
    }
}

