/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rest.reports.xreports;

import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.ibecorp.rules.ReportApplicationActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourceOperations;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.rest.reports.IbusReportsRestContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import com.gridnine.xtrip.server.model.rest.reports.XreportsProfileResponse;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class XreportsProfileProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String login = (String)ctx.getMandatoryObject((Enum)IbusReportsRestContextKeys.LOGIN);
        EntityContainer personCtr = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)login);
        EntityContainer employment = ProfileHelper.getMainEmployment((Person)((Person)personCtr.getEntity()));
        XreportsProfileResponse result = new XreportsProfileResponse();
        result.setShowTuiReports(AppConfiguration.get().isShowTuiReports());
        result.setEmployment(employment.toReference());
        result.setShowReports(AclHelper.isGranted(null, (String)IbeRestrictionEntityResources.ENTITY_REPORT_APPLICATION.getId(), (String)login, (String)StandardAclResourceOperations.ALL.getId(), Collections.emptyList()));
        result.setHolding(((Organization)employment.getEntity()).getHolding());
        boolean contractsApplied = false;
        List pairList = ProfileHelper.getNewContracts(null, null, (EntityReference)employment.toReference(), null, (Date)new Date());
        RuleProxy reportApplicationProxy = new RuleProxy();
        ReportApplicationActionSet actionSet = new ReportApplicationActionSet();
        reportApplicationProxy.setProxyType(Targets.REPORT_APPLICATION.getId());
        reportApplicationProxy.setProxyDate(new Date());
        reportApplicationProxy.setPropertySet(new Object());
        reportApplicationProxy.setActionSet((Object)actionSet);
        boolean hasSubagencyOrClientContract = false;
        block0: for (MiscUtil.Pair contract : pairList) {
            if (((Contract)((EntityContainer)contract.getFirst()).getEntity()).getContractType() == ContractType.SUBAGENCY || ((Contract)((EntityContainer)contract.getFirst()).getEntity()).getContractType() == ContractType.CLIENT) {
                hasSubagencyOrClientContract = true;
            }
            List rules = ProfileHelper.getRuleContainers((EntityContainer)((EntityContainer)contract.getFirst()), (Date)new Date());
            for (EntityContainer rule : rules) {
                RuleEngine.applyRules(Collections.singletonList(reportApplicationProxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet());
                if (actionSet.getAvailableReports() == null) continue;
                contractsApplied = true;
                continue block0;
            }
        }
        result.setShowAllSales(!hasSubagencyOrClientContract);
        if (contractsApplied) {
            result.getAvailableReportUids().addAll(actionSet.getAvailableReports().getSelectedReportsIds());
            result.setContractsApplied(true);
        } else {
            result.setContractsApplied(false);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        if (((Organization)employment.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            result.setRole(((Organization)employment.getEntity()).getHolding() == null ? "EMPLOYEE_OF_CLIENT" : "EMPLOYEE_OF_HOLDING");
        } else {
            result.setRole("EMPLOYEE_OF_AGENCY");
        }
        if (((Organization)employment.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            if (((Organization)employment.getEntity()).getHolding() != null && AclHelper.isGranted(null, (String)IbeRestrictionEntityResources.ENTITY_REPORT_APPLICATION_HOLDING_ACCESS_ORGANIZATION.getId(), (String)login, (String)StandardAclResourceOperations.VIEW.getId(), Collections.emptyList())) {
                result.setSalesVisibility("HOLDING");
            } else {
                result.setSalesVisibility("CLIENT");
            }
        } else if (!hasSubagencyOrClientContract) {
            result.setSalesVisibility("AGENCY");
        } else {
            result.setSalesVisibility("SUBAGENCY");
        }
    }
}

