/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rules;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.test.TestFlightBuilder;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.GeneralPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.test.IbeCorpTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionCategoryBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionPropertiesBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestFeePropertiesBuilder;
import org.junit.Assert;
import org.junit.Test;

public class Ibecorp353Test
extends IbeCorpTestBase {
    private DictionaryReference<CommissionCategory> feeCategory;
    private DictionaryReference<CommissionCategory> commissionCategory;
    private EntityReference<FeeProperties> vendorFeeProperties;
    private EntityReference<FeeProperties> agencyFeeProperties;
    private EntityReference<FeeProperties> subagencyFeeProperties;
    private EntityReference<CommissionProperties> commissionProperties;

    @Test
    public void testFlightOwn() throws Exception {
        this.createProfiles();
        DictionaryReference adultPassengerType = DictHelper.getAdultPassengerType();
        Flight flight = new TestFlightBuilder().agency(TestBookingFileBuilder.agency).subagency(TestBookingFileBuilder.agency).supplier(TestBookingFileBuilder.blankOwner).blankOwner(TestBookingFileBuilder.blankOwner).seat(adultPassengerType, 1).fare(5200.0, adultPassengerType).tax("750", "T1", adultPassengerType).getEntity();
        this.applyRules(flight, this.headSalesContext);
        AviaPriceComponents components = AviaPriceComponents.builder(flight, PriceComponentsParameters.getTestComponentsParameters(this.headSalesContext)).build();
        this.testComponentsOwn(components);
    }

    @Test
    public void testFlightSubagent() throws Exception {
        this.createProfiles();
        DictionaryReference adultPassengerType = DictHelper.getAdultPassengerType();
        Flight flight = new TestFlightBuilder().agency(TestBookingFileBuilder.agency).subagency(TestBookingFileBuilder.subagency).supplier(TestBookingFileBuilder.blankOwner).blankOwner(TestBookingFileBuilder.blankOwner).seat(adultPassengerType, 1).fare(5200.0, adultPassengerType).tax("750", "T1", adultPassengerType).getEntity();
        this.applyRules(flight);
        AviaPriceComponents components = AviaPriceComponents.builder(flight, PriceComponentsParameters.getTestComponentsParameters(this.salesContext)).build();
        this.testComponentsSubagent(components);
    }

    @Test
    public void testProductOwn() throws Exception {
        this.createProfiles();
        EntityContainer bookingFile = new TestBookingFileBuilder().reservation().airProduct(false).subagency(TestBookingFileBuilder.agency).agency(TestBookingFileBuilder.agency).blankOwner(TestBookingFileBuilder.blankOwner).supplier(TestBookingFileBuilder.blankOwner).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).productCategory(ProductCategory.AIR).status(ProductStatus.SELL).blankType("555 ETKT").systemNumber("0000000001").carrier("SU").ticketType(TicketType.OWN).gdsCurrency("RUB").passengerType(DictHelper.getAdultPassengerType()).fare(5200.0).tax("750", "T1").end().end().create();
        ReservationPriceComponents components = ReservationPriceComponents.builder(AirProductHelper.getAviaReservation((EntityContainer)bookingFile), PriceComponentsParameters.getTestComponentsParameters(this.headSalesContext)).build();
        this.testComponentsOwn(components);
    }

    @Test
    public void testProductSubagent() throws Exception {
        this.createProfiles();
        EntityContainer bookingFile = new TestBookingFileBuilder().reservation().airProduct(false).subagency(TestBookingFileBuilder.subagency).agency(TestBookingFileBuilder.agency).blankOwner(TestBookingFileBuilder.blankOwner).supplier(TestBookingFileBuilder.blankOwner).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).productCategory(ProductCategory.AIR).status(ProductStatus.SELL).blankType("555 ETKT").systemNumber("0000000001").carrier("SU").ticketType(TicketType.OWN).gdsCurrency("RUB").passengerType(DictHelper.getAdultPassengerType()).fare(5200.0).tax("750", "T1").end().end().create();
        ReservationPriceComponents components = ReservationPriceComponents.builder(AirProductHelper.getAviaReservation((EntityContainer)bookingFile), PriceComponentsParameters.getTestComponentsParameters(this.salesContext)).build();
        this.testComponentsSubagent(components);
    }

    private void createProfiles() throws Exception {
        this.createCategories();
        this.createProperties();
        this.createContracts();
    }

    private void testComponentsOwn(GeneralPriceComponents components) {
        Assert.assertEquals((double)5200.0, (double)components.getTariff().doubleValue(), (double)0.001);
        Assert.assertEquals((double)750.0, (double)components.getTaxes().doubleValue(), (double)0.001);
        Assert.assertEquals((double)73.0, (double)components.getFee().doubleValue(), (double)0.001);
        Assert.assertEquals((double)6023.0, (double)components.getTotal().doubleValue(), (double)0.001);
    }

    private void testComponentsSubagent(GeneralPriceComponents components) {
        Assert.assertEquals((double)5200.0, (double)components.getTariff().doubleValue(), (double)0.001);
        Assert.assertEquals((double)750.0, (double)components.getTaxes().doubleValue(), (double)0.001);
        Assert.assertEquals((double)167.0, (double)components.getFee().doubleValue(), (double)0.001);
        Assert.assertEquals((double)6117.0, (double)components.getTotal().doubleValue(), (double)0.001);
    }

    private void createContracts() throws Exception {
        new TestContractBuilderBuilder().contractType(ContractType.VENDOR).name("Vendor contract").supplier(TestBookingFileBuilder.blankOwner).customer().customer(TestBookingFileBuilder.agency).paymentCurrency("RUB", CurrencyRateType.IATA, RoundingMode.MATH, RoundingValue.V_0_0_1).end().airFee(177.0, "RUB", this.vendorFeeProperties).airCommission(127.0, "RUB", this.commissionProperties).create();
        new TestContractBuilderBuilder().contractType(ContractType.SUBAGENCY).name("Subagency contract").supplier(TestBookingFileBuilder.agency).customer().customer(TestBookingFileBuilder.subagency).paymentCurrency("RUB", CurrencyRateType.IATA, RoundingMode.MATH, RoundingValue.V_0_0_1).end().airFee(86.0, "RUB", this.agencyFeeProperties).airCommission(74.0, "RUB", this.commissionProperties).create();
        new TestContractBuilderBuilder().contractType(ContractType.CLIENT).name("Client contract").supplier(TestBookingFileBuilder.subagency).customer().customer(TestBookingFileBuilder.client).paymentCurrency("RUB", CurrencyRateType.IATA, RoundingMode.MATH, RoundingValue.V_0_0_1).end().airFee(81.0, "RUB", this.subagencyFeeProperties).create();
        new TestContractBuilderBuilder().contractType(ContractType.CLIENT).name("Client contract").supplier(TestBookingFileBuilder.agency).customer().customer(TestBookingFileBuilder.client).paymentCurrency("RUB", CurrencyRateType.IATA, RoundingMode.MATH, RoundingValue.V_0_0_1).end().airFee(73.0, "RUB", this.subagencyFeeProperties).create();
    }

    private void createProperties() throws Exception {
        this.vendorFeeProperties = new TestFeePropertiesBuilder().displayName("Vendor Fee").calculationType(CalculationType.TICKET).calculationType(Operation.SELL).category(this.feeCategory).roundingMode(RoundingMode.MATH).roundingValue(RoundingValue.V_0_0_1).create().toReference();
        this.agencyFeeProperties = new TestFeePropertiesBuilder().displayName("Agency Fee").calculationType(CalculationType.TICKET).calculationType(Operation.SELL).chargeToClient(true).category(this.feeCategory).roundingMode(RoundingMode.MATH).roundingValue(RoundingValue.V_0_0_1).create().toReference();
        this.subagencyFeeProperties = new TestFeePropertiesBuilder().displayName("Subagency Fee").calculationType(CalculationType.TICKET).calculationType(Operation.SELL).category(this.feeCategory).roundingMode(RoundingMode.MATH).roundingValue(RoundingValue.V_0_0_1).create().toReference();
        this.commissionProperties = new TestCommissionPropertiesBuilder().displayName("Subagency Commission").calculationType(CalculationType.TICKET).category(this.commissionCategory).roundingMode(RoundingMode.MATH).roundingValue(RoundingValue.V_0_0_1).create().toReference();
    }

    private void createCategories() throws Exception {
        this.feeCategory = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("feeCategory")).translation("Agency Fee")).create();
        this.commissionCategory = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("commissionCategory")).translation("Agency Commission")).create();
    }
}

