/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rules;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.ibecorp.model.helpers.IbecorpFlightHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.gds.test.TestFlightBuilder;
import com.gridnine.xtrip.server.ibecorp.test.IbeCorpTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionCategoryBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestFeePropertiesBuilder;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class Ibecorp397Test
extends IbeCorpTestBase {
    private final EntityReference<Organization> suRef = new EntityReference("SU_container", Organization.class, "SU");
    private final String currency = "RUB";

    @Test
    public void testNoClientContract() throws Exception {
        DictionaryReference commissionCategory = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("fee")).translation("fe")).create();
        EntityReference subagentCommProperties = new TestFeePropertiesBuilder().category(commissionCategory).displayName("Subagent fee").type(FeeType.STANDARD).chargeToClient(true).create().toReference();
        new TestContractBuilderBuilder().contractType(ContractType.SUBAGENCY).supplier(TestBookingFileBuilder.agency).customer(TestBookingFileBuilder.subagency).airFee(10.0, "RUB", subagentCommProperties).create();
        DictionaryReference adultPassengerType = DictHelper.getAdultPassengerType();
        Flight flight = new TestFlightBuilder().blankOwner(this.suRef).fare(100.0, adultPassengerType).getEntity();
        this.applyRules(flight);
        BigDecimal fee = IbecorpFlightHelper.getCommissionsEquivalentAmount((Flight)flight, (ContractType)ContractType.CLIENT, (Set)GeneralProductHelper.feePropertyTypes, Collections.singletonMap(adultPassengerType, 1), (int)1, (String)"RUB");
        Assert.assertEquals((double)10.0, (double)fee.doubleValue(), (double)0.001);
    }

    @Test
    public void testNotTranslatedFee() throws Exception {
        DictionaryReference commissionCategory = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("fee")).translation("fe")).create();
        EntityReference subagentCommProperties = new TestFeePropertiesBuilder().category(commissionCategory).displayName("Subagent fee").type(FeeType.STANDARD).create().toReference();
        EntityReference clientFeeProp = new TestFeePropertiesBuilder().category(commissionCategory).displayName("Client fee").type(FeeType.STANDARD).create().toReference();
        new TestContractBuilderBuilder().contractType(ContractType.SUBAGENCY).supplier(TestBookingFileBuilder.agency).customer(TestBookingFileBuilder.subagency).airFee(10.0, "RUB", subagentCommProperties).create();
        new TestContractBuilderBuilder().contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.subagency).customer(TestBookingFileBuilder.client).airFee(20.0, "RUB", clientFeeProp).create();
        DictionaryReference adultPassengerType = DictHelper.getAdultPassengerType();
        Flight flight = new TestFlightBuilder().blankOwner(this.suRef).fare(100.0, adultPassengerType).getEntity();
        this.applyRules(flight);
        BigDecimal clientFee = IbecorpFlightHelper.getCommissionsEquivalentAmount((Flight)flight, (ContractType)ContractType.CLIENT, (Set)GeneralProductHelper.feePropertyTypes, Collections.singletonMap(adultPassengerType, 1), (int)1, (String)"RUB");
        Assert.assertEquals((double)20.0, (double)clientFee.doubleValue(), (double)0.001);
        BigDecimal subagentFee = IbecorpFlightHelper.getCommissionsEquivalentAmount((Flight)flight, (ContractType)ContractType.SUBAGENCY, (Set)GeneralProductHelper.feePropertyTypes, Collections.singletonMap(adultPassengerType, 1), (int)1, (String)"RUB");
        Assert.assertEquals((double)10.0, (double)subagentFee.doubleValue(), (double)0.001);
    }
}

