/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rules;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceData;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.gds.test.TestFlightBuilder;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.GeneralPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.test.IbeCorpTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionCategoryBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionPropertiesBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestCurrencyRateBuilder;
import com.gridnine.xtrip.server.model.test.TestFeePropertiesBuilder;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Ibecorp777Test
extends IbeCorpTestBase {
    private final String clientCurrency = "USD";
    private final String subagentCurrency = "EUR";
    private final String commissionCurrency = "RUB";
    private final String vendorCurrency = "RUB";
    private DictionaryReference<CommissionCategory> feeCategory;
    private DictionaryReference<CommissionCategory> commissionCategory;
    private EntityReference<FeeProperties> vendorFeeProperties;
    private EntityReference<FeeProperties> agencyFeeProperties;
    private EntityReference<FeeProperties> subagencyFeeProperties;
    private EntityReference<CommissionProperties> commissionProperties;

    @Test
    public void testFlight() throws Exception {
        this.createProfiles();
        DictionaryReference adultPassengerType = DictHelper.getAdultPassengerType();
        Flight flight = new TestFlightBuilder().subagency(TestBookingFileBuilder.subagency).agency(TestBookingFileBuilder.agency).supplier(TestBookingFileBuilder.blankOwner).blankOwner(TestBookingFileBuilder.blankOwner).seat(adultPassengerType, 1).fare(3000.0, adultPassengerType).tax("330", "T1", adultPassengerType).getEntity();
        this.applyRules(flight);
        AviaPriceComponents components = AviaPriceComponents.builder(flight, PriceComponentsParameters.getTestComponentsParameters(this.salesContext)).build();
        this.testComponents(components);
        Map contractRelations = FlightHelper.getContractRelations((Flight)flight, (ContractType)ContractType.SUBAGENCY);
        GdsContractRelationData gdsContractRelationData = (GdsContractRelationData)contractRelations.values().stream().findFirst().get();
        ContractRelationServiceData serviceData = gdsContractRelationData.getServiceData();
        BigDecimal fareValue = serviceData.getDetalization().getFare();
        BigDecimal taxes = serviceData.getDetalization().getTaxes().stream().map(SimpleTax::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal fees = gdsContractRelationData.getCommissions().stream().map(BaseCommission::getEquivalentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.testSubagentRelations(fareValue, taxes, fees);
    }

    private void testSubagentRelations(BigDecimal fareValue, BigDecimal taxes, BigDecimal fees) {
        Assert.assertEquals((double)42.25, (double)fareValue.doubleValue(), (double)0.001);
        Assert.assertEquals((double)4.65, (double)taxes.doubleValue(), (double)0.001);
        Assert.assertEquals((double)2.54, (double)fees.doubleValue(), (double)0.001);
    }

    @Test
    public void testProduct() throws Exception {
        this.createProfiles();
        EntityContainer bookingFile = new TestBookingFileBuilder().reservation().airProduct(false).subagency(TestBookingFileBuilder.subagency).agency(TestBookingFileBuilder.agency).blankOwner(TestBookingFileBuilder.blankOwner).supplier(TestBookingFileBuilder.blankOwner).salesPoint(TestBookingFileBuilder.agencySalesPoint).agent(TestBookingFileBuilder.agencyAgent).productCategory(ProductCategory.AIR).status(ProductStatus.SELL).blankType("555 ETKT").systemNumber("0000000001").carrier("SU").ticketType(TicketType.OWN).gdsCurrency("RUB").passengerType(DictHelper.getAdultPassengerType()).fare(3000.0).tax("330", "T1").end().end().create();
        ReservationPriceComponents components = ReservationPriceComponents.builder(AirProductHelper.getAviaReservation((EntityContainer)bookingFile), PriceComponentsParameters.getTestComponentsParameters(this.salesContext)).build();
        this.testComponents(components);
        Product product = (Product)AirProductHelper.getAviaReservation((EntityContainer)bookingFile).getProducts().get(0);
        AirProductContractRelationData airProductContractRelationData = ((List)product.getValue("contractRelations")).stream().filter(relationData -> GeneralProductHelper.getContractType((EntityReference)relationData.getDescription()) == ContractType.SUBAGENCY).findFirst().get();
        ContractRelationServiceData serviceData = airProductContractRelationData.getServiceData();
        BigDecimal fareValue = serviceData.getDetalization().getFare();
        BigDecimal taxes = serviceData.getDetalization().getTaxes().stream().map(SimpleTax::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal fees = airProductContractRelationData.getCommissions().stream().map(BaseCommission::getEquivalentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.testSubagentRelations(fareValue, taxes, fees);
    }

    private void testComponents(GeneralPriceComponents components) {
        Assert.assertEquals((Object)"USD", (Object)components.getCurrency());
        Assert.assertEquals((Object)"EUR", (Object)components.getSubagentCurrency());
        Assert.assertEquals((double)46.15, (double)components.getTariff().doubleValue(), (double)0.001);
        Assert.assertEquals((double)5.08, (double)components.getTaxes().doubleValue(), (double)0.001);
        Assert.assertEquals((double)2.69, (double)components.getFee().doubleValue(), (double)0.001);
        Assert.assertEquals((double)53.92, (double)components.getTotal().doubleValue(), (double)0.001);
        Assert.assertEquals((double)48.31, (double)components.getTotalSubagent().doubleValue(), (double)0.001);
    }

    private void createProfiles() throws Exception {
        this.createCurrencyRates();
        this.createCategories();
        this.createProperties();
        this.createContracts();
    }

    private void createContracts() throws Exception {
        new TestContractBuilderBuilder().contractType(ContractType.VENDOR).name("Vendor contract").supplier(TestBookingFileBuilder.blankOwner).customer().customer(TestBookingFileBuilder.agency).paymentCurrency("RUB", CurrencyRateType.IATA, RoundingMode.MATH, RoundingValue.V_0_0_1).end().airFee(177.0, "RUB", this.vendorFeeProperties).airCommission(277.0, "RUB", this.commissionProperties).create();
        new TestContractBuilderBuilder().contractType(ContractType.SUBAGENCY).name("Subagency contract").supplier(TestBookingFileBuilder.agency).customer().customer(TestBookingFileBuilder.subagency).paymentCurrency("EUR", CurrencyRateType.IATA, RoundingMode.MATH, RoundingValue.V_0_0_1).end().airFee(100.0, "RUB", this.agencyFeeProperties).airCommission(80.0, "RUB", this.commissionProperties).create();
        new TestContractBuilderBuilder().contractType(ContractType.CLIENT).name("Client contract").supplier(TestBookingFileBuilder.subagency).customer().customer(TestBookingFileBuilder.client).paymentCurrency("USD", CurrencyRateType.IATA, RoundingMode.MATH, RoundingValue.V_0_0_1).end().airFee(75.0, "RUB", this.subagencyFeeProperties).create();
    }

    private void createProperties() throws Exception {
        this.vendorFeeProperties = new TestFeePropertiesBuilder().displayName("Vendor Fee").calculationType(CalculationType.TICKET).calculationType(Operation.SELL).category(this.feeCategory).roundingMode(RoundingMode.MATH).roundingValue(RoundingValue.V_0_0_1).create().toReference();
        this.agencyFeeProperties = new TestFeePropertiesBuilder().displayName("Agency Fee").calculationType(CalculationType.TICKET).calculationType(Operation.SELL).chargeToClient(true).category(this.feeCategory).roundingMode(RoundingMode.MATH).roundingValue(RoundingValue.V_0_0_1).create().toReference();
        this.subagencyFeeProperties = new TestFeePropertiesBuilder().displayName("Subagency Fee").calculationType(CalculationType.TICKET).calculationType(Operation.SELL).category(this.feeCategory).roundingMode(RoundingMode.MATH).roundingValue(RoundingValue.V_0_0_1).create().toReference();
        this.commissionProperties = new TestCommissionPropertiesBuilder().displayName("Subagency Commission").calculationType(CalculationType.TICKET).category(this.commissionCategory).roundingMode(RoundingMode.MATH).roundingValue(RoundingValue.V_0_0_1).create().toReference();
    }

    private void createCategories() throws Exception {
        this.feeCategory = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("feeCategory")).translation("Agency Fee")).create();
        this.commissionCategory = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("commissionCategory")).translation("Agency Commission")).create();
    }

    private void createCurrencyRates() throws Exception {
        DictHelper.invalidateCurrencySuperCache();
        new TestCurrencyRateBuilder("USD", "RUB", 0.015384615384615385, CurrencyRateType.IATA, "2016-07-06").create();
        new TestCurrencyRateBuilder("EUR", "RUB", 0.014084507042253521, CurrencyRateType.IATA, "2016-07-06").create();
        new TestCurrencyRateBuilder("USD", "EUR", 1.0923076923076922, CurrencyRateType.IATA, "2016-07-06").create();
    }
}

