/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rules;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.gds.test.TestFlightBuilder;
import com.gridnine.xtrip.server.ibecorp.test.IbeCorpTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionCategoryBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionPropertiesBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import org.junit.Assert;
import org.junit.Test;

public class IbecorpFlightCommissionCalculationTest
extends IbeCorpTestBase {
    private final EntityReference<Organization> bspRef = new EntityReference("BSP_container", Organization.class, "BSP");
    private final EntityReference<Organization> suRef = new EntityReference("SU_container", Organization.class, "SU");

    @Test
    public void testCommissionCalculation() throws Exception {
        this.createProfiles();
        this.testDirectFlag(true);
        this.testDirectFlag(false);
    }

    private void testDirectFlag(boolean hasDirectContracts) {
        Flight flight = new TestFlightBuilder().blankOwner(hasDirectContracts ? this.bspRef : this.suRef).fare(100.0, DictHelper.getAdultPassengerType()).getEntity();
        this.applyRules(flight);
        Assert.assertEquals((Object)hasDirectContracts, (Object)flight.isHasDirectVendorContracts());
    }

    private void createProfiles() throws Exception {
        DictionaryReference commissionCategory = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("commission")).translation("commission")).create();
        EntityReference vendorCommProperties = new TestCommissionPropertiesBuilder().category(commissionCategory).displayName("Vendor Commission").operation(Operation.SELL).create().toReference();
        EntityReference subagentCommProperties = new TestCommissionPropertiesBuilder().category(commissionCategory).displayName("Subagent Commission").operation(Operation.SELL).create().toReference();
        new TestContractBuilderBuilder().contractType(ContractType.VENDOR).name("SU contract").blankOwner(this.suRef).supplier(this.suRef).customer(TestBookingFileBuilder.agency).airCommission(10.0, "RUB", vendorCommProperties).create();
        new TestContractBuilderBuilder().contractType(ContractType.VENDOR).name("BSP contract").blankOwner(this.bspRef).supplier(this.bspRef).customer(TestBookingFileBuilder.subagency).airCommission(20.0, "RUB", vendorCommProperties).create();
        new TestContractBuilderBuilder().contractType(ContractType.SUBAGENCY).supplier(TestBookingFileBuilder.agency).customer(TestBookingFileBuilder.subagency).airCommission(30.0, "RUB", subagentCommProperties).create();
    }
}

