/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rules;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.gds.test.TestFlightBuilder;
import com.gridnine.xtrip.server.ibecorp.test.IbeCorpTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionCategoryBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionPropertiesBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestOrganizationBuilder;
import org.junit.Assert;
import org.junit.Test;

public class IbecorpIndirectBspContractsTest
extends IbeCorpTestBase {
    @Test
    public void testSeparateIndirectBspContracts() throws Exception {
        DictionaryReference commissionCategory = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("cat 1")).translation("BSP Commission")).create();
        DictionaryReference supplierCategory = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("cat 2")).translation("Supplier Commission")).create();
        EntityReference bspCommProperties = new TestCommissionPropertiesBuilder().category(commissionCategory).displayName("BSP Commission").bsp(true).operation(Operation.SELL).create().toReference();
        EntityReference supplierCommProperties = new TestCommissionPropertiesBuilder().category(supplierCategory).displayName("Supplier Commission").operation(Operation.SELL).create().toReference();
        EntityReference blankOwnerRef = new EntityReference("BSP_container", Organization.class, "BSP");
        EntityReference supplierRef = new TestOrganizationBuilder().code("SUPP").shortName("Supplier").types(new OrganizationType[]{OrganizationType.AGENCY}).create().toReference();
        this.createValidator("90876543", (EntityReference<Organization>)blankOwnerRef, (EntityReference<Organization>)supplierRef);
        new TestContractBuilderBuilder().contractType(ContractType.VENDOR).name("BSP contract").blankOwner(blankOwnerRef).supplier(blankOwnerRef).customer(supplierRef).airCommission(10.0, "RUB", bspCommProperties).create();
        new TestContractBuilderBuilder().contractType(ContractType.VENDOR).name("Supplier contract").blankOwner(blankOwnerRef).supplier(supplierRef).customer().useSeparateBSPContract(true).customer(TestBookingFileBuilder.agency).end().ruleSettings().target((RuleTarget)Targets.PRODUCT_COMMISSION).restriction((RuleProperty)Properties.BSP_COMMISSION_EQUIVALENT_VALUE, (RuleCondition)Conditions.GREATER_THAN_OR_EQUALS, (Object)10.0).commission(20.0, "RUB", supplierCommProperties).end().create();
        Flight flight = new TestFlightBuilder().blankOwner(blankOwnerRef).supplier(supplierRef).fare(100.0, DictHelper.getAdultPassengerType()).getEntity();
        this.applyRules(flight);
        GdsContractRelationData relation = FlightHelper.getContractRelation((Flight)flight, (ContractType)ContractType.VENDOR, (DictionaryReference)DictHelper.getAdultPassengerType());
        Assert.assertEquals((long)2L, (long)relation.getCommissions().size());
    }

    private void createValidator(String number, EntityReference<Organization> blankOwnerRef, EntityReference<Organization> supplierRef) {
        EntityContainer spCtr = EntityStorage.get().resolve(TestBookingFileBuilder.agencySalesPoint);
        ((SalesPoint)spCtr.getEntity()).getValidators().clear();
        Validator val = new Validator();
        val.setNumber(number);
        val.setAgency(TestBookingFileBuilder.agency);
        val.setBlankOwner(blankOwnerRef);
        val.setSupplier(supplierRef);
        ((SalesPoint)spCtr.getEntity()).getValidators().add(val);
        EntityStorage.get().save(spCtr, true);
    }

    @Test
    public void testCombinedIndirectBspContract() throws Exception {
        DictionaryReference commissionCategory = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("cat 1")).translation("BSP Commission")).create();
        DictionaryReference supplierCategory = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("cat 2")).translation("Supplier Commission")).create();
        EntityReference bspCommProperties = new TestCommissionPropertiesBuilder().category(commissionCategory).displayName("BSP Commission").bsp(true).operation(Operation.SELL).create().toReference();
        EntityReference supplierCommProperties = new TestCommissionPropertiesBuilder().category(supplierCategory).displayName("Supplier Commission").operation(Operation.SELL).create().toReference();
        EntityReference blankOwnerRef = new EntityReference("BSP_container", Organization.class, "BSP");
        EntityReference supplierRef = new TestOrganizationBuilder().code("SUPP").shortName("Supplier").types(new OrganizationType[]{OrganizationType.AGENCY}).create().toReference();
        new TestContractBuilderBuilder().contractType(ContractType.VENDOR).name("Supplier contract").blankOwner(blankOwnerRef).supplier(supplierRef).customer(TestBookingFileBuilder.agency).airCommission(10.0, "RUB", bspCommProperties).airCommission(20.0, "RUB", supplierCommProperties).create();
        this.createValidator("25637823", (EntityReference<Organization>)blankOwnerRef, (EntityReference<Organization>)supplierRef);
        Flight flight = new TestFlightBuilder().blankOwner(blankOwnerRef).supplier(supplierRef).fare(100.0, DictHelper.getAdultPassengerType()).getEntity();
        this.applyRules(flight);
        GdsContractRelationData relation = FlightHelper.getContractRelation((Flight)flight, (ContractType)ContractType.VENDOR, (DictionaryReference)DictHelper.getAdultPassengerType());
        Assert.assertEquals((long)2L, (long)relation.getCommissions().size());
    }

    @Test
    public void testDirectBspContract() throws Exception {
        DictionaryReference commissionCategory = ((TestCommissionCategoryBuilder)((TestCommissionCategoryBuilder)new TestCommissionCategoryBuilder().code("cat 1")).translation("BSP Commission")).create();
        EntityReference bspCommProperties = new TestCommissionPropertiesBuilder().category(commissionCategory).displayName("BSP Commission").bsp(true).operation(Operation.SELL).create().toReference();
        EntityReference blankOwnerRef = new EntityReference("BSP_container", Organization.class, "BSP");
        new TestContractBuilderBuilder().contractType(ContractType.VENDOR).name("BSP contract").blankOwner(blankOwnerRef).supplier(blankOwnerRef).customer(TestBookingFileBuilder.agency).airCommission(10.0, "RUB", bspCommProperties).create();
        Flight flight = new TestFlightBuilder().blankOwner(blankOwnerRef).supplier(blankOwnerRef).fare(100.0, DictHelper.getAdultPassengerType()).getEntity();
        this.applyRules(flight);
        GdsContractRelationData relation = FlightHelper.getContractRelation((Flight)flight, (ContractType)ContractType.VENDOR, (DictionaryReference)DictHelper.getAdultPassengerType());
        Assert.assertEquals((long)1L, (long)relation.getCommissions().size());
    }
}

