/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.rules;

import com.gridnine.xtrip.common.model.rules.standard.ContractsFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.railway.model.rules.standart.StandartRuleEnvironment;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class RulesDescriptionsTest
extends ModelTestBase {
    protected void configureRulesEnvironment(RulesEnvironment re) {
        super.configureRulesEnvironment(re);
        new StandartRuleEnvironment().environmentInitialized(re);
    }

    @Test
    public void testRulesDescriptions() throws Exception {
        File file;
        RuleTarget[] targets = new RuleTarget[]{Targets.PRODUCT_COMMISSION};
        RuleFilteringCategory[] filteringCategories = new RuleFilteringCategory[]{ContractsFilteringCategories.MODEL_CONTRACT};
        HashSet conditions = new HashSet();
        HashSet<RuleAction> actions = new HashSet<RuleAction>();
        HashSet<RuleProperty> properties = new HashSet<RuleProperty>();
        HashSet filteredProperties = new HashSet();
        HashSet filteredActions = new HashSet();
        HashSet<String> valueTypes = new HashSet<String>();
        for (RuleFilteringCategory ruleFilteringCategory : filteringCategories) {
            filteredProperties.addAll(RulesEnvironment.get().getProperties(ruleFilteringCategory));
            filteredActions.addAll(RulesEnvironment.get().getActions(ruleFilteringCategory));
        }
        for (RuleFilteringCategory ruleFilteringCategory : targets) {
            for (RuleProperty prop : RulesEnvironment.get().getProperties((RuleTarget)ruleFilteringCategory)) {
                if (!filteredProperties.contains(prop)) continue;
                properties.add(prop);
                conditions.addAll(RulesEnvironment.get().getConditions(prop));
                valueTypes.add(prop.getRendererId());
            }
            for (RuleAction action : RulesEnvironment.get().getActions((RuleTarget)ruleFilteringCategory)) {
                if (!filteredActions.contains(action)) continue;
                actions.add(action);
            }
        }
        StringBuilder sb = new StringBuilder();
        File baseDirectory = new File(this.findRoot(IoUtil.url2file((URL)((Object)((Object)this)).getClass().getResource(".")), new HashSet<File>()), "plugins/com.gridnine.xtrip.server.model/webapps/rules-docs/elements");
        if (!baseDirectory.exists()) {
            throw new Exception("unable to locate webapp directory, current directory is " + new File(".").getAbsolutePath());
        }
        for (RuleCondition ruleCondition : conditions) {
            file = new File(baseDirectory, "/conditions/" + ruleCondition.getId() + ".html");
            if (file.exists()) continue;
            sb.append("\nNo description found for condition ").append(ruleCondition.getId());
        }
        for (RuleAction ruleAction : actions) {
            file = new File(baseDirectory, "/actions/" + ruleAction.getId() + ".html");
            if (file.exists()) continue;
            sb.append("\nNo description found for action ").append(ruleAction.getId());
        }
        for (RuleProperty ruleProperty : properties) {
            file = new File(baseDirectory, "/properties/" + ruleProperty.getId() + ".html");
            if (file.exists()) continue;
            sb.append("\nNo description found for property ").append(ruleProperty.getId());
        }
        if (sb.length() > 0) {
            Assert.fail((String)sb.toString());
        }
    }

    private File findRoot(File file, HashSet<File> files) {
        if (new File(file, "build").exists() && new File(file, "plugins").exists()) {
            return file;
        }
        if (files.contains(file) || file.getParentFile() == null) {
            return null;
        }
        files.add(file);
        return this.findRoot(file.getParentFile(), files);
    }
}

