/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.sbis;

import com.gridnine.xtrip.common.ibecorp.model.IBusSbisContextKeys;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ShipmentCategory;
import com.gridnine.xtrip.common.model.dict.ShipmentCategoryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisInvoiceFile;
import com.gridnine.xtrip.server.ibecorp.sbis.ExportToSbisTestBase;
import com.gridnine.xtrip.server.model.test.TestBillingItemsListBuilder;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ExportToSbisSimpleTaxedTest
extends ExportToSbisTestBase {
    @Test
    public void testBasicExport() throws Exception {
        this.date = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").parse("2020-01-01-12-01-01");
        NestedEntityReference<Contract, ContractCustomerInfo> contract = this.createContract();
        NestedEntityReference<BookingFile, BaseProduct> productReference = this.createProduct(Product.class);
        Product product = (Product)EntityStorageHelper.resolve(productReference);
        FopComponent fopComponent = (FopComponent)((FopDetalization)product.getFopDetalizations().values().iterator().next()).getComponents().get(0);
        TestBillingItemsListBuilder billingItemsListBuilder = new TestBillingItemsListBuilder();
        EntityContainer billingItemsListContainer = ((TestBillingItemsListBuilder)billingItemsListBuilder.billingItem().name("Billing item HOtel&Spa 01").count(1).serviceType(ServiceType.TICKET).amount(VatAmount.of((BigDecimal)BigDecimal.valueOf(6700L), (double)20.0)).product(productReference).fopComponent(new NestedEntityReference(productReference, (BaseEntity)fopComponent)).end()).create();
        NestedEntityReference billingItem01 = new NestedEntityReference(billingItemsListContainer, (BaseEntity)((BillingItemsList)billingItemsListContainer.getEntity()).getData().get(0));
        ShipmentCategoryReference category = new ShipmentCategoryReference("air");
        EntityContainer<Shipment> shipmentCtr = this.createShipment((DictionaryReference<ShipmentCategory>)category, contract, billingItem01);
        this.createFinanceDocument(shipmentCtr, FinanceDocumentType.INVOICE);
        this.createFinanceDocument(shipmentCtr, FinanceDocumentType.INVOICE_FACTURA);
        this.createFinanceDocument(shipmentCtr, FinanceDocumentType.ACCEPTANCE_CERTIFICATE);
        EntityContainer supplierCtr = EntityStorage.get().resolve(((Shipment)shipmentCtr.getEntity()).getSupplier());
        ((Organization)supplierCtr.getEntity()).setSimpleTaxed(true);
        EntityStorage.get().save(supplierCtr, true);
        Map<String, Object> data = this.export((EntityReference<Shipment>)shipmentCtr.toReference());
        HashMap documents = (HashMap)data.get(IBusSbisContextKeys.SBIS_FINANCE_DOCUMENTS.name());
        SbisInvoiceFile invoiceFile = documents.keySet().stream().filter(item -> item instanceof SbisInvoiceFile).findFirst().orElse(null);
        Assert.assertEquals((double)6700.0, (double)invoiceFile.getBezNDS().doubleValue(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)invoiceFile.getItogoNDS().doubleValue(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)invoiceFile.getNds10().doubleValue(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)invoiceFile.getNds20().doubleValue(), (double)0.001);
        Assert.assertNull((Object)invoiceFile.getRows().get(0).getNds());
    }
}

