/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.sbis;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.ibecorp.model.IBusSbisContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.CalculationType;
import com.gridnine.xtrip.common.model.booking.commission.Operation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.LegalFormReference;
import com.gridnine.xtrip.common.model.dict.Nomenclature;
import com.gridnine.xtrip.common.model.dict.ShipmentCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisIntegrationSettings;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.NomenclatureActions;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.StandardNomenclatureTargets;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.ibecorp.test.IbeCorpTestBase;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.ibus.finance.shipments.ShipmentsIbusHelper;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import com.gridnine.xtrip.server.model.test.TestCommissionPropertiesBuilder;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestFinanceDocumentBuilder;
import com.gridnine.xtrip.server.model.test.TestModelContractBuilder;
import com.gridnine.xtrip.server.model.test.TestNomenclatureBuilder;
import com.gridnine.xtrip.server.model.test.TestNomenclatureSettingsBuilder;
import com.gridnine.xtrip.server.model.test.TestReservationBuilder;
import com.gridnine.xtrip.server.model.test.TestRuleSetBuilder;
import com.gridnine.xtrip.server.model.test.TestShipmentBuilder;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

abstract class ExportToSbisTestBase
extends IbeCorpTestBase {
    protected Date date;
    protected DictionaryReference<Nomenclature> nomenclature;

    ExportToSbisTestBase() {
    }

    public void setUp() throws Exception {
        super.setUp();
        this.date = new SimpleDateFormat("yyyy-MM-dd").parse("2020-01-01");
        this.createIntegrationSettings();
        this.correctProfiles();
        this.nomenclature = this.createNomenclature();
        this.createNomeclatureSettings();
    }

    protected void createNomeclatureSettings() throws Exception {
        ((TestNomenclatureSettingsBuilder)((TestRuleSetBuilder)new TestNomenclatureSettingsBuilder().agency(TestBookingFileBuilder.agency).ruleSettings((RuleTarget)StandardNomenclatureTargets.NOMENCLATURE_AIR).result((RuleAction)NomenclatureActions.PRODUCT_NOMENCLATURE, this.nomenclature).end()).end()).create();
    }

    protected DictionaryReference<Nomenclature> createNomenclature() throws Exception {
        return ((TestNomenclatureBuilder)((TestNomenclatureBuilder)new TestNomenclatureBuilder().code("00001")).translation(LocaleHelper.RU_LOCALE, "\u041f\u0440\u043e\u0434\u0443\u043a\u0442")).create();
    }

    protected void correctProfiles() throws Exception {
        LegalForm lf = new LegalForm();
        lf.setCode("\u041e\u041e\u041e");
        lf.getAbbreviations().put(new Locale("ru", "RU"), "\u041e\u041e\u041e");
        lf.getTranslations().put(new Locale("ru", "RU"), "\u041e\u0431\u0449\u0435\u0441\u0442\u0432\u043e \u0441 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043d\u043e\u0439 \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c\u044e");
        DictionaryStorage.get().save((BaseDictionary)lf);
        LegalFormReference ooo = lf.toReference();
        EntityContainer clientCtr = EntityStorage.get().resolve(TestBookingFileBuilder.client);
        ((Organization)clientCtr.getEntity()).setRegistrationId("1111111");
        ((Organization)clientCtr.getEntity()).setKpp("2222222");
        ((Organization)clientCtr.getEntity()).setLegalForm((DictionaryReference)ooo);
        ((Organization)clientCtr.getEntity()).getFullName().setStringValue("Client full");
        Address address = new Address();
        address.setZip("103473");
        address.setAddressType(AddressType.LEGAL);
        address.setCity((DictionaryReference)new GeoLocationReference("MOW"));
        address.setCountry((DictionaryReference)new CountryReference("RU"));
        address.getAddress().setStringValue("Client street");
        address.getBuilding().setStringValue("c1");
        ((Organization)clientCtr.getEntity()).getAddresses().add(address);
        EntityStorage.get().save(clientCtr, true);
        EntityContainer agencyCtr = EntityStorage.get().resolve(TestBookingFileBuilder.agency);
        ((Organization)agencyCtr.getEntity()).setRegistrationId("33333");
        ((Organization)agencyCtr.getEntity()).setKpp("44444");
        ((Organization)agencyCtr.getEntity()).getFullName().setStringValue("Agency full");
        LegalForm lf2 = new LegalForm();
        lf2.setCode("\u0410\u041e");
        lf2.getAbbreviations().put(new Locale("ru", "RU"), "\u0410\u041e");
        lf2.getTranslations().put(new Locale("ru", "RU"), "\u0410\u043a\u0446\u0438\u043e\u043d\u0435\u0440\u043d\u043e\u0435 \u041e\u0431\u0449\u0435\u0441\u0442\u0432\u043e");
        DictionaryStorage.get().save((BaseDictionary)lf2);
        LegalFormReference ao = lf2.toReference();
        ((Organization)agencyCtr.getEntity()).setLegalForm((DictionaryReference)ao);
        Address address2 = new Address();
        address2.setZip("109473");
        address2.setAddressType(AddressType.LEGAL);
        address2.setCity((DictionaryReference)new GeoLocationReference("MOW"));
        address2.setCountry((DictionaryReference)new CountryReference("RU"));
        address2.getAddress().setStringValue("Agency street");
        address2.getBuilding().setStringValue("b1");
        ((Organization)agencyCtr.getEntity()).getAddresses().add(address2);
        Communication comm = new Communication();
        comm.setType(CommunicationType.WORK_PHONE);
        comm.setSense("01");
        ((Organization)agencyCtr.getEntity()).getCommunications().add(comm);
        EntityStorage.get().save(agencyCtr, true);
    }

    protected void createIntegrationSettings() {
        String settingsUid = UniqueSettingsRegistry.get().getUidByClassName(SbisIntegrationSettings.class.getName());
        EntityContainer ctr = new EntityContainer(SbisIntegrationSettings.class, settingsUid);
        ((SbisIntegrationSettings)ctr.getEntity()).getGeneralSettings().setEnabled(true);
        ((SbisIntegrationSettings)ctr.getEntity()).getGeneralSettings().setExportDirectory(Environment.getTempFolder().getAbsolutePath());
        ((SbisIntegrationSettings)ctr.getEntity()).getGeneralSettings().setBaseDirInDocument(Environment.getTempFolder().getAbsolutePath());
        ((SbisIntegrationSettings)ctr.getEntity()).getAccentanceCertificateSettings().setSignature("\u041c\u044b, \u043d\u0438\u0436\u0435\u043f\u043e\u0434\u043f\u0438\u0441\u0430\u0432\u0448\u0438\u0435\u0441\u044f, \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u0438\u0442\u0435\u043b\u044c \u0410\u0413\u0415\u041d\u0422\u0410, \u0441 \u043e\u0434\u043d\u043e\u0439 \u0441\u0442\u043e\u0440\u043e\u043d\u044b \u0438 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u0438\u0442\u0435\u043b\u044c \u041f\u0420\u0418\u041d\u0426\u0418\u041f\u0410\u041b\u0410 \u0441 \u0434\u0440\u0443\u0433\u043e\u0439 \u0441\u0442\u043e\u0440\u043e\u043d\u044b,\n \u0441\u0442\u043e\u0440\u043e\u043d\u044b, \u0441\u043e\u0441\u0442\u0430\u0432\u0438\u043b\u0438 \u043d\u0430\u0441\u0442\u043e\u044f\u0449\u0438\u0439 \u0430\u043a\u0442 \u0432 \u0442\u043e\u043c, \u0447\u0442\u043e \u0410\u0413\u0415\u041d\u0422 \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u043b, \u0430 \u041f\u0420\u0418\u041d\u0426\u0418\u041f\u0410\u041b \u043f\u0440\u0438\u043d\u044f\u043b \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u0440\u0430\u0431\u043e\u0442\u044b (\u0443\u0441\u043b\u0443\u0433\u0438)");
        EntityStorage.get().save(ctr, true);
    }

    protected List<URL> collectIntegrationBusDescriptions() {
        List result = super.collectIntegrationBusDescriptions();
        result.add(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/server/ibecorp/ibus/sbis/ibus-sbis.xml"));
        return result;
    }

    protected <P extends BaseProduct> NestedEntityReference<BookingFile, BaseProduct> createProduct(Class<P> productClass) throws Exception {
        TestBookingFileBuilder builder = new TestBookingFileBuilder();
        ((BookingFile)builder.getEntity()).setCreateDate(new Date());
        TestReservationBuilder reservationBuilder = builder.reservation();
        if (!Product.class.equals(productClass)) {
            throw new IllegalArgumentException("unsupported product class " + productClass);
        }
        Traveller trav = builder.traveller().name("Ivanov").getEntity();
        reservationBuilder.airProduct(true).traveller(trav).updateFops();
        EntityContainer bookingFileContainer = builder.create();
        return new NestedEntityReference(bookingFileContainer, (BaseEntity)((Reservation)((BookingFile)bookingFileContainer.getEntity()).getReservations().get(0)).getProducts().get(0));
    }

    protected NestedEntityReference<Contract, ContractCustomerInfo> createContract() throws Exception {
        EntityReference commProp = new TestCommissionPropertiesBuilder().displayName("Commission").category((DictionaryReference)new CommissionCategoryReference("cat")).calculationType(CalculationType.TICKET).productTypes(new ProductType[]{ProductType.AIR_TICKET}).operation(Operation.SELL).create().toReference();
        TestModelContractBuilder modelContractBuilder = new TestModelContractBuilder();
        EntityReference modelContract = ((TestModelContractBuilder)((TestRuleSetBuilder)modelContractBuilder.ruleSet().rule().target((RuleTarget)Targets.PRODUCT_COMMISSION).commission(1.0, "RUB", commProp, (RuleAction)Actions.SIMPLE_COMMISSION).end()).end()).create().toReference();
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        EntityContainer contractContainer = contractBuilder.newModel(Boolean.valueOf(true)).issueDate(this.date).number("0001").contractType(ContractType.CLIENT).supplier(TestBookingFileBuilder.agency).customerNewContract(TestBookingFileBuilder.client).modelContract(modelContract).create();
        return ShipmentsIbusHelper.createContractReference((EntityReference)contractContainer.toReference());
    }

    protected EntityReference<FinanceDocument> createFinanceDocument(EntityContainer<Shipment> shipmentCtr, FinanceDocumentType invoice) throws Exception {
        TestFinanceDocumentBuilder financeDocumentBuilder = new TestFinanceDocumentBuilder();
        EntityContainer supplierCtr = EntityStorage.get().resolve(((Shipment)shipmentCtr.getEntity()).getSupplier());
        financeDocumentBuilder.name(invoice + " 000000001").number("000000001").type(invoice).date(this.date).contract(((Shipment)shipmentCtr.getEntity()).getContract()).currency(((Shipment)shipmentCtr.getEntity()).getCurrency()).supplier(TestBookingFileBuilder.agency).customer(TestBookingFileBuilder.client).payer(TestBookingFileBuilder.client).agent(TestBookingFileBuilder.agencyAgent).shipment(shipmentCtr.toReference());
        for (NestedEntityReference bi : ((Shipment)shipmentCtr.getEntity()).getBillingItems()) {
            financeDocumentBuilder.billingItem(bi);
        }
        EntityReference result = financeDocumentBuilder.create().toReference();
        ((Shipment)shipmentCtr.getEntity()).getFinanceDocuments().add(result);
        EntityStorage.get().save(shipmentCtr, true);
        return result;
    }

    protected EntityContainer<Shipment> createShipment(DictionaryReference<ShipmentCategory> category, NestedEntityReference<Contract, ContractCustomerInfo> contract, NestedEntityReference<BillingItemsList, BillingItem> ... billingItems) throws Exception {
        TestShipmentBuilder shipmentBuilder = new TestShipmentBuilder();
        CurrencyInfoReference currency = new CurrencyInfoReference(DictHelper.getEquivCurrency());
        shipmentBuilder.category(category).contract(contract).currency((DictionaryReference)currency).periodBegin(new Date(this.date.getTime() - TimeUnit.DAYS.toMillis(1L))).periodEnd(this.date).supplier(TestBookingFileBuilder.agency).customer(TestBookingFileBuilder.client).payer(TestBookingFileBuilder.client).agent(TestBookingFileBuilder.agencyAgent).date(this.date).numberPrefix("\u0411\u0422").number("001");
        for (NestedEntityReference<BillingItemsList, BillingItem> item : billingItems) {
            shipmentBuilder.billingItem(item);
        }
        return shipmentBuilder.create();
    }

    protected Map<String, Object> export(EntityReference<Shipment> shipment) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusSbisContextKeys.SHIPMENT_REFERENCE.name(), shipment);
        IntegrationBusFacade.get().processRouteSync("ibecorp:sbis:export-shipment", data);
        return data;
    }

    protected void createRegistry(EntityContainer<Shipment> shipmentCtr) {
        Document doc = new Document();
        doc.setName("\u0420\u0435\u0435\u0441\u0442\u0440.xlsx");
        doc.setType(DocumentType.SHIPMENT_TICKETS_REGISTRY);
        doc.setOwner(shipmentCtr.toReference());
        doc.setContent(new byte[0]);
        doc.setContentType(ContentType.EXCEL_2007);
        doc.setTitle("\u0420\u0435\u0435\u0441\u0442\u0440 \u0434\u043b\u044f \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 " + ((Shipment)shipmentCtr.getEntity()).getNumber());
        doc.setCreated(new Date());
        doc.setCheckSum("dg");
        EntityStorage.get().save(EntityContainer.create((BaseEntity)doc), true);
    }
}

