/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.security.acl;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclAspectVariant;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclAspectVariantEntry;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclRole;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.security.acl.helper.AclEntryProvider;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbeAclEntryProvider
extends AclEntryProvider {
    private static final Logger log = LoggerFactory.getLogger(IbeAclEntryProvider.class);

    public List<AclEntry> getUserEntries(String resourceId, String userId) {
        Person person;
        if (log.isDebugEnabled()) {
            log.debug(String.format("collecting entry for resource %s and user %s", resourceId, userId));
        }
        if ((person = (Person)Optional.ofNullable(EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS)).map(item -> (Person)item.getEntity()).orElse(null)) != null && person.getAclSettings() != null && person.getAclSettings().getAclRole() != null) {
            List variantEntries;
            EntityStorageContext context = EntityStorageHelper.createContext();
            EntityContainer role = EntityStorage.get().resolve(person.getAclSettings().getAclRole());
            if (role != null && (variantEntries = ((IbeCorpAclRole)role.getEntity()).getAspectVariants().stream().map(item -> (IbeCorpAclAspectVariant)EntityStorageHelper.resolve((NestedEntityReference)item, (EntityStorageContext)context)).filter(item -> item != null).flatMap(item -> item.getAspectVariants().stream()).filter(item -> TextUtil.isSame((String)item.getResourceId(), (String)resourceId)).collect(Collectors.toList())).size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("variant entries for resource %s and user %s found", resourceId, userId));
                }
                ArrayList<AclEntry> entries = new ArrayList<AclEntry>();
                for (IbeCorpAclAspectVariantEntry variantEntry : variantEntries) {
                    AclEntry entry = new AclEntry();
                    entry.setPrincipalId(userId);
                    entry.setResourceId(resourceId);
                    entry.getRules().clear();
                    entry.getRules().addAll(variantEntry.getRules());
                    entries.add(entry);
                }
                return entries;
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("variant entries for resource %s and user %s not found", resourceId, userId));
            }
            return Collections.emptyList();
        }
        AclEntry entry = AclHelper.getEntry((String)resourceId, (String)userId);
        return entry != null ? Collections.singletonList(entry) : Collections.emptyList();
    }

    public List<AclEntry> getGroupEntries(String resourceId, String userId, String groupId) {
        Person person;
        if (log.isDebugEnabled()) {
            log.debug(String.format("collecting entry for resource %s and group %s of user %s", resourceId, groupId, userId));
        }
        if ((person = (Person)Optional.ofNullable(EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS)).map(item -> (Person)item.getEntity()).orElse(null)) != null && person.getAclSettings() != null && person.getAclSettings().getAclRole() != null && EntityStorage.get().resolve(person.getAclSettings().getAclRole()) != null) {
            log.debug(String.format("veriant entries for resource %s and group %s of user %s not found", resourceId, groupId, userId));
            return Collections.emptyList();
        }
        AclEntry entry = AclHelper.getEntry((String)resourceId, (String)groupId);
        return entry != null ? Collections.singletonList(entry) : Collections.emptyList();
    }
}

