/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.security.acl;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class IbePermissionManager {
    public static <E extends BaseEntity, I extends EntityIndex<E>> List<I> secureSearch(Class<I> requestedEntity, SearchQuery query) throws Exception {
        String login = UserData.get().getCurrentUser();
        boolean granted = AclHelper.isGranted(null, (String)requestedEntity.getName(), (String)login, (String)StandardRestrictionResourceOperations.VIEW.getId(), Collections.emptyList());
        if (!granted) {
            return Collections.emptyList();
        }
        SearchQuery modQuery = AclHelper.modifyQuery((SearchQuery)query, (String)requestedEntity.getName(), (String)login, Collections.emptyList());
        SearchResult searchResult = EntityStorage.get().search(requestedEntity, modQuery);
        return searchResult.getData();
    }

    public static <E extends BaseEntity> EntityContainer<E> secureResolve(EntityReference<E> entityRef, StandardRestrictionResourceOperations ... requiredOps) throws Exception {
        EntityContainer entityCtr = EntityStorage.get().resolve(entityRef);
        if (entityCtr == null) {
            return null;
        }
        return IbePermissionManager.isEntityGranted(entityCtr, requiredOps) ? entityCtr : null;
    }

    public static <E extends BaseEntity> boolean isEntityGranted(EntityContainer<E> ctr, StandardRestrictionResourceOperations ... requiredOps) throws Exception {
        String login = UserData.get().getCurrentUser();
        for (StandardRestrictionResourceOperations op : requiredOps) {
            boolean granted = AclHelper.isGranted(ctr, (String)ctr.getEntity().getUid(), (String)ctr.getEntityType().getName(), (String)login, (String)op.getId(), Collections.emptyList());
            if (granted) continue;
            return false;
        }
        return true;
    }

    public static <E extends BaseEntity> boolean isEntityGranted(EntityContainer<E> ctr, Map<String, RestrictionResourceProxy> aclProxyMap, StandardRestrictionResourceOperations ... requiredOps) throws Exception {
        String login = UserData.get().getCurrentUser();
        for (StandardRestrictionResourceOperations op : requiredOps) {
            boolean granted = AclHelper.isGranted((RestrictionResourceProxy)aclProxyMap.get(ctr.getEntity().getUid()), (String)ctr.getEntityType().getName(), (String)login, (String)op.getId(), Collections.emptyList());
            if (granted) continue;
            return false;
        }
        return true;
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>> boolean isIndexGranted(Class<I> indexClass) throws Exception {
        String login = UserData.get().getCurrentUser();
        return AclHelper.isGranted(null, (String)indexClass.getName(), (String)login, (String)StandardRestrictionResourceOperations.VIEW.getId(), Collections.emptyList());
    }
}

