/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.servlets.externalForm;

import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.rest.TypeHandler;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonTypeHandler;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchLeg;
import com.gridnine.xtrip.server.web.rest.JsonMarshaller;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalFormHandler
extends HttpServlet {
    protected static Logger log = LoggerFactory.getLogger(ExternalFormHandler.class);
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"dd.MM.yyyy");

    public static SearchFlightsParameters parse(HttpServletRequest req) throws Exception {
        if (req.getParameter("searchJSON") != null) {
            try {
                String searchParamsJSONString = req.getParameter("searchJSON");
                JSONObject json = new JSONObject(searchParamsJSONString);
                if (json.has("parameters")) {
                    json = json.getJSONObject("parameters");
                    searchParamsJSONString = json.toString();
                }
                JsonMarshaller marshaller = new JsonMarshaller();
                marshaller.addTypeHandler((TypeHandler)new CommonTypeHandler());
                SearchFlightsParameters params = (SearchFlightsParameters)marshaller.unmarshal(searchParamsJSONString, SearchFlightsParameters.class);
                return params;
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        SearchFlightsParameters result = new SearchFlightsParameters();
        List childsAge = result.getChildsAge();
        List flightLegs = result.getFlightLegs();
        Map passengers = result.getPassengers();
        HashMap<String, DictionaryReference> passangerTypes = new HashMap<String, DictionaryReference>();
        passangerTypes.put("adults", DictHelper.getAdultPassengerType());
        passangerTypes.put("children", DictHelper.getChildPassengerType());
        passangerTypes.put("infants", DictHelper.getInfantPassengerType());
        result.setClassOfService(ClassOfService.valueOf((String)req.getParameter("FlightSearchForm.serviceClass")));
        result.setDirect(Boolean.valueOf(req.getParameter("FlightSearchForm.skipConnected")).booleanValue());
        passangerTypes.entrySet().stream().forEach(item -> {
            try {
                int q = Integer.parseInt(req.getParameter("FlightSearchForm." + (String)item.getKey()));
                if (q > 0) {
                    passengers.put(item.getValue(), q);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        GeoLocationReference locationFrom = ((GeoLocation)new ArrayList(DictHelper.findGeoLocationByCode((String)req.getParameter("FlightSearchForm.departureLocation.0.CODE"), null)).get(0)).toReference();
        GeoLocationReference locationTo = ((GeoLocation)new ArrayList(DictHelper.findGeoLocationByCode((String)req.getParameter("FlightSearchForm.arrivalLocation.0.CODE"), null)).get(0)).toReference();
        switch (req.getParameter("FlightSearchForm.routeType")) {
            case "ROUND_TRIP": {
                LocalDate date2 = dateTimeFormatter.parseLocalDate(req.getParameter("FlightSearchForm.date.1"));
                SearchLeg sl2 = new SearchLeg();
                sl2.setDeparture((DictionaryReference)locationTo);
                sl2.setArrival((DictionaryReference)locationFrom);
                sl2.setDate(date2);
                flightLegs.add(sl2);
            }
        }
        LocalDate date1 = dateTimeFormatter.parseLocalDate(req.getParameter("FlightSearchForm.date.0"));
        SearchLeg sl1 = new SearchLeg();
        sl1.setDeparture((DictionaryReference)locationFrom);
        sl1.setArrival((DictionaryReference)locationTo);
        sl1.setDate(date1);
        flightLegs.add(sl1);
        return result;
    }

    public static String serialize(SearchFlightsParameters searchFlight) {
        StringBuilder sb = new StringBuilder();
        sb.append(searchFlight.getFlightLegs().stream().map(leg -> {
            StringBuilder sbLeg = new StringBuilder();
            sbLeg.append("L|");
            sbLeg.append(leg.getDeparture().getCode()).append("|");
            sbLeg.append(leg.getArrival().getCode()).append("|");
            sbLeg.append(leg.getDate().toString("yyyy-MM-dd"));
            return sbLeg.toString();
        }).collect(Collectors.joining("_")));
        sb.append("_C|").append(searchFlight.getClassOfService().name());
        sb.append("_D|").append(searchFlight.isDirect() ? "T" : "F");
        sb.append(searchFlight.getPassengers().entrySet().stream().map(passenger -> {
            StringBuilder sbPassenger = new StringBuilder();
            sbPassenger.append("_P|");
            sbPassenger.append(((DictionaryReference)passenger.getKey()).getCode()).append("|");
            sbPassenger.append(passenger.getValue());
            return sbPassenger.toString();
        }).collect(Collectors.joining("")));
        return sb.toString();
    }

    public void handle(HttpServletRequest req, HttpServletResponse resp) {
        try {
            SearchFlightsParameters result = ExternalFormHandler.parse(req);
            String hash = ExternalFormHandler.serialize(result);
            String url = "/#tickets/" + hash.toString();
            resp.setStatus(302);
            resp.setHeader("Location", url);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            try {
                resp.setStatus(302);
                resp.setHeader("Location", "/");
            }
            catch (Exception e2) {
                log.error("", (Throwable)e2);
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }
}

