/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.ibecorp.tasks.ExpiringTimeLimitNotificationScheduleTask;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.time.FastDateFormat;

public class ExpiringTimeLimitNotificationScheduleTaskInterceptor
implements EntityInterceptor {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"dd.MM.yyyy");

    public double getPriority() {
        return -1.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) {
        if (!data.getEntity().getClass().equals(ScheduledTaskSettings.class)) {
            return;
        }
        EntityContainer<?> settingsCtr = data;
        if (!ExpiringTimeLimitNotificationScheduleTask.class.getName().equals(((ScheduledTaskSettings)settingsCtr.getEntity()).getJobClass())) {
            return;
        }
        Set dataMap = ((ScheduledTaskSettings)settingsCtr.getEntity()).getDataMap();
        String startDateStr = SystemHelper.findValue((Collection)dataMap, (String)"startWarningDate");
        boolean needUpdateStartDate = false;
        if (TextUtil.isBlank((String)startDateStr)) {
            needUpdateStartDate = true;
        } else {
            EntityContainer oldCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
            if (((ScheduledTaskSettings)settingsCtr.getEntity()).isEnabled() && (oldCtr == null || !((ScheduledTaskSettings)oldCtr.getEntity()).isEnabled())) {
                needUpdateStartDate = true;
            } else {
                try {
                    DateTimeFormatter.ofPattern("dd.MM.yyyy").parse(startDateStr);
                }
                catch (Exception ex) {
                    throw Xeption.forEndUser((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u0442\u044b \u0434\u043b\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 {0}. \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0444\u043e\u0440\u043c\u0430\u0442\u0443 {1}", (Object[])new Object[]{"startWarningDate", "dd.MM.yyyy"});
                }
            }
        }
        if (needUpdateStartDate) {
            SystemHelper.setValue((Collection)dataMap, (String)"startWarningDate", (String)DF.format(new Date()));
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) {
    }
}

