/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.hotels2.model.BaseHotelsProviderAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorData;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import java.util.HashMap;
import java.util.Locale;

public class HotelsAggregatorGdsAccountInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 10.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> ctr) throws Exception {
        if (!HotelsAggregatorGdsAccount.class.getName().equals(ctr.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> hotelsGdsAccountCtr = ctr;
        this.updateHotelsAggregatorGdsAccount(hotelsGdsAccountCtr);
        HashMap data = new HashMap();
        data.put(IBusHotelsContextKeys.HOTELS_GDS_ACCOUNT.name(), ctr);
        IntegrationBusFacade.get().processRouteSync("hotels2:hotels-profile:update-hotels-profile-route", data);
    }

    private void updateHotelsAggregatorGdsAccount(EntityContainer<HotelsAggregatorGdsAccount> hotelsGdsAccountCtr) {
        HotelsAggregatorGdsAccount hotelsGdsAccount = (HotelsAggregatorGdsAccount)hotelsGdsAccountCtr.getEntity();
        hotelsGdsAccount.setPcc(hotelsGdsAccountCtr.getUid());
        String name = this.buildName(hotelsGdsAccount);
        hotelsGdsAccount.getHotelsAggregatorData().setName(name);
        ((BaseHotelsProviderAccount)hotelsGdsAccount.getHotelsAggregatorData().getVendors().get(hotelsGdsAccount.getProvider())).setName(name);
    }

    private String buildName(HotelsAggregatorGdsAccount hotelsGdsAccount) {
        String shortName;
        StringBuilder sb = new StringBuilder();
        EntityContainer orgCtr = EntityStorage.get().resolve(hotelsGdsAccount.getAgency());
        if (orgCtr != null && TextUtil.nonBlank((String)(shortName = L10nStringHelper.getValue((L10nString)((Organization)orgCtr.getEntity()).getShortName(), (Locale)LocaleHelper.EN_LOCALE)))) {
            sb.append(shortName).append("_");
        }
        sb.append(hotelsGdsAccount.getProvider().name().toLowerCase());
        sb.append("/").append(hotelsGdsAccount.getName());
        return sb.toString();
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> ctr) throws Exception {
        if (!HotelsAggregatorGdsAccount.class.getName().equals(ctr.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> hotelsGdsAccountCtr = ctr;
        HotelsAggregatorData hotelsAggregatorData = ((HotelsAggregatorGdsAccount)hotelsGdsAccountCtr.getEntity()).getHotelsAggregatorData();
        if (hotelsAggregatorData == null || TextUtil.isBlank((String)hotelsAggregatorData.getGdsUid())) {
            return;
        }
        HashMap data = new HashMap();
        data.put(IBusHotelsContextKeys.HOTELS_GDS_ACCOUNT.name(), ctr);
        IntegrationBusFacade.get().processRouteSync("hotels2:hotels-profile:delete-hotels-profile-route", data);
    }
}

