/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.TravellerHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.PersonalNameImpl;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbeBookingFileContainerInterceptor
implements EntityInterceptor {
    public static final double priority = 3.0;
    private static final Logger log = LoggerFactory.getLogger(IbeBookingFileContainerInterceptor.class);

    public double getPriority() {
        return 3.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> bfCtr = data;
        BookingFile bookingFile = (BookingFile)bfCtr.getEntity();
        TravellerHelper.updateCyrillicNameTravellers((List)bookingFile.getTravellers());
        this.updatePassengersProfile(bookingFile);
        EntityContainer oldBfCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(bfCtr.toReference()).getOldCtr();
        this.updateAfsAsync(bfCtr, (EntityContainer<BookingFile>)oldBfCtr);
        this.fillCalculatedAfs(bfCtr, (EntityContainer<BookingFile>)oldBfCtr);
    }

    private void updatePassengersProfile(BookingFile bookingFile) {
        EntityContainer customerCtr = EntityStorage.get().resolve(bookingFile.getCustomerProfile());
        if (customerCtr == null || ProfileHelper.isRetailProfile((Organization)((Organization)customerCtr.getEntity()))) {
            return;
        }
        for (Traveller traveller : bookingFile.getTravellers()) {
            EntityContainer<Person> personCtr;
            if (traveller.getPassenger() != null || (personCtr = IbeBookingFileContainerInterceptor.findPerson(traveller, (EntityReference<Organization>)bookingFile.getCustomerProfile())) == null) continue;
            traveller.setPassenger(personCtr.toReference());
            Person person = (Person)personCtr.getEntity();
            if (traveller.getBirthday() == null) {
                traveller.setBirthday(person.getBirthday());
            }
            if (traveller.getTitle() != null) continue;
            traveller.setTitle(person.getTitle());
        }
    }

    private static EntityContainer<Person> findPerson(Traveller traveller, EntityReference<Organization> companyRef) {
        return EntityStorage.get().resolve(IbeBookingFileContainerInterceptor.findPersonRef(traveller, companyRef));
    }

    public static EntityReference<Person> findPersonRef(Traveller traveller, EntityReference<Organization> companyRef) {
        List persons;
        if (TextUtil.isBlank((String)traveller.getName())) {
            return null;
        }
        PersonalNameImpl pn = new PersonalNameImpl();
        TextUtil.splitFullName((String)traveller.getName(), (PersonalName)pn);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.PASSENGER));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)companyRef.getUid()));
        if (TextUtil.nonBlank((String)pn.getLastName())) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.lastNameValues.name(), (Object)pn.getLastName().toLowerCase()));
        }
        if (TextUtil.nonBlank((String)pn.getFirstName())) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.firstNameValues.name(), (Object)pn.getFirstName().toLowerCase()));
        }
        if (TextUtil.nonBlank((String)pn.getMiddleName())) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.middleNameValues.name(), (Object)pn.getMiddleName().toLowerCase()));
        }
        if ((persons = EntityStorage.get().search(PersonIndex.class, query).getData()).size() == 1) {
            return ((PersonIndex)persons.get(0)).getSource();
        }
        return null;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) {
    }

    private void updateAfsAsync(EntityContainer<BookingFile> bfCtr, EntityContainer<BookingFile> oldBfCtr) {
        if (((BookingFile)bfCtr.getEntity()).isDraftState()) {
            return;
        }
        boolean wasDraft = oldBfCtr != null && ((BookingFile)oldBfCtr.getEntity()).isDraftState();
        for (Reservation reservation : ((BookingFile)bfCtr.getEntity()).getReservations()) {
            SalesContext salesContext;
            if (reservation.getStatus() == ReservationStatus.ERROR) continue;
            HashSet<String> bookingUids = new HashSet<String>();
            HashSet<String> ticketingUids = new HashSet<String>();
            for (BaseProduct bp : reservation.getProducts()) {
                Product oldProd;
                Date firstDepartureDate;
                Product prod;
                if (!(bp instanceof Product) || (prod = (Product)bp).getProductCategory() != ProductCategory.AIR || (firstDepartureDate = AirProductHelper.getFirstDepartureDate((Product)prod)) == null || firstDepartureDate.before(new Date())) continue;
                Product product = oldProd = oldBfCtr == null ? null : (Product)BookingHelper.findProductByUid((String)prod.getUid(), (BookingFile)((BookingFile)oldBfCtr.getEntity()), Product.class);
                if (oldProd != null && oldProd.getReservation().getStatus() == ReservationStatus.ERROR) {
                    oldProd = null;
                }
                if (!(prod.getStatus() != ProductStatus.BOOKING && prod.getStatus() != ProductStatus.SELL || oldProd != null && !wasDraft)) {
                    bookingUids.add(prod.getUid());
                }
                if (prod.getStatus() != ProductStatus.SELL || oldProd != null && oldProd.getStatus() != ProductStatus.BOOKING && !wasDraft) continue;
                ticketingUids.add(prod.getUid());
            }
            String bfUid = bfCtr.getUid();
            if (!bookingUids.isEmpty() && this.hasAfs(false, salesContext = SalesContextHandler.get().createSalesContext(reservation), reservation)) {
                AsyncExecutor.get().execute("gds-afs-booking", (AsyncCommand & Serializable)() -> {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put(IBusMidofficeContextKeys.BOOKING_FILE_REFERENCE.name(), new EntityReference(bfUid, BookingFile.class, null));
                    data.put(IBusGdsContextKeys.AFS_PRODUCT_UIDS_TO_UPDATE.name(), bookingUids);
                    IntegrationBusFacade.get().processRouteSync("gds:afs:afs-bkg", data);
                }, new AsyncCommandOption[0]);
                SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"afs", (Message[])new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"scheduled async execute of gds-afs-booking", (Object[])new Object[0])});
                log.debug(String.format("async execute 'gds-afs-booking' for bf %s", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bfCtr.getEntity()))));
            }
            if (ticketingUids.isEmpty() || !this.hasAfs(true, salesContext = SalesContextHandler.get().createSalesContext(reservation), reservation)) continue;
            AsyncExecutor.get().execute("gds-afs-ticketing", (AsyncCommand & Serializable)() -> {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put(IBusMidofficeContextKeys.BOOKING_FILE_REFERENCE.name(), new EntityReference(bfUid, BookingFile.class, null));
                data.put(IBusGdsContextKeys.AFS_PRODUCT_UIDS_TO_UPDATE.name(), ticketingUids);
                IntegrationBusFacade.get().processRouteSync("gds:afs:afs-tkt", data);
            }, new AsyncCommandOption[0]);
            SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"afs", (Message[])new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"scheduled async execute of gds-afs-ticketing", (Object[])new Object[0])});
            log.debug(String.format("async execute 'gds-afs-ticketing' for bf %s", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bfCtr.getEntity()))));
        }
    }

    private boolean hasAfs(boolean isTicketing, SalesContext salesContext, Reservation reservation) {
        EntityContainer clientRef = EntityStorage.get().resolve(salesContext.getClient());
        if (clientRef == null) {
            return false;
        }
        return !StatisticsHelper.getRequiredAndEmptyAfsTypes((String)((Organization)clientRef.getEntity()).getAfsSettings(), (boolean)isTicketing, (Reservation)reservation).isEmpty();
    }

    private void fillCalculatedAfs(EntityContainer<BookingFile> bfCtr, EntityContainer<BookingFile> oldBfCtr) {
        EntityContainer clientCtr = EntityStorage.get().resolve(((BookingFile)bfCtr.getEntity()).getCustomerProfile());
        if (null == clientCtr) {
            return;
        }
        List afsTypes = StatisticsHelper.getAfsTypesFromString((String)((Organization)clientCtr.getEntity()).getAfsSettings());
        if (!(afsTypes.contains(AFSType.VALC) || afsTypes.contains(AFSType.DEST) || afsTypes.contains(AFSType.ATF1) || afsTypes.contains(AFSType.ATF2))) {
            return;
        }
        ((BookingFile)bfCtr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(p -> p instanceof Product).forEach(p -> this.fillCalculatedAfs((Product)p, oldBfCtr, afsTypes));
    }

    private void fillCalculatedAfs(Product product, EntityContainer<BookingFile> oldBfCtr, List<AFSType> afsTypes) {
        BigDecimal equivalentFare;
        ProductStatus oldProductStatus;
        boolean isFirstBookingVersionAfterCreation;
        StatisticalData statisticalData = product.getStatisticalData();
        if (null == statisticalData) {
            statisticalData = new StatisticalData();
            product.setStatisticalData(statisticalData);
        }
        if (afsTypes.contains(AFSType.ATF1)) {
            isFirstBookingVersionAfterCreation = oldBfCtr == null;
            oldProductStatus = this.getOldProductStatus(product, oldBfCtr);
            if ((product.getStatus() == ProductStatus.BOOKING && isFirstBookingVersionAfterCreation || product.getStatus() == ProductStatus.SELL && oldProductStatus == null) && statisticalData.getAtf1Bkg() == null) {
                equivalentFare = AirProductHelper.getEquivalentFare((Product)product);
                if (equivalentFare == null) {
                    equivalentFare = BigDecimal.ZERO;
                }
                statisticalData.setAtf1Bkg(Double.valueOf(equivalentFare.doubleValue()));
            }
            if (product.getStatus() == ProductStatus.SELL && (oldProductStatus == null || oldProductStatus == ProductStatus.BOOKING) && statisticalData.getAtf1Tkt() == null) {
                equivalentFare = AirProductHelper.getEquivalentFare((Product)product);
                if (equivalentFare == null) {
                    equivalentFare = BigDecimal.ZERO;
                }
                statisticalData.setAtf1Tkt(Double.valueOf(equivalentFare.doubleValue()));
            }
        }
        if (afsTypes.contains(AFSType.ATF2)) {
            Double value;
            isFirstBookingVersionAfterCreation = oldBfCtr == null;
            oldProductStatus = this.getOldProductStatus(product, oldBfCtr);
            if ((product.getStatus() == ProductStatus.BOOKING && isFirstBookingVersionAfterCreation || product.getStatus() == ProductStatus.SELL && oldProductStatus == null) && statisticalData.getAtf2Bkg() == null) {
                equivalentFare = AirProductHelper.getEquivalentFare((Product)product);
                value = (equivalentFare != null ? equivalentFare : BigDecimal.ZERO).add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product)).doubleValue();
                statisticalData.setAtf2Bkg(value);
            }
            if (product.getStatus() == ProductStatus.SELL && (oldProductStatus == null || oldProductStatus == ProductStatus.BOOKING) && statisticalData.getAtf2Tkt() == null) {
                equivalentFare = AirProductHelper.getEquivalentFare((Product)product);
                value = (equivalentFare != null ? equivalentFare : BigDecimal.ZERO).add(AirProductTaxHelper.getEquivalentTaxesAmount((Product)product)).doubleValue();
                statisticalData.setAtf2Tkt(value);
            }
        }
        if (afsTypes.contains(AFSType.VALC) && statisticalData.getValidatingCarrier() == null) {
            statisticalData.setValidatingCarrier(product.getCarrier());
        }
        if (afsTypes.contains(AFSType.DEST) && statisticalData.getOverallDestination() == null) {
            List segments = product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).collect(Collectors.toList());
            if (segments.size() == 1) {
                statisticalData.setOverallDestination(DictHelper.getCity((DictionaryReference)((Segment)segments.get(0)).getArriveLocation()));
            } else if (segments.size() == 2) {
                statisticalData.setOverallDestination(DictHelper.getCity((DictionaryReference)((Segment)segments.get(1)).getDepartureLocation()));
            } else if (segments.size() > 2) {
                if (product.getSegmentTariffs().size() == 1) {
                    statisticalData.setOverallDestination(DictHelper.getCity((DictionaryReference)((Segment)segments.get(segments.size() - 1)).getArriveLocation()));
                } else if (product.getSegmentTariffs().size() == 2) {
                    List lastSegments = ((SegmentTariff)product.getSegmentTariffs().get(1)).getSegments();
                    statisticalData.setOverallDestination(lastSegments.isEmpty() ? null : DictHelper.getCity((DictionaryReference)((Segment)lastSegments.get(0)).getDepartureLocation()));
                } else {
                    Date prevDate = null;
                    for (Segment segment : segments) {
                        Date endDate = segment.getEndDate();
                        if (null == prevDate) {
                            prevDate = endDate;
                            continue;
                        }
                        Date startDate = segment.getStartDate();
                        if (startDate != null && TimeUnit.MILLISECONDS.toDays(startDate.getTime() - prevDate.getTime()) >= 1L) {
                            statisticalData.setOverallDestination(DictHelper.getCity((DictionaryReference)segment.getDepartureLocation()));
                            break;
                        }
                        if (endDate != null) {
                            prevDate = endDate;
                            continue;
                        }
                        if (startDate != null && segment.getFlightDuration() != null) {
                            prevDate = new Date(startDate.getTime() + TimeUnit.MINUTES.toMillis(segment.getFlightDuration().intValue()));
                            continue;
                        }
                        prevDate = null;
                    }
                }
            }
        }
    }

    private ProductStatus getOldProductStatus(Product product, EntityContainer<BookingFile> oldBfCtr) {
        BaseProduct oldBp;
        ProductStatus oldProductStatus = null;
        if (oldBfCtr != null && (oldBp = BookingHelper.findProductByUid((String)product.getUid(), (BookingFile)((BookingFile)oldBfCtr.getEntity()))) != null) {
            oldProductStatus = GeneralProductHelper.getStatus((BaseProduct)oldBp);
        }
        return oldProductStatus;
    }
}

