/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.HasChangedTimeLimitNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.Notification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.ReservationRequestConfirmedNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.ReservationRequestCreatedNotification;
import com.gridnine.xtrip.server.ibecorp.notifications.ReservationRequestRejectedNotification;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class IbeBookingFileContainerNotificationInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 2.147483647E9;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) {
        if (!BookingFile.class.equals((Object)data.getEntityType())) {
            return;
        }
        EntityContainer<?> bfCtr = data;
        EntityContainer oldBfCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(bfCtr.toReference()).getOldCtr();
        if (Objects.nonNull(oldBfCtr)) {
            try {
                NotificationHelper.sendNotification(() -> this.getHotelsNotificationToSend((EntityContainer<BookingFile>)bfCtr, (EntityContainer<BookingFile>)oldBfCtr), bfCtr.toReference(), ss);
                this.getNotificationHasChangedTimeLimit(bfCtr, (EntityContainer<BookingFile>)oldBfCtr).forEach((Consumer<Supplier<Notification>>)((Consumer<Supplier>)notificationSupplier -> NotificationHelper.sendNotification((Supplier<Notification>)notificationSupplier, bfCtr.toReference(), ss)));
            }
            catch (Exception ex) {
                SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"notification-interceptor", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"sendNotifications failed", (Throwable)ex, (Object[])new Object[0])});
            }
        }
    }

    private ArrayList<Supplier<Notification>> getNotificationHasChangedTimeLimit(EntityContainer<BookingFile> bfCtr, EntityContainer<BookingFile> oldBfCtr) {
        ArrayList<Supplier<Notification>> notifications = new ArrayList<Supplier<Notification>>();
        List bfAirResList = BookingHelper.getReservationsForProduct((BookingFile)((BookingFile)bfCtr.getEntity()), (Class[])new Class[]{Product.class});
        List oldAirResList = BookingHelper.getReservationsForProduct((BookingFile)((BookingFile)oldBfCtr.getEntity()), (Class[])new Class[]{Product.class});
        for (Reservation bfAirRes : bfAirResList) {
            Reservation oldAirRes;
            if (CommonIbecorpHelper.getReservationStatus((Reservation)bfAirRes) != ReservationStatus.BOOKING || !Objects.nonNull(oldAirRes = (Reservation)CollectionUtil.find((Iterable)oldAirResList, (String)bfAirRes.getUid())) || CommonIbecorpHelper.getReservationStatus((Reservation)oldAirRes) != ReservationStatus.BOOKING || MiscUtil.equals((Object)MiscUtil.clearTime((Date)oldAirRes.getTimeLimit(), (boolean)false, (boolean)false, (boolean)true, (boolean)true), (Object)MiscUtil.clearTime((Date)bfAirRes.getTimeLimit(), (boolean)false, (boolean)false, (boolean)true, (boolean)true))) continue;
            notifications.add(() -> new HasChangedTimeLimitNotification(new NotificationParameters(bfAirRes, (EntityReference<BookingFile>)bfCtr.toReference()), bfAirRes, oldAirRes));
        }
        return notifications;
    }

    private Notification getHotelsNotificationToSend(EntityContainer<BookingFile> bfCtr, EntityContainer<BookingFile> oldBfCtr) {
        List<Reservation> reservations = this.getOnlineHotelReservations(bfCtr);
        List<Reservation> oldReservations = this.getOnlineHotelReservations(oldBfCtr);
        for (Reservation res : reservations) {
            for (Reservation oldRes : oldReservations) {
                Notification notification;
                if (!res.equals((Object)oldRes) || (notification = this.getNotification(oldRes, res, bfCtr)) == null) continue;
                return notification;
            }
        }
        return null;
    }

    private List<Reservation> getOnlineHotelReservations(EntityContainer<BookingFile> bfCtr) {
        return HotelsReservationHelper.getReservations((BookingFile)((BookingFile)bfCtr.getEntity())).stream().filter(CommonIbecorpHelper::isOnlineReservation).collect(Collectors.toList());
    }

    private Notification getNotification(Reservation oldRes, Reservation res, EntityContainer<BookingFile> bfCtr) {
        if (oldRes.getStatus() == ReservationStatus.INTENTION && res.getStatus() == ReservationStatus.REQUEST) {
            return new ReservationRequestCreatedNotification(new NotificationParameters(res, (EntityReference<BookingFile>)bfCtr.toReference()), res);
        }
        if (oldRes.getStatus() == ReservationStatus.REQUEST) {
            if (res.getStatus() == ReservationStatus.ISSUED) {
                return new ReservationRequestConfirmedNotification(new NotificationParameters(res, (EntityReference<BookingFile>)bfCtr.toReference()), res);
            }
            if (res.getStatus() == ReservationStatus.REJECT) {
                return new ReservationRequestRejectedNotification(new NotificationParameters(res, (EntityReference<BookingFile>)bfCtr.toReference()), res);
            }
        }
        if (oldRes.getStatus() == ReservationStatus.ISSUED && res.getStatus() == ReservationStatus.REJECT) {
            return new ReservationRequestRejectedNotification(new NotificationParameters(res, (EntityReference<BookingFile>)bfCtr.toReference()), res);
        }
        return null;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) {
    }
}

