/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.handlers.ProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.rules.AirRulesHelper;
import java.util.ArrayList;
import java.util.Date;

public class IbeCorpAirProductInterceptor
implements EntityInterceptor {
    public static final double PRIORITY = 2.9;

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> bfCtr = data;
        BookingFile bookingFile = (BookingFile)bfCtr.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                ProductCommissionActionSet actionSet;
                Product clonedProduct;
                RuleProxy ruleProxy;
                if (!(prod instanceof Product)) continue;
                this.setServiceClass((Product)prod);
                if (res.getGdsNameInfo().getOnlineGdsAccount() != null || (ruleProxy = AirRulesHelper.applyContracts((Product)(clonedProduct = (Product)XCloneHelper.clone((XCloneable)((Product)prod))), new ArrayList(), null)) == null || (actionSet = (ProductCommissionActionSet)ruleProxy.getActionSet()).getGdsAccount() == null) continue;
                res.getGdsNameInfo().setOnlineGdsAccount(actionSet.getGdsAccount());
            }
        }
    }

    private void setServiceClass(Product product) {
        product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).forEach(seg -> {
            ClassOfService serviceClass = DictHelper.findClassOfService((Segment)seg, (Date)product.getIssueDate(), (boolean)true);
            if (serviceClass == null && seg.getServiceClass() == null) {
                throw Xeption.forAdmin((String)"AVIA_NO_CLASS_OF_SERVICE", (Object[])new Object[]{seg.getCodeShareCarrier(), seg.getAirline(), seg.getClassOfSvcCode()});
            }
            if (serviceClass != null) {
                seg.setServiceClass(serviceClass);
            }
        });
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public double getPriority() {
        return 2.9;
    }
}

