/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndexData;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.booking.ReservationIndexInfo;
import com.gridnine.xtrip.common.model.profile.ExternalSystem;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCode;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCodeV2;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStatus;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GeoLocationReference;
import com.gridnine.xtrip.server.model.index.registry.BookingFileIndexRegistryHandler;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class IbeCorpBookingFileIndexRegistryHandler
extends BookingFileIndexRegistryHandler {
    public static final Set<ReservationStatus> TIME_LIMIT_RESERVATION_STATUSES = EnumSet.of(ReservationStatus.BOOKING, ReservationStatus.INTENTION, ReservationStatus.ERROR);
    private static final DateTimeFormatter DF = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public void updateData(EntityContainer<BookingFile> etc, BookingFileIndexData data, DataAggregator aggregator) {
        super.updateData(etc, data, aggregator);
        BookingFile bookingFile = (BookingFile)etc.getEntity();
        data.setSite(bookingFile.getSite());
        data.setAuthTimeLimit(IbeCorpBookingFileIndexRegistryHandler.calculateAuthTimeLimit(bookingFile));
        data.setPqTimeLimit(this.findTimeLimit(bookingFile, Reservation::getPqTimeLimit));
        data.setAuthStatuses(this.collectAuthStatuses(bookingFile));
        data.setReservationStatuses((Collection)bookingFile.getReservations().stream().map(Reservation::getStatus).filter(Objects::nonNull).collect(Collectors.toSet()));
        data.setFailedCancelling(Boolean.valueOf(bookingFile.isFailedCancelling() || bookingFile.getReservations().stream().allMatch(Reservation::isFailedCancelling)));
        List<BaseProduct> products = bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).collect(Collectors.toList());
        data.setFirstTravelDate(this.getFirstTravelDate(products));
        String travelLocation = this.getTravelLocation(products);
        data.setTravelLocation(travelLocation);
        data.setStartOfTravel(this.getStartOfTravel(products));
        data.setReservationIndexInfo(this.buildReservationIndexInfo(bookingFile));
        data.setTotalPriceCurrency(this.getTotalPriceCurrency(products));
        Date timeLimit = this.getTimeLimit(bookingFile);
        data.setTimelimit(timeLimit);
        HashSet<EntityReference> agents = new HashSet<EntityReference>();
        TreeSet<String> issueDates = new TreeSet<String>();
        Date firstIssueDate = null;
        Date lastIssueDate = null;
        for (BaseProduct prod : products) {
            Date issueDate;
            ProductHandler handler = ProductHandler.of((BaseProduct)prod);
            EntityReference agentRef = handler.findIssuingAgent(prod);
            if (agentRef != null) {
                agents.add(agentRef);
            }
            if ((issueDate = MiscUtil.clearTime((Date)handler.findIssueDate(prod))) == null) continue;
            issueDates.add(DF.format(Objects.requireNonNull(MiscUtil.toLocalDate((Date)issueDate))));
            if (null == firstIssueDate) {
                firstIssueDate = issueDate;
            } else if (firstIssueDate.after(issueDate)) {
                firstIssueDate = issueDate;
            }
            if (null == lastIssueDate) {
                lastIssueDate = issueDate;
                continue;
            }
            if (!lastIssueDate.before(issueDate)) continue;
            lastIssueDate = issueDate;
        }
        data.setAgents(agents);
        data.setIssueDates(issueDates);
        data.setFirstIssueDate(firstIssueDate);
        data.setLastIssueDate(lastIssueDate);
        data.setUniqueTravellers((Collection)bookingFile.getTravellers().stream().filter(Objects::nonNull).collect(Collectors.toMap(t -> t.getPassenger() != null ? t.getPassenger() : t, Function.identity(), (o1, o2) -> o1)).values().stream().map(this::travellerFIO).filter(TextUtil::nonBlank).collect(Collectors.toSet()));
        LinkedHashSet<String> searchTravellers = new LinkedHashSet<String>();
        bookingFile.getTravellers().stream().filter(Objects::nonNull).collect(Collectors.toMap(t -> t.getPassenger() != null ? t.getPassenger() : t, Function.identity(), (o1, o2) -> o1)).values().forEach(t -> {
            if (null == t) {
                return;
            }
            searchTravellers.add(t.getName());
            EntityContainer personCtr = EntityStorage.get().resolve(t.getPassenger());
            if (null == personCtr) {
                return;
            }
            Person person = (Person)personCtr.getEntity();
            searchTravellers.add(PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (boolean)true, (Locale)LocaleHelper.RU_LOCALE, (boolean)false));
            searchTravellers.add(PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (boolean)true, (Locale)LocaleHelper.EN_LOCALE, (boolean)false));
        });
        searchTravellers.removeIf(TextUtil::isBlank);
        data.setSearchTravellers(searchTravellers);
        if (bookingFile.getCorteosSettings().getCorteosId() != null) {
            data.setCorteosId(bookingFile.getCorteosSettings().getCorteosId().toString());
            aggregator.aggregate((Object)bookingFile.getCorteosSettings().getCorteosId());
        }
        data.setRaketaId(bookingFile.getExternalCodes().stream().filter(externalCode -> "RAKETA".equals(externalCode.getSystem().getCode())).findFirst().map(ExternalSystemCodeV2::getCode).orElseGet(() -> Optional.ofNullable(bookingFile.getExternalCode()).filter(externalCode -> ExternalSystem.RAKETA.equals((Object)externalCode.getSystem())).map(ExternalSystemCode::getCode).orElse(null)));
    }

    private static Date calculateAuthTimeLimit(BookingFile bookingFile) {
        return bookingFile.getReservations().stream().filter(r -> r.getStatus() == ReservationStatus.AUTHORIZATION).map(Reservation::getProducts).flatMap(Collection::stream).map(TravelPolicyAuthorizationHelper::getAuthorizationTimeLimit).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null);
    }

    private List<String> buildReservationIndexInfo(BookingFile bookingFile) {
        ArrayList<ReservationIndexInfo> reservationIndexInfoList = new ArrayList<ReservationIndexInfo>();
        for (Reservation reservation : bookingFile.getReservations()) {
            ReservationIndexInfo reservationIndexInfo = new ReservationIndexInfo();
            reservation.getProducts().stream().limit(1L).forEach(baseProduct -> reservationIndexInfo.setTravelSubject(ProductHandler.of((BaseProduct)baseProduct).findTravelSubject(baseProduct)));
            reservationIndexInfo.setStatus(reservation.getStatus());
            for (BaseProduct product : reservation.getProducts()) {
                ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
                String localizedRouteLine = productHandler.getLocalizedRouteLine(product);
                reservationIndexInfo.getRoutes().add(localizedRouteLine);
                EntityReference universalProductDescription = productHandler.getUniversalProductDescription(product);
                if (reservationIndexInfo.getUniversalProductDesc() == null && universalProductDescription != null) {
                    reservationIndexInfo.setUniversalProductDesc(universalProductDescription);
                }
                ProductType productType = productHandler.getProductType(product);
                if (reservationIndexInfo.getProductType() != null || productType == null) continue;
                reservationIndexInfo.setProductType(productType);
            }
            reservationIndexInfoList.add(reservationIndexInfo);
        }
        return this.convertReservationIndexInfo(reservationIndexInfoList);
    }

    private Date getTimeLimit(BookingFile bf) {
        return MiscUtil.minimum((Date[])((Date[])bf.getReservations().stream().filter(res -> res.getStatus() != null).filter(res -> TIME_LIMIT_RESERVATION_STATUSES.contains(res.getStatus())).filter(res -> !res.isFailedCancelling()).map(Reservation::getTimeLimit).filter(Objects::nonNull).toArray(Date[]::new)));
    }

    private List<String> convertReservationIndexInfo(Collection<ReservationIndexInfo> infoProducts) {
        LinkedList<String> stringList = new LinkedList<String>();
        for (ReservationIndexInfo indexInfo : infoProducts) {
            try {
                stringList.add(XSUtil.toString((XSSerializable)indexInfo));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stringList;
    }

    private Set<TravelPolicyAuthorizationStatus> collectAuthStatuses(BookingFile bookingFile) {
        return BookingStreamHelper.getBaseProductsStream((BookingFile)bookingFile).map(TravelPolicyAuthorizationHelper::getAuthorizationStatus).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected String travellerFIO(Traveller traveller) {
        if (null == traveller) {
            return null;
        }
        EntityContainer personCtr = EntityStorage.get().resolve(traveller.getPassenger());
        if (personCtr != null) {
            return ((Person)personCtr.getEntity()).toString();
        }
        return traveller.getName();
    }

    protected Date getFirstTravelDate(List<BaseProduct> products) {
        for (BaseProduct p : products) {
            List segments;
            if (p instanceof Product) {
                Product air = (Product)p;
                segments = air.getSegmentTariffs().stream().flatMap(s -> s.getSegments().stream()).collect(Collectors.toList());
                if (segments.isEmpty()) continue;
                return ((Segment)segments.get(0)).getStartDate();
            }
            if (p instanceof RailwayProduct) {
                RailwayProduct rail = (RailwayProduct)p;
                segments = rail.getSegments();
                if (segments.isEmpty()) continue;
                return ((RailwaySegment)segments.get(0)).getDepartureDate();
            }
            if (!(p instanceof HotelProduct)) continue;
            HotelProduct hotel = (HotelProduct)p;
            return HotelProductHelper.getCheckInDate((HotelProduct)hotel);
        }
        try {
            BaseProduct product = products.get(0);
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            return handler.getFirstStartDate(product);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Date findTimeLimit(BookingFile bookingFile, Function<Reservation, Date> getDate) {
        return bookingFile.getReservations().stream().map(getDate).filter(Objects::nonNull).min(Date::compareTo).orElse(null);
    }

    private String getStartOfTravel(List<BaseProduct> products) {
        for (BaseProduct p : products) {
            List segments;
            if (p instanceof Product) {
                Product air = (Product)p;
                segments = air.getSegmentTariffs().stream().flatMap(s -> s.getSegments().stream()).collect(Collectors.toList());
                if (segments.isEmpty()) continue;
                Segment firstSegment = (Segment)segments.get(0);
                return IbeCorpBookingFileIndexRegistryHandler.getGeoCity((DictionaryReference<GeoLocation>)firstSegment.getDepartureLocation());
            }
            if (p instanceof RailwayProduct) {
                RailwayProduct rail = (RailwayProduct)p;
                segments = rail.getSegments();
                if (segments.isEmpty()) continue;
                RailwaySegment firstSegment = (RailwaySegment)segments.get(0);
                return IbeCorpBookingFileIndexRegistryHandler.getStationCity((DictionaryReference<RailwayStation>)firstSegment.getDepartureStation());
            }
            if (!(p instanceof HotelProduct)) continue;
            return null;
        }
        return null;
    }

    private String getTravelLocation(List<BaseProduct> products) {
        for (BaseProduct p : products) {
            List segments;
            if (p instanceof Product) {
                String arriveLocation;
                Product air = (Product)p;
                segments = air.getSegmentTariffs().stream().flatMap(s -> s.getSegments().stream()).collect(Collectors.toList());
                if (segments.isEmpty()) continue;
                Segment firstSegment = (Segment)segments.get(0);
                String departureLocation = IbeCorpBookingFileIndexRegistryHandler.getGeoCity((DictionaryReference<GeoLocation>)firstSegment.getDepartureLocation());
                if (!Objects.equals(departureLocation, arriveLocation = IbeCorpBookingFileIndexRegistryHandler.getGeoCity((DictionaryReference<GeoLocation>)((Segment)segments.get(segments.size() - 1)).getArriveLocation()))) {
                    return arriveLocation;
                }
                return IbeCorpBookingFileIndexRegistryHandler.getGeoCity((DictionaryReference<GeoLocation>)firstSegment.getArriveLocation());
            }
            if (p instanceof RailwayProduct) {
                RailwayProduct rail = (RailwayProduct)p;
                segments = rail.getSegments();
                if (segments.isEmpty()) continue;
                RailwaySegment firstSegment = (RailwaySegment)segments.get(0);
                return IbeCorpBookingFileIndexRegistryHandler.getStationCity((DictionaryReference<RailwayStation>)firstSegment.getArriveStation());
            }
            if (!(p instanceof HotelProduct)) continue;
            HotelProduct hotel = (HotelProduct)p;
            return IbeCorpBookingFileIndexRegistryHandler.getGeoCity((DictionaryReference<GeoLocation>)hotel.getHotelLocation());
        }
        try {
            BaseProduct product = products.get(0);
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            return handler.getRouteLine(product);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getGeoCity(DictionaryReference<GeoLocation> geoLocationRef) {
        GeoLocationReference loc;
        GeoLocation city;
        GeoLocation geoLocation = (GeoLocation)DictHelper.resolve(geoLocationRef);
        if (null == geoLocation) {
            return null;
        }
        if (geoLocation.getType() != LocationType.CITY && (city = DictHelper.findCity((GeoLocation)geoLocation)) != null) {
            geoLocation = city;
        }
        return TextUtil.isBlank((String)(loc = AviaConverterHelper.convertGeoLocationReference2Rest(geoLocation, LocaleHelper.getCurrentLocale())).getAirportCaption()) ? loc.getCityCaption() : loc.getAirportCaption();
    }

    private static String getStationCity(DictionaryReference<RailwayStation> stationRef) {
        RailwayStation city;
        RailwayStation station = (RailwayStation)DictionaryCache.get().resolveReference(stationRef);
        if (null == station) {
            return null;
        }
        RailwayStation railwayStation = city = Boolean.TRUE.equals(station.getMainCityStation()) ? station : DictionaryCache.get().search(RailwayStation.class, DictSearchCriterion.eq((String)RailwayStation.Property.geoLocation.name(), (Object)station.getGeoLocation())).stream().filter(s -> Boolean.TRUE.equals(s.getMainCityStation())).findFirst().orElse(station);
        if (city.getGeoLocation() != null) {
            return IbeCorpBookingFileIndexRegistryHandler.getGeoCity((DictionaryReference<GeoLocation>)city.getGeoLocation());
        }
        return (String)MiscUtil.findByLocale((Map)city.getTranslations(), (Locale)LocaleManager.get().getCurrentLocale());
    }

    private String getTotalPriceCurrency(List<BaseProduct> products) {
        for (BaseProduct product : products) {
            GeneralProductContractRelationData clientContractRelation;
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
            if (handler == null || (clientContractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product)) == null) continue;
            return clientContractRelation.getGeneralData().getCurrency() != null ? clientContractRelation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
        }
        return DictHelper.getLocalCurrency();
    }
}

