/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.util.CardVendorUtils;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;

public class IbeCorpCardVendorInterceptor
implements EntityInterceptor {
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (EntityStorageHelper.isEmpty(data)) {
            return;
        }
        if (data.getEntity() instanceof Person) {
            Person person = (Person)data.getEntity();
            person.getCards().stream().filter(Objects::nonNull).filter(card -> Objects.isNull(card.getVendor())).filter(card -> StringUtils.isNotBlank((String)card.getNumber())).forEach(this.determineCardVendor());
        }
    }

    private Consumer<Card> determineCardVendor() {
        return card -> {
            String number = card.getNumber();
            CardVendor cardVendor = CardVendorUtils.determineCardIssuer((String)number);
            if (cardVendor != null) {
                card.setVendor(cardVendor);
            }
        };
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public double getPriority() {
        return 2.147483647E9;
    }
}

