/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.HoldingIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class IbeCorpContractHoldingIndexInterceptor
implements EntityInterceptor {
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (Organization.class.equals((Object)data.getEntityType())) {
            EntityContainer<?> newContainer = data;
            EntityContainer oldContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
            MiscUtil.Pair<EntityReference<Holding>, String> newPair = this.getHoldingDataForOrganization(newContainer);
            MiscUtil.Pair<EntityReference<Holding>, String> oldPair = oldContainer == null ? null : this.getHoldingDataForOrganization((EntityContainer<Organization>)oldContainer);
            this.updateHoldingIndexes(newPair, oldPair);
            return;
        }
        if (Contract.class.equals((Object)data.getEntityType())) {
            EntityContainer<?> newContractContainer = data;
            EntityContainer oldContractContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
            MiscUtil.Pair<EntityReference<Holding>, String> newPair = this.getHoldingDataForContract(newContractContainer);
            MiscUtil.Pair<EntityReference<Holding>, String> oldPair = oldContractContainer == null ? null : this.getHoldingDataForContract((EntityContainer<Contract>)oldContractContainer);
            this.updateHoldingIndexes(newPair, oldPair);
            return;
        }
    }

    private MiscUtil.Pair<EntityReference<Holding>, String> getHoldingDataForOrganization(EntityContainer<Organization> newContainer) {
        if (((Organization)newContainer.getEntity()).getHolding() == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)newContainer.toReference()));
        List contractCustomerIndexes = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        return contractCustomerIndexes.size() > 0 ? new MiscUtil.Pair((Object)((Organization)newContainer.getEntity()).getHolding(), (Object)((ContractCustomerIndex)contractCustomerIndexes.get(0)).getSupplier().getUid()) : null;
    }

    private void updateHoldingIndexes(MiscUtil.Pair<EntityReference<Holding>, String> newPair, MiscUtil.Pair<EntityReference<Holding>, String> oldPair) {
        HashSet<Object> entitiesToUpdate = new HashSet<Object>();
        if (oldPair != null) {
            if (!MiscUtil.equals(newPair, oldPair)) {
                if (newPair != null) {
                    entitiesToUpdate.add(newPair.getFirst());
                }
                if (oldPair != null) {
                    entitiesToUpdate.add(oldPair.getFirst());
                }
            }
        } else if (newPair != null) {
            entitiesToUpdate.add(newPair.getFirst());
        }
        if (!entitiesToUpdate.isEmpty()) {
            AsyncExecutor.get().execute(this.getClass().getName(), (AsyncCommand & Serializable)() -> entitiesToUpdate.forEach(it -> {
                EntityContainer holdingCtr = EntityStorage.get().resolve(it);
                if (holdingCtr != null) {
                    LogicalStorage.get().getEntityStorage().updateIndexes(holdingCtr, holdingCtr, Collections.singleton(HoldingIndex.class), true);
                }
            }), new AsyncCommandOption[0]);
        }
    }

    private MiscUtil.Pair<EntityReference<Holding>, String> getHoldingDataForContract(EntityContainer<Contract> contractCtr) {
        EntityContainer orgCtr = EntityStorage.get().resolve(((Contract)contractCtr.getEntity()).getCustomer());
        if (((Contract)contractCtr.getEntity()).getContractType() != ContractType.CLIENT || ((Contract)contractCtr.getEntity()).getSupplier() == null || orgCtr == null || ((Organization)orgCtr.getEntity()).getHolding() == null) {
            return null;
        }
        return new MiscUtil.Pair((Object)((Organization)orgCtr.getEntity()).getHolding(), (Object)((Contract)contractCtr.getEntity()).getSupplier().getUid());
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (Contract.class.equals((Object)data.getEntityType())) {
            EntityContainer<?> newContractContainer = data;
            MiscUtil.Pair<EntityReference<Holding>, String> newPair = this.getHoldingDataForContract(newContractContainer);
            this.updateHoldingIndexes(newPair, null);
            return;
        }
        if (Organization.class.equals((Object)data.getEntityType())) {
            EntityContainer<?> newContractContainer = data;
            MiscUtil.Pair<EntityReference<Holding>, String> newPair = this.getHoldingDataForOrganization(newContractContainer);
            this.updateHoldingIndexes(newPair, null);
            return;
        }
    }

    public double getPriority() {
        return 10.0;
    }
}

