/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndexData;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.model.index.FinanceDocumentRecordIndexHandler;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class IbeCorpFinanceDocumentRecordIndexHandler
extends FinanceDocumentRecordIndexHandler {
    protected void updateData(FinanceDocumentRecordIndexData data, DataAggregator aggregator, EntityContainer<FinanceDocument> etc) {
        super.updateData(data, aggregator, etc);
        FinanceDocument doc = (FinanceDocument)etc.getEntity();
        Object[] shipmentUids = (String[])doc.getRelatedShipments().stream().map(EntityReference::getUid).toArray(String[]::new);
        if (shipmentUids.length != 0) {
            SearchQuery shipmentQuery = new SearchQuery();
            shipmentQuery.getCriteria().getCriterions().add(SearchCriterion.in((String)"containerUid", (Object[])shipmentUids));
            List shipmentIndices = EntityStorage.get().search(ShipmentIndex.class, shipmentQuery).getData();
            Set shipmentNumbers = shipmentIndices.stream().map(ShipmentIndex::getNumber).collect(Collectors.toSet());
            data.setShipmentNumbers(shipmentNumbers);
        }
    }
}

