/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.HoldingIndexData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.model.index.HoldingIndexHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class IbeCorpHoldingIndexHandler
extends HoldingIndexHandler {
    protected void updateData(HoldingIndexData holdingIndexData, DataAggregator aggregator, EntityContainer<Holding> holdingEntityContainer, List<EntityReference<Organization>> holdingOrganizations) {
        super.updateData(holdingIndexData, aggregator, holdingEntityContainer, holdingOrganizations);
        HashSet<String> supplierUids = new HashSet<String>();
        if (holdingOrganizations.size() > 0) {
            SearchQuery query = new SearchQuery();
            Set<String> clientUids = holdingOrganizations.stream().map(it -> it.getUid()).collect(Collectors.toSet());
            query.getCriteria().getCriterions().add(SearchCriterion.in((String)ContractCustomerIndex.Property.customer.name(), (Object[])clientUids.toArray(new String[clientUids.size()])));
            List contractCustomerIndexes = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
            for (ContractCustomerIndex contractCustomerIndex : contractCustomerIndexes) {
                if (contractCustomerIndex == null || contractCustomerIndex.getSupplier() == null) continue;
                supplierUids.add(contractCustomerIndex.getSupplier().getUid());
            }
        }
        holdingIndexData.setSubagencyUids(supplierUids);
    }
}

