/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.hotels2.HotelAggregatorSettings;
import com.gridnine.xtrip.common.hotels2.model.BaseHotelParameters;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.interceptors.ProductsHelper;
import java.util.HashMap;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.LoggerFactory;

public class IbeCorpHotelProductInterceptor
implements EntityInterceptor {
    public static final double priority = 2.0;

    public double getPriority() {
        return 2.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.equals((Object)data.getEntityType())) {
            return;
        }
        EntityContainer<?> bookingFileContainer = data;
        EntityContainer oldBookingFileContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof HotelProduct)) continue;
                HotelProduct product = (HotelProduct)prod;
                boolean isNewProduct = ProductsHelper.isNewProduct((EntityContainer)oldBookingFileContainer, (BaseProduct)product);
                this.updateProduct(product, isNewProduct);
            }
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    private void updateProduct(HotelProduct product, boolean isNewProduct) {
        if (!isNewProduct) {
            if (BooleanUtils.isNotTrue((Boolean)product.getHotelResolved())) {
                this.updateHotelInfo(product);
            }
        } else if (product.getStatus() == ProductStatus.REFUND) {
            this.unholdRefund(product);
        }
    }

    private void unholdRefund(HotelProduct product) {
        if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL && product.getPreviousProduct().getUnholdDate() == null) {
            HotelProductHelper.setOnHold((HotelProduct)product.getPreviousProduct(), (boolean)false);
        }
        if (product.getUnholdDate() == null) {
            HotelProductHelper.setOnHold((HotelProduct)product, (boolean)false);
        }
    }

    private void updateHotelInfo(HotelProduct product) {
        if (this.isContextValid(product)) {
            HashMap<String, BaseHotelParameters> data = new HashMap<String, BaseHotelParameters>();
            BaseHotelParameters params = new BaseHotelParameters();
            params.setHotelNumber(product.getHotelPropertyId());
            params.setProvider(product.getProvider());
            data.put(IBusHotelsContextKeys.HOTELS_BASE_HOTEL_PARAMS.name(), params);
            try {
                IntegrationBusFacade.get().processRouteSync("hotels2:get-hotel:get-hotel-route", data);
                HotelCard hotelCard = (HotelCard)data.get(IBusHotelsContextKeys.HOTELS_HOTEL_CARD.name());
                if (hotelCard != null) {
                    product.setHotelResolved(hotelCard.getHotelResolved());
                } else {
                    product.setHotelPropertyId(null);
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
            }
        }
    }

    private boolean isContextValid(HotelProduct product) {
        EntityContainer aggregatorSettings = HotelsHelper.getHotelAggregatorSettings();
        return aggregatorSettings != null && ((HotelAggregatorSettings)aggregatorSettings.getEntity()).isEnabled() && TextUtil.nonBlank((String)product.getHotelPropertyId());
    }
}

