/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContract2Organization;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContractIndexData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.index.ModelContractIndexHandler;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class IbeCorpModelContractIndexHandler
extends ModelContractIndexHandler
implements IndexHandler<ModelContract, ModelContractIndex> {
    protected void fillIndexData(EntityContainer<ModelContract> etc, ModelContractIndexData data, DataAggregator aggregator) {
        super.fillIndexData(etc, data, aggregator);
        ModelContract entity = (ModelContract)etc.getEntity();
        data.setAgencies((Collection)entity.getAgencies().stream().map(ModelContract2Organization::getOrganization).distinct().collect(Collectors.toList()));
        List<ContractIndex> contracts = this.getRelatedDirectContracts(etc);
        List suppliers = contracts.stream().map(ContractIndex::getSupplier).filter(Objects::nonNull).distinct().sorted((a, b) -> TextUtil.compare((String)a.getCaption(), (String)b.getCaption(), (boolean)false, (boolean)false)).collect(Collectors.toList());
        List customers = contracts.stream().map(ContractIndex::getCustomer).filter(Objects::nonNull).distinct().sorted((a, b) -> TextUtil.compare((String)a.getCaption(), (String)b.getCaption(), (boolean)false, (boolean)false)).collect(Collectors.toList());
        data.setContractsSuppliers(suppliers);
        data.setContractsCustomers(customers);
    }

    private List<ContractIndex> getRelatedDirectContracts(EntityContainer<ModelContract> etc) {
        SearchQuery query = new SearchQuery();
        query.setLimit(100);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)ContractIndex.Property.modelContracts.name(), (Object)etc.toReference()));
        Date date = new Date();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)date))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)date))}));
        return EntityStorage.get().search(ContractIndex.class, query).getData();
    }
}

