/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.corteos.CorteosOrganizationData;
import com.gridnine.xtrip.common.model.ibecorp.profile.OrganizationHotel;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapOrganizationData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.model.index.OrganizationIndexHandler;
import java.util.ArrayList;

public class IbeCorpOrganizationIndexHandler
extends OrganizationIndexHandler {
    protected void updateData(OrganizationIndexData data, DataAggregator aggregator, EntityContainer<Organization> etc) {
        super.updateData(data, aggregator, etc);
        Organization organization = (Organization)etc.getEntity();
        data.setB2bSite(organization.getB2bSite());
        aggregator.aggregate((Object)organization.getB2bSite());
        data.setB2cSite(organization.getB2cSite());
        aggregator.aggregate((Object)organization.getB2cSite());
        CorteosOrganizationData corteosSettings = organization.getCorteosSettings();
        data.setCorteosSyncEnabled(Boolean.valueOf(corteosSettings.isSyncEnabled()));
        data.setCorteosId(corteosSettings.getCorteosId());
        data.setCorteosClientAgreementNumber(corteosSettings.getClientAgreementNumber());
        data.setCorteosGroupId(corteosSettings.getGroupId());
        data.setCorteosAccountsCreationEnabled(Boolean.valueOf(corteosSettings.isCreateAccounts()));
        data.setCorteosServerAddress(corteosSettings.getServerAddress());
        data.setCorteosLogin(corteosSettings.getLogin());
        data.setCorteosPassword(corteosSettings.getPassword());
        data.setCorteosAssistantRoleId(corteosSettings.getAssistantRoleId());
        aggregator.aggregate((Object)corteosSettings.getCorteosId());
        aggregator.aggregate((Object)corteosSettings.getClientAgreementNumber());
        aggregator.aggregate((Object)corteosSettings.getGroupId());
        SapOrganizationData sapSettings = organization.getSapSettings();
        data.setSapId(sapSettings.getSapId());
        data.setSapSyncEnabled(Boolean.valueOf(sapSettings.isSyncEnabled()));
        aggregator.aggregate((Object)sapSettings.getSapId());
        ArrayList<String> list = new ArrayList<String>();
        for (EntityReference ref : organization.getAclSettings().getOrganizationAclRoles()) {
            if (ref == null) continue;
            list.add(ref.getUid());
        }
        data.setRoleOrganizationUids(list);
        OrganizationHotel hotel = organization.getHotel();
        if (hotel != null) {
            data.setHotelName(hotel.getHotelName());
            data.setHotelNumber(hotel.getHotelNumber());
            data.setHotelCity(hotel.getHotelCity());
            data.setHotel(Boolean.valueOf(true));
        } else {
            data.setHotel(Boolean.valueOf(false));
        }
    }
}

