/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.corteos.CorteosPersonData;
import com.gridnine.xtrip.common.model.corteos.CorteosPersonProfileData;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndexData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.model.index.PersonIndexHandler;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class IbeCorpPersonIndexHandler
extends PersonIndexHandler {
    protected void updateData(PersonIndexData data, DataAggregator aggregator, EntityContainer<Person> etc) {
        super.updateData(data, aggregator, etc);
        Person person = (Person)etc.getEntity();
        CorteosPersonData corteosSettings = person.getCorteosSettings();
        data.setCorteosLastSyncDate(corteosSettings.getLastSyncDate());
        data.setCorteosLastSyncAttemptDate(corteosSettings.getLastSyncAttemptDate());
        data.setCorteosLastSyncStatus(corteosSettings.getSyncStatus());
        data.setCorteosLastUpdateDate(corteosSettings.getLastUpdateDate());
        data.setCorteosLastUpdateAttemptDate(corteosSettings.getLastUpdateAttemptDate());
        data.setCorteosLastUpdateStatus(corteosSettings.getUpdateStatus());
        data.setCorteosLastDeleteDate(corteosSettings.getLastDeleteDate());
        data.setCorteosLastDeleteAttemptDate(corteosSettings.getLastDeleteAttemptDate());
        data.setCorteosLastDeleteStatus(corteosSettings.getDeleteStatus());
        List corteosIds = corteosSettings.getProfileData().stream().map(CorteosPersonProfileData::getCorteosId).filter(Objects::nonNull).distinct().map(Objects::toString).collect(Collectors.toList());
        List corteosAccountIds = corteosSettings.getProfileData().stream().map(CorteosPersonProfileData::getAccountId).filter(Objects::nonNull).distinct().map(Objects::toString).collect(Collectors.toList());
        List corteosRoleIds = corteosSettings.getProfileData().stream().map(CorteosPersonProfileData::getRoleId).filter(Objects::nonNull).distinct().map(Objects::toString).collect(Collectors.toList());
        data.setCorteosIds(corteosIds);
        aggregator.aggregate(corteosIds);
        data.setCorteosAccountIds(corteosAccountIds);
        aggregator.aggregate(corteosAccountIds);
        data.setCorteosRoleIds(corteosRoleIds);
        data.setSapId(person.getSapId());
        aggregator.aggregate((Object)person.getSapId());
        data.setSapAssistant(Boolean.valueOf(person.isSapAssistant()));
        aggregator.aggregate((Object)person.isSapAssistant());
        Optional.ofNullable(person.getSapIntegrationSyncData()).ifPresent(syncData -> {
            data.setSapSyncDate(MiscUtil.toDate((LocalDateTime)syncData.getSyncDate()));
            aggregator.aggregate((Object)syncData.getSyncDate());
            data.setSapSyncStatus(syncData.getStatusSync());
            aggregator.aggregate((Enum)syncData.getStatusSync());
        });
        data.setPossibleDuplicate((Collection)person.getPossibleDuplicate());
        EntityReference company = ProfileHelper.getMainEmploymentRef((Person)person);
        data.setCompany(company);
        aggregator.aggregate((Object)company);
        data.setAclRole(person.getAclSettings().getAclRole());
    }
}

