/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductIndexData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.model.index.ProductIndexHandler;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Set;

public class IbeCorpProductIndexHandler
extends ProductIndexHandler {
    protected void updateData(ProductIndexData data, DataAggregator aggregator, Product product) {
        super.updateData(data, aggregator, product);
        data.setBookingNumber(TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
        data.setNotes(product.getReservation().getBookingFile().getNotes());
        data.setTimelimit(product.getReservation().getTimeLimit());
        data.setIncome(this.calculateTotalIncome(product));
        if (product.getStatus() == ProductStatus.VOID || product.getStatus() == ProductStatus.VOID_BOOKING || product.getStatus() == ProductStatus.VOID_INTENTION) {
            String travellerName = null;
            if (product.getTraveller() != null) {
                travellerName = product.getTraveller().getPassport() != null && !TextUtil.isBlank((String)TextUtil.buildFullName((PersonalName)product.getTraveller().getPassport())) ? TextUtil.buildFullName((PersonalName)product.getTraveller().getPassport()) : product.getTraveller().getName();
            }
            data.setTravellerName(travellerName);
            if (!product.getSegmentTariffs().isEmpty() && !((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().isEmpty()) {
                data.setFirstFlightDate(((Segment)((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().get(0)).getStartDate());
            }
            String routeLineCodes = AirProductHelper.getRouteLine((Product)product, null, (boolean)true, (CodeSystem)CodeSystem.IATA);
            data.setRouteLineCodes(routeLineCodes);
            VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
            BigDecimal totalSum = price.getTotal();
            data.setTotalSum(totalSum);
        }
    }

    private BigDecimal calculateTotalIncome(Product product) {
        if (product.getStatus() == ProductStatus.VOID || product.getStatus() == ProductStatus.VOID_BOOKING) {
            return BigDecimal.ZERO;
        }
        BigDecimal agentFee = MiscUtil.nonNull((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)));
        BigDecimal subagentFee = MiscUtil.nonNull((BigDecimal)AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)));
        BigDecimal subagentCommission = MiscUtil.nonNull((BigDecimal)(((SalesChainDescription)EntityStorage.get().resolve(AirProductHelper.getSalesChain((Product)product).getDescription()).getEntity()).getPredefinedType() == PredefinedSalesChainType.OWN ? AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionPropertyTypes, null, null)) : AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionPropertyTypes, null, null))));
        return subagentFee.subtract(agentFee).add(subagentCommission);
    }
}

