/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.ibecorp.storage.XreportsBookingMarkerObject;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.ibecorp.xreports.XreportsIntegrationSettings;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.LogicalStorageHelper;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.ibecorp.helpers.XreportsIntegrationHelper;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IbeCorpXreportsBookingMarkerInterceptor
implements EntityInterceptor {
    private static final String KEY_CREATED_MARKER_OBJECTS_BOOKINGS_UIDS = "KEY_CREATED_MARKER_OBJECTS_BOOKINGS_UIDS";

    public double getPriority() {
        return 2.147483647E9;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (XreportsIntegrationSettings.class.equals((Object)data.getEntityType())) {
            return;
        }
        if (!this.isXreportsEnabled()) {
            return;
        }
        if (BookingFile.class.equals((Object)data.getEntityType())) {
            if (!this.getMarkerObjectsBookingUids().contains(data.getUid())) {
                this.createMarkerObject(data.getUid());
            }
        } else if (BasePaymentDocument.class.isAssignableFrom(data.getEntityType())) {
            BasePaymentDocument doc = (BasePaymentDocument)data.getEntity();
            for (EntityReference shipmentRef : doc.getRelatedShipments()) {
                EntityContainer shipmentCtr = EntityStorageHelper.resolve((EntityReference)shipmentRef, (EntityStorageContext)LogicalStorageHelper.getEntityStorageContext());
                if (shipmentCtr == null) continue;
                this.createMarkerObjectForShipment((Shipment)shipmentCtr.getEntity());
            }
        } else if (Shipment.class.equals((Object)data.getEntityType())) {
            Shipment shipment = (Shipment)data.getEntity();
            EntityContainer oldShipmentCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
            if (oldShipmentCtr != null) {
                Shipment oldShipment = (Shipment)oldShipmentCtr.getEntity();
                if (oldShipment.isAmountChecked() != shipment.isAmountChecked()) {
                    this.createMarkerObjectForShipment(shipment);
                }
            } else if (shipment.isAmountChecked()) {
                this.createMarkerObjectForShipment(shipment);
            }
        }
    }

    private void createMarkerObjectForShipment(Shipment shipment) {
        EntityStorageContext ctx = LogicalStorageHelper.getEntityStorageContext();
        FinanceDocumentHelper.getBillingItems((List)shipment.getBillingItems(), (EntityStorageContext)ctx).forEach(item -> {
            String bookingUid = item.getProduct().getUid();
            if (!this.getMarkerObjectsBookingUids().contains(bookingUid)) {
                this.createMarkerObject(bookingUid);
            }
        });
    }

    private void createMarkerObject(String uid) {
        XreportsBookingMarkerObject marker = new XreportsBookingMarkerObject();
        marker.setModified(new Date());
        marker.setDeleted(false);
        marker.setBookingUid(uid);
        AssetsStorage.get().save((BaseAsset)marker);
        this.getMarkerObjectsBookingUids().add(uid);
    }

    private Set<String> getMarkerObjectsBookingUids() {
        HashSet bookingUids = (HashSet)LogicalStorage.get().getSessionContext().get(KEY_CREATED_MARKER_OBJECTS_BOOKINGS_UIDS);
        if (bookingUids == null) {
            bookingUids = new HashSet();
            LogicalStorage.get().getSessionContext().put(KEY_CREATED_MARKER_OBJECTS_BOOKINGS_UIDS, bookingUids);
        }
        return bookingUids;
    }

    private boolean isXreportsEnabled() {
        return XreportsIntegrationHelper.settingsExist() && XreportsIntegrationHelper.getSettings().isEnabled();
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (BasePaymentDocument.class.isAssignableFrom(data.getEntityType())) {
            if (!this.isXreportsEnabled()) {
                return;
            }
            EntityContainer oldDocumentCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
            BasePaymentDocument doc = (BasePaymentDocument)oldDocumentCtr.getEntity();
            for (EntityReference shipmentRef : doc.getRelatedShipments()) {
                EntityContainer shipmentCtr = EntityStorageHelper.resolve((EntityReference)shipmentRef, (EntityStorageContext)LogicalStorageHelper.getEntityStorageContext());
                if (shipmentCtr == null) continue;
                this.createMarkerObjectForShipment((Shipment)shipmentCtr.getEntity());
            }
            return;
        }
    }
}

