/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.parsers.model.SirenaXmlExchangeDocumentFilterByClientsSettings;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.model.interceptors.BookingFileContainerInterceptor;
import java.util.Collection;
import java.util.Map;

public class IbecorpBookingFileContainerInterceptor
extends BookingFileContainerInterceptor {
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        boolean isSirena;
        SirenaXmlExchangeDocumentFilterByClientsSettings settings;
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        BookingFile bookingFile = (BookingFile)data.getEntity();
        if (this.isFromParser() && (settings = (SirenaXmlExchangeDocumentFilterByClientsSettings)CollectionUtil.singleOrNull((Collection)SystemHelper.searchSystemSettings(SirenaXmlExchangeDocumentFilterByClientsSettings.class))) != null && settings.isActive() && !settings.getClients().isEmpty() && (isSirena = this.isSirena(bookingFile))) {
            EntityReference customerProfileRef = bookingFile.getCustomerProfile();
            if (customerProfileRef == null) {
                throw Xeption.forEndUser((String)L10nResourcesManager.getStr((String)Messages.CLIENT_NOT_FOUND, (Object[])new Object[0]), (Object[])new Object[0]);
            }
            EntityContainer customerProfileEtc = EntityStorage.get().resolve(customerProfileRef);
            Organization customerProfile = (Organization)customerProfileEtc.getEntity();
            boolean ignoreIt = this.ignoreIt(settings, customerProfile);
            if (ignoreIt) {
                throw Xeption.forEndUser((String)L10nResourcesManager.getStr((String)Messages.PARSING_NOT_ALLOWED, (Object[])new Object[]{customerProfile.getFullName()}), (Object[])new Object[0]);
            }
        }
        super.onSave(ss, data);
    }

    private boolean isSirena(BookingFile bookingFile) {
        return bookingFile.getReservations().stream().anyMatch(res -> CommonReservationGdsNameInfoHelper.containsGds((Reservation)res, (GdsName)GdsName.SIRENA));
    }

    protected boolean isTrueRetailClient(BookingFile bookingFile) {
        return CommonIbecorpHelper.isOnlineBookingFile((BookingFile)bookingFile);
    }

    private boolean isFromParser() {
        Map params = LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters();
        Object createdByParserFlag = params.get("CREATED_BY_PARSERS_FLAG_KEY");
        return Boolean.TRUE.equals(createdByParserFlag);
    }

    private boolean ignoreIt(SirenaXmlExchangeDocumentFilterByClientsSettings settings, Organization customerProfile) {
        return settings.getClients().stream().map(clientRef -> EntityStorage.get().resolve(clientRef)).map(EntityContainer::getEntity).noneMatch(client -> client.equals((Object)customerProfile));
    }
}

