/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndexData;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCodeV2;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.model.handlers.index.CommonProductIndexHandler;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IbecorpCommonProductIndexHandler
extends CommonProductIndexHandler {
    public void updateData(CommonProductIndexData data, DataAggregator aggregator, EntityContainer<BookingFile> etc, BaseProduct product) {
        data.setAggregator(aggregator);
        data.setFullRefund(Boolean.valueOf(IbecorpCommonProductIndexHandler.isFullRefund(product)));
        Customer customer = ((BookingFile)etc.getEntity()).getCustomer();
        if (customer != null) {
            data.setCustomerProfile(customer.getProfile());
            if (customer.getKeyContact() != null) {
                data.setKeyContactPersonProfile(customer.getKeyContact().getProfile());
            }
        }
        List externalCodes = ((BookingFile)etc.getEntity()).getExternalCodes().stream().map(ExternalSystemCodeV2::getCode).filter(TextUtil::nonBlank).collect(Collectors.toList());
        data.setExternalCodes(externalCodes);
        aggregator.aggregate(externalCodes);
        HashSet clientShipments = new HashSet();
        HashSet subagencyShipments = new HashSet();
        List subagencyFops = GeneralProductHelper.getSubagentFops((BaseProduct)product);
        List clientFops = GeneralProductHelper.getClientFops((BaseProduct)product);
        for (Map.Entry entry : product.getFopDetalizations().entrySet()) {
            Set shipments = ((FopDetalization)entry.getValue()).getComponents().stream().map(FopComponent::getShipment).filter(Objects::nonNull).collect(Collectors.toSet());
            if (CollectionUtil.find((Iterable)subagencyFops, (String)((String)entry.getKey())) != null) {
                subagencyShipments.addAll(shipments);
            }
            if (CollectionUtil.find((Iterable)clientFops, (String)((String)entry.getKey())) == null) continue;
            clientShipments.addAll(shipments);
        }
        data.setClientShipments(clientShipments);
        data.setSubagencyShipments(subagencyShipments);
        aggregator.aggregate(clientShipments);
        aggregator.aggregate(subagencyShipments);
        ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
        data.setTripartiteDiscount(Boolean.valueOf(productHandler.isTripartiteDiscount(product)));
        data.setAggregator(null);
    }

    private static boolean isFullRefund(BaseProduct product) {
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        BaseProduct sell = null;
        BaseProduct refund = null;
        if (handler.getStatus(product) == ProductStatus.SELL) {
            sell = product;
            refund = handler.getNextProduct(product);
        } else if (handler.getStatus(product) == ProductStatus.REFUND) {
            refund = product;
            sell = handler.getPreviousProduct(product);
        }
        if (sell == null || refund == null) {
            return false;
        }
        if (handler.getStatus(sell) != ProductStatus.SELL || handler.getStatus(refund) != ProductStatus.REFUND) {
            return false;
        }
        BigDecimal sellPrice = BookingHelper.getTotalPrice((BaseProduct)sell, (ContractType)ContractType.CLIENT);
        BigDecimal refundPrice = BookingHelper.getTotalPrice((BaseProduct)refund, (ContractType)ContractType.CLIENT);
        return MiscUtil.isZero((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{sellPrice, refundPrice}), (boolean)true);
    }
}

