/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.ibecorp.validation.IbecorpValidationMessageType;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.bus.BusSegment;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.CalculatedStatisticType;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.model.validation.XtripHotelsValidationMessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.TravelPolicyStatisticsHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang.BooleanUtils;

public class IbecorpValidationInterceptor
implements EntityInterceptor {
    public static final double priority = 1001.0;
    private static final List<ProductStatus> VOIDED_STATUSES = Arrays.asList(ProductStatus.VOID, ProductStatus.VOID_INTENTION, ProductStatus.VOID_BOOKING);

    public double getPriority() {
        return 1001.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!(data.getEntity() instanceof BookingFile)) {
            return;
        }
        BookingFile bf = (BookingFile)data.getEntity();
        for (Reservation res : bf.getReservations()) {
            for (BaseProduct baseProduct : res.getProducts()) {
                List validationMessages = GeneralProductHelper.getValidationMessages((BaseProduct)baseProduct);
                if (GeneralProductHelper.getHandler((BaseProduct)baseProduct).getTicketType(baseProduct) == TicketType.FAKE) continue;
                if (VOIDED_STATUSES.contains(GeneralProductHelper.getHandler((BaseProduct)baseProduct).getStatus(baseProduct))) {
                    validationMessages.removeIf(vm -> StandartValidationMessageType.STAT_MISSING_COST_CODE.getErrorCode().equals(vm.getErrorCode()));
                }
                validationMessages.removeIf(vm -> IbecorpValidationMessageType.STAT_MISSING_CALCULATED_AFS.getErrorCode().equals(vm.getErrorCode()));
                if (baseProduct instanceof HotelProduct) {
                    validationMessages.removeIf(vm -> StandartValidationMessageType.STAT_MISSING_COST_CODE.getErrorCode().equals(vm.getErrorCode()));
                    validationMessages.removeIf(vm -> XtripHotelsValidationMessageType.HPI_HOTEL_UNRESOLVED.getErrorCode().equals(vm.getErrorCode()));
                    HotelProduct hotelProduct = (HotelProduct)baseProduct;
                    if (BooleanUtils.isNotTrue((Boolean)hotelProduct.getHotelResolved())) {
                        validationMessages.add(IbecorpValidationInterceptor.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_HOTEL_UNRESOLVED, new Object[0]));
                    }
                    IbecorpValidationInterceptor.addHotelValidationMessages(hotelProduct, validationMessages);
                    IbecorpValidationInterceptor.addStatisticsValidationMessages(baseProduct, validationMessages);
                }
                if (!(baseProduct instanceof VisaProduct || baseProduct instanceof UniversalProduct || baseProduct instanceof Transfer)) {
                    this.addCalculatedStatisticsValidationMessages(baseProduct, validationMessages);
                }
                if (baseProduct instanceof Product) {
                    Product product = (Product)baseProduct;
                    this.addCarbonEmissionValidationMessages(product, validationMessages);
                    this.addSegmentDurationValidationMessages(AirProductHelper.getSegments((Collection)product.getSegmentTariffs()), Segment::getFlightDuration, Segment::getRecordNumber, validationMessages);
                }
                if (baseProduct instanceof RailwayProduct) {
                    this.addSegmentDurationValidationMessages(((RailwayProduct)baseProduct).getSegments(), RailwaySegment::getDurationInMinutes, RailwaySegment::getNumber, validationMessages);
                }
                if (baseProduct instanceof BusProduct) {
                    this.addSegmentDurationValidationMessages(((BusProduct)baseProduct).getSegments(), BusSegment::getWayTimeMinutes, BusSegment::getNumber, validationMessages);
                }
                IbecorpValidationInterceptor.addTravellerValidationMessages(baseProduct, validationMessages);
            }
        }
    }

    private void addCalculatedStatisticsValidationMessages(BaseProduct baseProduct, List<ValidationMessage> messages) {
        for (CalculatedStatisticType statisticsType : CalculatedStatisticType.values()) {
            StatisticalData statisticalData;
            if (!IbecorpValidationInterceptor.isCalculatedStatisticRequired(baseProduct, statisticsType) || IbecorpValidationInterceptor.getCalculatedStatisticsValue(baseProduct, statisticsType) != null || TravelPolicyStatisticsHelper.TRAVEL_POLICY_STATISTICS.contains(statisticsType) && (statisticalData = GeneralProductHelper.getHandler((BaseProduct)baseProduct).getStatisticalData(baseProduct)) != null && statisticalData.isTravelPolicyApplied()) continue;
            messages.add(IbecorpValidationInterceptor.createValidationMessage((ValidationMessageType)IbecorpValidationMessageType.STAT_MISSING_CALCULATED_AFS, statisticsType));
        }
    }

    private static void addStatisticsValidationMessages(BaseProduct product, List<ValidationMessage> messages) {
        Collection travellers;
        EntityReference clientRef = product.getReservation().getBookingFile().getCustomerProfile();
        if (clientRef == null) {
            return;
        }
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        if (clientCtr == null) {
            return;
        }
        Organization client = (Organization)clientCtr.getEntity();
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        StatisticalData sd = handler.getStatisticalData(product);
        if (sd == null) {
            handler.newStatisticalData(product);
            sd = handler.getStatisticalData(product);
        }
        if (CollectionUtil.isNotEmpty((Collection)(travellers = handler.getTravellers(product)))) {
            for (Traveller traveller : travellers) {
                List filledCostCodes = StatisticsHelper.getProductCostCodes((BaseProduct)product, (Traveller)traveller);
                ProfileHelper.getNonFilledCostCodeProperties((Collection)client.getCostCodeProperties(), (Collection)client.getCostCodes(), (Collection)filledCostCodes, (BaseProduct)product).stream().map(CostCodeProperties::getCategory).forEach(cat -> messages.add(IbecorpValidationInterceptor.createValidationMessage((ValidationMessageType)StandartValidationMessageType.STAT_MISSING_COST_CODE, cat, traveller.getName())));
            }
        }
    }

    private static void addTravellerValidationMessages(BaseProduct product, List<ValidationMessage> messages) {
        for (Traveller traveller : GeneralProductHelper.getTravellers((BaseProduct)product)) {
            if (traveller.getPassenger() != null) continue;
            EntityReference agency = GeneralProductHelper.getAgency((BaseProduct)product);
            EntityReference subagency = GeneralProductHelper.getSubagency((BaseProduct)product);
            if (subagency != null && !subagency.equals((Object)agency)) {
                messages.add(IbecorpValidationInterceptor.createValidationMessage((ValidationMessageType)StandartValidationMessageType.GPVH_TRAVELLER_MISSING_PROFILE_SUBAGENCY, traveller.getName()));
                continue;
            }
            messages.add(IbecorpValidationInterceptor.createValidationMessage((ValidationMessageType)StandartValidationMessageType.GPVH_TRAVELLER_MISSING_PROFILE, traveller.getName()));
        }
    }

    private static void addHotelValidationMessages(HotelProduct product, List<ValidationMessage> messages) {
        GeoLocation hotelLocation = (GeoLocation)DictHelper.resolve((DictionaryReference)product.getHotelLocation());
        if (hotelLocation != null && LocationType.CITY == hotelLocation.getType()) {
            EntityContainer supplierOrgCtr = EntityStorage.get().resolve(GeneralProductHelper.getSupplier((BaseProduct)product));
            Optional.ofNullable(supplierOrgCtr).map(ctr -> ((Organization)ctr.getEntity()).getHotel()).filter(hotel -> !MiscUtil.equals((Object)product.getHotelLocation(), (Object)hotel.getHotelCity())).ifPresent(hotel -> messages.add(IbecorpValidationInterceptor.createValidationMessage((ValidationMessageType)XtripHotelsValidationMessageType.HPI_HOTEL_CITY_NOT_MATCHES, new Object[0])));
        }
    }

    private static ValidationMessage createValidationMessage(ValidationMessageType type, Object ... params) {
        return ValidationMessageHelper.createValidationMessage((ValidationMessageType)type, (Object[])params);
    }

    private static boolean isCalculatedStatisticRequired(BaseProduct product, CalculatedStatisticType statisticType) {
        if (product instanceof AdditionalServiceProduct) {
            return false;
        }
        if (statisticType == CalculatedStatisticType.TRAVEL_POLICY_SALES_DEEPS_LIMIT && product instanceof Transfer) {
            return false;
        }
        if (statisticType == CalculatedStatisticType.MIN_PRICE_HOTEL && !(product instanceof HotelProduct)) {
            return false;
        }
        if (statisticType == CalculatedStatisticType.MIN_PRICE_PER_ROOM && !(product instanceof HotelProduct)) {
            return false;
        }
        if (statisticType == CalculatedStatisticType.RACK_RATE_PRICE && !(product instanceof HotelProduct)) {
            return false;
        }
        if (statisticType == CalculatedStatisticType.MIN_PRICE_RAILWAY && !(product instanceof RailwayProduct)) {
            return false;
        }
        if (statisticType == CalculatedStatisticType.FLIGHT_DURATION && !(product instanceof Product)) {
            return false;
        }
        if (product instanceof AeroexpressTicket && TravelPolicyStatisticsHelper.TRAVEL_POLICY_STATISTICS.contains(statisticType)) {
            return false;
        }
        EntityContainer ctr = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        return ctr != null && ((Organization)ctr.getEntity()).getCalculatedStatisticSettings().contains(statisticType);
    }

    public static Object getCalculatedStatisticsValue(BaseProduct bp, CalculatedStatisticType statisticType) {
        StatisticalData statisticalData = GeneralProductHelper.getHandler((BaseProduct)bp).getStatisticalData(bp);
        if (statisticalData == null) {
            return null;
        }
        switch (statisticType) {
            case SALES_DEEPS: {
                return statisticalData.getSalesDeeps();
            }
            case FLIGHT_DURATION: {
                return statisticalData.getFlightDuration();
            }
            case SELF_BOOKING_ECONOMY: {
                return statisticalData.getSelfBookingEconomy();
            }
            case MIN_PRICE_HOTEL: {
                return statisticalData.getMinPriceHotel();
            }
            case RACK_RATE_PRICE: {
                return statisticalData.getRackRatePrice();
            }
            case MIN_PRICE_PER_ROOM: {
                return statisticalData.getMinPricePerRoom();
            }
            case MIN_PRICE_RAILWAY: {
                return statisticalData.getMinPriceRailway();
            }
            case TRAVEL_POLICY_LIMIT: {
                return statisticalData.getTravelPolicyLimit();
            }
            case TRAVEL_POLICY_VIOLATION: {
                return statisticalData.getTravelPolicyViolation();
            }
            case TRAVEL_POLICY_AUTHORIZATION: {
                return statisticalData.getTravelPolicyAuthorization();
            }
            case TRAVEL_POLICY_REASON_CODE: {
                return statisticalData.getReasonCodes();
            }
            case TRAVEL_POLICY_SALES_DEEPS_LIMIT: {
                return statisticalData.getTravelPolicySalesDeepsLimit();
            }
        }
        return null;
    }

    private void addCarbonEmissionValidationMessages(Product product, List<ValidationMessage> messages) {
        messages.removeIf(vm -> IbecorpValidationMessageType.NOT_CARBON_EMISSION.getErrorCode().equals(vm.getErrorCode()));
        if (product.getPassengerType() != null && GdsDictHelper.isWithoutSeat((DictionaryReference)product.getPassengerType())) {
            return;
        }
        if (product.getMcoCategory() != null) {
            return;
        }
        EntityReference clientRef = product.getReservation().getBookingFile().getCustomerProfile();
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        if (clientCtr != null && !StatisticsHelper.getAfsTypesFromString((String)((Organization)clientCtr.getEntity()).getAfsSettings()).contains(AFSType.CO2_EMISSIONS)) {
            return;
        }
        for (Segment segment : AirProductHelper.getSegments((Collection)product.getSegmentTariffs())) {
            if (segment.getCo2EmissionsKg() != null) continue;
            messages.add(IbecorpValidationInterceptor.createValidationMessage((ValidationMessageType)IbecorpValidationMessageType.NOT_CARBON_EMISSION, segment.getRecordNumber()));
        }
    }

    private <S> void addSegmentDurationValidationMessages(List<S> segments, Function<S, Integer> durationGetter, Function<S, ?> numberGetter, List<ValidationMessage> messages) {
        messages.removeIf(vm -> IbecorpValidationMessageType.TOO_LONG_SEGMENT_DURATION.getErrorCode().equals(vm.getErrorCode()));
        for (S segment : segments) {
            if (durationGetter.apply(segment) == null || durationGetter.apply(segment) <= Short.MAX_VALUE) continue;
            messages.add(IbecorpValidationInterceptor.createValidationMessage((ValidationMessageType)IbecorpValidationMessageType.TOO_LONG_SEGMENT_DURATION, numberGetter.apply(segment)));
        }
    }
}

