/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.PersonNoticesDetails;
import com.gridnine.xtrip.common.model.ibecorp.PersonNoticesDetailsIndex;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;

public class PersonNoticesDetailsInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 50.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) {
        if (!PersonNoticesDetails.class.equals((Object)data.getEntityType())) {
            return;
        }
        EntityContainer<?> ctr = data;
        EntityContainer oldCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        if (this.samePersonAndOrganization(ctr, (EntityContainer<PersonNoticesDetails>)oldCtr)) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonNoticesDetailsIndex.Property.person.name(), (Object)((PersonNoticesDetails)ctr.getEntity()).getPerson()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonNoticesDetailsIndex.Property.organization.name(), (Object)((PersonNoticesDetails)ctr.getEntity()).getOrganization()));
        query.getCriteria().getCriterions().add(SearchCriterion.not((SearchCriterion)SearchCriterion.eq((String)"containerUid", (Object)ctr.getUid())));
        query.setResultMode(ResultMode.COUNT_ONLY);
        int totalCount = EntityStorage.get().search(PersonNoticesDetailsIndex.class, query).getTotalCount();
        if (totalCount > 0) {
            throw Xeption.forDeveloper((String)"failed save PersonNoticesDetails {0} ({1}): record with same person and organization yet exists.", (Object[])new Object[]{((PersonNoticesDetails)ctr.getEntity()).toString(), ctr.getUid()});
        }
    }

    private boolean samePersonAndOrganization(EntityContainer<PersonNoticesDetails> ctr, EntityContainer<PersonNoticesDetails> oldCtr) {
        if (oldCtr == null) {
            return false;
        }
        return MiscUtil.equals((Object)((PersonNoticesDetails)ctr.getEntity()).getPerson(), (Object)((PersonNoticesDetails)oldCtr.getEntity()).getPerson()) && MiscUtil.equals((Object)((PersonNoticesDetails)ctr.getEntity()).getOrganization(), (Object)((PersonNoticesDetails)oldCtr.getEntity()).getOrganization());
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }
}

