/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.storage;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.bus.templates.jr.BusItineraryReceiptRender;
import com.gridnine.xtrip.common.ibecorp.rules.Actions;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.AirItineraryReceiptData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CertificateOfCompletedFlightData;
import com.gridnine.xtrip.common.model.booking.HotelVoucherData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.model.templates.jr.AeroexpressReceiptRender;
import com.gridnine.xtrip.common.model.templates.jr.CertificateOfCompletedFlightRender;
import com.gridnine.xtrip.common.model.templates.jr.RailwayItineraryReceiptRender;
import com.gridnine.xtrip.common.model.templates.jr.RailwayRefundReceiptRender;
import com.gridnine.xtrip.common.model.templates.jr.RefundReceiptRender;
import com.gridnine.xtrip.common.model.templates.jr.TransferItineraryReceiptRender;
import com.gridnine.xtrip.common.model.templates.jr.VoucherRender;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.function.ThrowingFunction;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.IbecorpRailwayRulesProductHandler;
import com.gridnine.xtrip.server.model.handlers.AdditionalServiceProductActionSet;
import com.gridnine.xtrip.server.model.handlers.AeroexpressTicketActionSet;
import com.gridnine.xtrip.server.model.handlers.HotelActionSet;
import com.gridnine.xtrip.server.model.handlers.ProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.TransferActionSet;
import com.gridnine.xtrip.server.model.handlers.rules.AdditionalServiceProductRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.AeroexpressTicketRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.AirRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import com.gridnine.xtrip.server.model.handlers.rules.TransferRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import com.gridnine.xtrip.server.model.templates.jr.ItineraryReceiptRender;
import com.gridnine.xtrip.server.railway.model.rules.standart.proxy.RailwayProductCommissionActionSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProductReceiptInterceptor
implements EntityInterceptor {
    public static final double PRIORITY = 2.147483646E9;
    private static final Logger log = LoggerFactory.getLogger(ProductReceiptInterceptor.class);
    private static final List<Class<? extends BaseProduct>> supportedProducts = Arrays.asList(Product.class, RailwayProduct.class, HotelProduct.class, Transfer.class, AeroexpressTicket.class, AdditionalServiceProduct.class);
    private static final Set<DocumentType> DOCUMENT_TYPES_FOR_REMOVE_PREVIOUS_DOCS = EnumSet.of(DocumentType.RECEIPT, DocumentType.VOUCHER);

    ProductReceiptInterceptor() {
    }

    public double getPriority() {
        return 2.147483646E9;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        ProductHandler handler;
        if (!BookingFile.class.equals((Object)data.getEntityType())) {
            Document document;
            if ((data.getEntity() != null && Document.class.equals((Object)data.getEntityType()) || FilledTemplateDocument.class.equals((Object)data.getEntityType())) && !(document = (Document)data.getEntity()).isExternal() && DOCUMENT_TYPES_FOR_REMOVE_PREVIOUS_DOCS.contains(document.getType())) {
                EntityReference template = FilledTemplateDocument.class.equals((Object)data.getEntityType()) ? ((FilledTemplateDocument)data.getEntity()).getTemplate() : null;
                this.removePreviousDocs(document, (EntityReference<TemplateDocument>)template);
            }
            return;
        }
        if (!AppConfiguration.get().isIbeEnabled()) {
            return;
        }
        EntityContainer<?> bfContainer = data;
        if (((BookingFile)bfContainer.getEntity()).getReservations().isEmpty()) {
            return;
        }
        HashMap travelDocs = new HashMap();
        try {
            HashMap<String, BaseProduct> effectiveProducts = new HashMap<String, BaseProduct>();
            for (Reservation res : ((BookingFile)bfContainer.getEntity()).getReservations()) {
                for (BaseProduct baseProduct : res.getProducts()) {
                    boolean hasNotNextProduct;
                    if (!supportedProducts.contains(baseProduct.getClass())) continue;
                    handler = ProductHandler.of((BaseProduct)baseProduct);
                    ProductStatus status = handler.getStatus(baseProduct);
                    TravelSubject travelSubject = handler.findTravelSubject(baseProduct);
                    boolean bl = hasNotNextProduct = handler.getNextProduct(baseProduct) == null;
                    boolean bl2 = travelSubject == TravelSubject.HOTEL_RESERVATION || travelSubject == TravelSubject.TRANSFER ? status == ProductStatus.SELL && hasNotNextProduct : status == ProductStatus.SELL || status == ProductStatus.REFUND;
                    boolean isEffectiveProduct = bl2;
                    if (!isEffectiveProduct) continue;
                    effectiveProducts.put(baseProduct.getUid(), baseProduct);
                    travelDocs.put(baseProduct, new HashSet());
                }
            }
            SearchQuery query = new SearchQuery();
            this.addMainCriterions(query, (EntityReference<? extends BaseEntity>)data.toReference());
            query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)BasicDocumentIndex.Property.type.name(), Arrays.asList(DocumentType.RECEIPT, DocumentType.VOUCHER)));
            for (BasicDocumentIndex idx : LogicalStorage.get().getEntityStorage().search(BasicDocumentIndex.class, query).getData()) {
                BaseProduct prod = (BaseProduct)effectiveProducts.get(idx.getNavigationKey());
                if (prod != null) {
                    ((Set)travelDocs.get(prod)).add(idx.getSource());
                    continue;
                }
                EntityStorage.get().delete(idx.getSource());
            }
        }
        catch (Throwable t) {
            SysLogHelper.audit((EntityReference)data.toReference(), (String)"receipt", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0438", (Throwable)t, (Object[])new Object[0])});
        }
        if (!travelDocs.isEmpty()) {
            EntityContainer clonedBfContainer = (EntityContainer)XCloneHelper.clone(bfContainer);
            EntityStorageContext storageContext = new EntityStorageContext();
            for (Map.Entry entry : travelDocs.entrySet()) {
                try {
                    BaseProduct clonedProduct = BookingHelper.findProductByUid((String)((BaseProduct)entry.getKey()).getUid(), (BookingFile)((BookingFile)clonedBfContainer.getEntity()));
                    TemplatesData templatesData = ProductReceiptInterceptor.getTemplates(clonedProduct, (EntityContainer<BookingFile>)clonedBfContainer, storageContext);
                    ((BookingFile)bfContainer.getEntity()).getAppliedRules().clear();
                    ((BookingFile)bfContainer.getEntity()).getAppliedRules().addAll(clonedProduct.getReservation().getBookingFile().getAppliedRules());
                    if (templatesData == null || templatesData.getTemplates() == null || templatesData.getTemplates().isEmpty()) {
                        log.warn(String.format("Travel reservation template not found for locale %s", LocaleHelper.getCurrentLocale().getLanguage()));
                        continue;
                    }
                    Collection<FilledTemplateDocument> receipts = ProductReceiptInterceptor.renderDocuments((BaseProduct)entry.getKey(), bfContainer, templatesData);
                    if (entry.getValue() == null || ((Set)entry.getValue()).isEmpty()) {
                        ProductReceiptInterceptor.saveTravelDoc(receipts, templatesData);
                        continue;
                    }
                    if (ProductReceiptInterceptor.isSameTravelDocInfo(ProductReceiptInterceptor.findOldProduct(((BaseProduct)entry.getKey()).getUid()), ProductReceiptInterceptor.getOldCtr(), receipts, templatesData)) continue;
                    ((Set)entry.getValue()).forEach(value -> LogicalStorage.get().getEntityStorage().delete(((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(value)));
                    ProductReceiptInterceptor.saveTravelDoc(receipts, templatesData);
                }
                catch (Throwable t) {
                    handler = Objects.requireNonNull(GeneralProductHelper.getHandler((BaseProduct)((BaseProduct)entry.getKey())));
                    SysLogHelper.audit((EntityReference)data.toReference(), (String)"receipt", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)("\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0438 \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 " + handler.generateShortProductName((BaseProduct)entry.getKey())), (Throwable)t, (Object[])new Object[0])});
                }
            }
        }
    }

    private void removePreviousDocs(Document document, EntityReference<TemplateDocument> template) {
        EntityReference owner = document.getOwner();
        try {
            SearchQuery query = new SearchQuery();
            this.addMainCriterions(query, (EntityReference<? extends BaseEntity>)owner);
            query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqEnumCriterion((String)BasicDocumentIndex.Property.type.name(), Collections.singletonList(document.getType())));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)document.getNavigationKey()));
            EntityStorage.get().search(BasicDocumentIndex.class, query).getData().forEach(oldDocument -> {
                EntityContainer ctr = EntityStorage.get().resolve(oldDocument.getSource());
                boolean delete = false;
                if (ctr != null) {
                    if (Document.class.equals((Object)ctr.getEntityType())) {
                        delete = true;
                    } else if (FilledTemplateDocument.class.equals((Object)ctr.getEntityType())) {
                        EntityReference oldTemplate = ((FilledTemplateDocument)ctr.getEntity()).getTemplate();
                        boolean bl = delete = template == null || oldTemplate == null || oldTemplate.equals((Object)template);
                    }
                }
                if (delete) {
                    EntityStorage.get().delete(ctr);
                }
            });
        }
        catch (Throwable t) {
            SysLogHelper.audit((EntityReference)owner, (String)"receipt", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u0445 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u043d\u044b\u0445 \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0439", (Throwable)t, (Object[])new Object[0])});
        }
    }

    private void addMainCriterions(SearchQuery query, EntityReference<? extends BaseEntity> owner) {
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), owner));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BasicDocumentIndex.Property.external.name(), (Object)false), SearchCriterion.eq((String)BasicDocumentIndex.Property.external.name(), null)}));
    }

    private static void saveTravelDoc(Collection<FilledTemplateDocument> receipts, TemplatesData templatesData) throws Exception {
        for (EntityContainer<TemplateDocument> template : templatesData.getTemplates()) {
            if (!receipts.stream().map(FilledTemplateDocument::getTemplate).noneMatch(arg_0 -> ((EntityReference)template.toReference()).equals(arg_0))) continue;
            throw new RuntimeException("receipt wasn't created for template " + template.toReference());
        }
        for (FilledTemplateDocument receipt : receipts) {
            LogicalStorage.get().getEntityStorage().save(EntityContainer.create((BaseEntity)receipt), true);
        }
    }

    private static Collection<FilledTemplateDocument> renderDocuments(BaseProduct product, EntityContainer<BookingFile> bfCont, TemplatesData templatesData) throws Exception {
        ProductStatus status = GeneralProductHelper.getStatus((BaseProduct)product);
        if (product instanceof Product) {
            AirItineraryReceiptData receiptData = Objects.requireNonNull(templatesData.getReceiptData());
            List notes = receiptData.getNotes().stream().map(arg_0 -> ((DictionaryCache)DictionaryCache.get()).resolveReference(arg_0)).collect(Collectors.toList());
            if (status == ProductStatus.SELL) {
                ItineraryReceiptRender render = new ItineraryReceiptRender();
                return ProductReceiptInterceptor.renderMany(templatesData, (ThrowingFunction<EntityContainer<TemplateDocument>, FilledTemplateDocument, Exception>)((ThrowingFunction)template -> render.renderReport(bfCont, (Product)product, template, notes, receiptData.isITTariff(), receiptData.isUseCyrillicForTravelerName(), receiptData.isIncludePayer(), receiptData.isIncludeVat(), receiptData.isIncludeLogo(), receiptData.isIncludeAgencyFees(), receiptData.isIncludeAgencyFeesIntoTaxes(), receiptData.isIncludeVendorFees(), receiptData.isIncludeVendorFeesIntoTaxes(), receiptData.isShowTaxesSum(), receiptData.isIncludeVatDetalization(), receiptData.isHidePassport())));
            }
            if (status == ProductStatus.REFUND) {
                RefundReceiptRender render = new RefundReceiptRender();
                return ProductReceiptInterceptor.renderMany(templatesData, (ThrowingFunction<EntityContainer<TemplateDocument>, FilledTemplateDocument, Exception>)((ThrowingFunction)template -> render.renderReport(bfCont, (Product)product, template, notes, receiptData.isITTariff(), receiptData.isUseCyrillicForTravelerName(), receiptData.isIncludePayer(), receiptData.isIncludeVat(), receiptData.isIncludeAgencyFees(), receiptData.isIncludeAgencyFeesIntoTaxes(), receiptData.isIncludeVendorFees(), receiptData.isIncludeVendorFeesIntoTaxes(), receiptData.isShowTaxesSum(), receiptData.isIncludeVatDetalization(), receiptData.isHidePassport())));
            }
            return Collections.emptyList();
        }
        if (product instanceof RailwayProduct) {
            if (status == ProductStatus.SELL) {
                RailwayItineraryReceiptRender render = new RailwayItineraryReceiptRender();
                return ProductReceiptInterceptor.renderMany(templatesData, (ThrowingFunction<EntityContainer<TemplateDocument>, FilledTemplateDocument, Exception>)((ThrowingFunction)template -> render.renderReport(bfCont, (RailwayProduct)product, template, Collections.emptyList())));
            }
            if (status == ProductStatus.REFUND) {
                RailwayRefundReceiptRender render = new RailwayRefundReceiptRender();
                return ProductReceiptInterceptor.renderMany(templatesData, (ThrowingFunction<EntityContainer<TemplateDocument>, FilledTemplateDocument, Exception>)((ThrowingFunction)template -> render.renderReport(bfCont, (RailwayProduct)product, template, Collections.emptyList())));
            }
            return null;
        }
        if (product instanceof HotelProduct) {
            HotelVoucherData voucherData = templatesData.getVoucherData();
            List notes = voucherData.getNotes().stream().map(arg_0 -> ((DictionaryCache)DictionaryCache.get()).resolveReference(arg_0)).collect(Collectors.toList());
            VoucherRender render = new VoucherRender();
            return ProductReceiptInterceptor.renderMany(templatesData, (ThrowingFunction<EntityContainer<TemplateDocument>, FilledTemplateDocument, Exception>)((ThrowingFunction)template -> render.renderReport(bfCont, (HotelProduct)product, template, voucherData.getAgencyContacts(), notes, voucherData.isHidePrice(), voucherData.isHideMeal(), voucherData.isHideBasicEssentialInfo(), voucherData.isHideAmenities(), voucherData.isIncludeFeesInTotalPrice())));
        }
        if (product instanceof Transfer) {
            TransferItineraryReceiptRender render = new TransferItineraryReceiptRender();
            return ProductReceiptInterceptor.renderMany(templatesData, (ThrowingFunction<EntityContainer<TemplateDocument>, FilledTemplateDocument, Exception>)((ThrowingFunction)template -> render.renderReport(bfCont, (Transfer)product, template, Collections.emptyList())));
        }
        if (product instanceof AeroexpressTicket) {
            AeroexpressReceiptRender render = new AeroexpressReceiptRender();
            return ProductReceiptInterceptor.renderMany(templatesData, (ThrowingFunction<EntityContainer<TemplateDocument>, FilledTemplateDocument, Exception>)((ThrowingFunction)template -> render.renderReport(bfCont, (AeroexpressTicket)product, template, Collections.emptyList())));
        }
        if (product instanceof AdditionalServiceProduct) {
            CertificateOfCompletedFlightRender render = new CertificateOfCompletedFlightRender();
            return ProductReceiptInterceptor.renderMany(templatesData, (ThrowingFunction<EntityContainer<TemplateDocument>, FilledTemplateDocument, Exception>)((ThrowingFunction)template -> render.renderReport(bfCont, (AdditionalServiceProduct)product, template, Boolean.valueOf(templatesData.getCertificateData().isUseFacsimile()), templatesData.getCertificateData().getSignatures())));
        }
        if (product instanceof BusProduct) {
            BusItineraryReceiptRender render = new BusItineraryReceiptRender();
            return ProductReceiptInterceptor.renderMany(templatesData, (ThrowingFunction<EntityContainer<TemplateDocument>, FilledTemplateDocument, Exception>)((ThrowingFunction)template -> render.renderReport(bfCont, (BusProduct)product, template)));
        }
        throw new IllegalArgumentException("unsupported product type: " + product.getClass());
    }

    private static Collection<FilledTemplateDocument> renderMany(TemplatesData templatesData, ThrowingFunction<EntityContainer<TemplateDocument>, FilledTemplateDocument, Exception> renderSingle) {
        return templatesData.getTemplates().stream().map(template -> {
            try {
                return (FilledTemplateDocument)renderSingle.apply(template);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.toList());
    }

    private static EntityContainer<BookingFile> getOldCtr() {
        return LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getOldCtr();
    }

    private static TemplatesData getTemplates(BaseProduct product, EntityContainer<BookingFile> bfContainer, EntityStorageContext storageContext) throws Exception {
        if (product instanceof Product) {
            return ProductReceiptInterceptor.getTemplates((Product)product, storageContext);
        }
        if (product instanceof RailwayProduct) {
            return ProductReceiptInterceptor.getTemplates((RailwayProduct)product, bfContainer, storageContext);
        }
        if (product instanceof HotelProduct) {
            return ProductReceiptInterceptor.getTemplates((HotelProduct)product, storageContext);
        }
        if (product instanceof Transfer) {
            return ProductReceiptInterceptor.getTemplates((Transfer)product, bfContainer, storageContext);
        }
        if (product instanceof AeroexpressTicket) {
            return ProductReceiptInterceptor.getTemplates((AeroexpressTicket)product, bfContainer, storageContext);
        }
        if (product instanceof AdditionalServiceProduct) {
            return ProductReceiptInterceptor.getTemplates((AdditionalServiceProduct)product, bfContainer, storageContext);
        }
        throw new IllegalArgumentException("unsupported product type: " + product.getClass());
    }

    private static TemplatesData getTemplates(Product product, EntityStorageContext storageContext) throws Exception {
        Locale locale;
        EntityContainer<TemplateDocument> template2;
        boolean ruleWasApplied;
        RuleProxy ruleProxy = AirRulesHelper.applyContracts((Product)product, new ArrayList(), null, (RuleAction)Actions.AVIA_RECEIPT, (String)Actions.AVIA_RECEIPT.getRuleCategoryValue(null, null));
        if (ruleProxy != null && (ruleWasApplied = ruleProxy.getAppliedRuleCategories().contains(Actions.AVIA_RECEIPT.getRuleCategoryValue(ruleProxy.getActionSet(), (Object)((ProductCommissionActionSet)ruleProxy.getActionSet()).getItineraryReceiptData())))) {
            Collection templates;
            AirItineraryReceiptData receiptData = ((ProductCommissionActionSet)ruleProxy.getActionSet()).getItineraryReceiptData();
            if (receiptData != null && !(templates = (Collection)receiptData.getTemplates().stream().map(template -> EntityStorageHelper.resolve((EntityReference)template, (EntityStorageContext)storageContext)).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
                TemplatesData templateData = new TemplatesData();
                templateData.setTemplates(templates);
                templateData.setReceiptData(receiptData);
                return templateData;
            }
            return null;
        }
        if ((product.getReservation().getType() == ReservationType.INTERNET || product.getReservation().getType() == ReservationType.IBE) && (template2 = CabinetHelper.getTemplateDocument(locale = LocaleUtil.createNormalizedLocale((String)LocaleHelper.getCurrentLocale().getLanguage()))) != null) {
            TemplatesData templateData = new TemplatesData();
            templateData.setTemplates(Collections.singleton(template2));
            AirItineraryReceiptData receiptData = new AirItineraryReceiptData();
            receiptData.setIncludeVat(true);
            receiptData.setIncludeAgencyFees(true);
            receiptData.setIncludeAgencyFeesIntoTaxes(true);
            receiptData.setIncludeVendorFees(true);
            receiptData.setIncludeVendorFeesIntoTaxes(true);
            templateData.setReceiptData(receiptData);
            return templateData;
        }
        return null;
    }

    private static TemplatesData getTemplates(RailwayProduct product, EntityContainer<BookingFile> bfContainer, EntityStorageContext storageContext) throws Exception {
        List<EntityContainer<TemplateDocument>> templates;
        Collection receiptTemplates;
        IbecorpRailwayRulesProductHandler railwayHandler = new IbecorpRailwayRulesProductHandler();
        railwayHandler.setAfterRulesAppliedConsumer(prod -> {});
        RuleProxy ruleProxy = GeneralProductRulesHelper.applyRules((BaseProduct)product, bfContainer, (RulesProductHandler)railwayHandler, new ArrayList(), null, null, (boolean)true, (boolean)false, (boolean)true);
        if (ruleProxy != null && (receiptTemplates = ((RailwayProductCommissionActionSet)ruleProxy.getActionSet()).getReceiptTemplates()) != null && !receiptTemplates.isEmpty() && !(templates = receiptTemplates.stream().map(template -> EntityStorageHelper.resolve((EntityReference)template, (EntityStorageContext)storageContext)).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            TemplatesData templatesData = new TemplatesData();
            templatesData.setTemplates(templates);
            return templatesData;
        }
        return null;
    }

    private static TemplatesData getTemplates(Transfer product, EntityContainer<BookingFile> bfContainer, EntityStorageContext storageContext) throws Exception {
        List<EntityContainer<TemplateDocument>> templates;
        Collection receiptTemplates;
        RulesProductHandler transferHandler = TransferRulesHandler.get().createRulesHandler();
        RuleProxy ruleProxy = GeneralProductRulesHelper.applyRules((BaseProduct)product, bfContainer, (RulesProductHandler)transferHandler, new ArrayList(), null, null, (boolean)true, (boolean)false, (boolean)true);
        if (ruleProxy != null && (receiptTemplates = ((TransferActionSet)ruleProxy.getActionSet()).getReceiptTemplates()) != null && !receiptTemplates.isEmpty() && !(templates = receiptTemplates.stream().map(template -> EntityStorageHelper.resolve((EntityReference)template, (EntityStorageContext)storageContext)).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            TemplatesData templateData = new TemplatesData();
            templateData.setTemplates(templates);
            return templateData;
        }
        return null;
    }

    private static TemplatesData getTemplates(AeroexpressTicket product, EntityContainer<BookingFile> bfContainer, EntityStorageContext storageContext) throws Exception {
        List<EntityContainer<TemplateDocument>> templates;
        Collection receiptTemplates;
        AeroexpressTicketRulesHandler aeroexpressRulesHandler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).getAllRulesHandlers().stream().filter(rulesHandler -> AeroexpressTicketRulesHandler.ID.equals(rulesHandler.getId())).map(AeroexpressTicketRulesHandler.class::cast).findFirst().orElseThrow(() -> new Exception("AeroexpressTicketRulesHandler not found in registry"));
        RulesProductHandler aeroexpressHandler = aeroexpressRulesHandler.createRulesHandler();
        RuleProxy ruleProxy = GeneralProductRulesHelper.applyRules((BaseProduct)product, bfContainer, (RulesProductHandler)aeroexpressHandler, new ArrayList(), null, null, (boolean)true, (boolean)false, (boolean)true);
        if (ruleProxy != null && (receiptTemplates = ((AeroexpressTicketActionSet)ruleProxy.getActionSet()).getReceiptTemplates()) != null && !receiptTemplates.isEmpty() && !(templates = receiptTemplates.stream().map(template -> EntityStorageHelper.resolve((EntityReference)template, (EntityStorageContext)storageContext)).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            TemplatesData templateData = new TemplatesData();
            templateData.setTemplates(templates);
            return templateData;
        }
        return null;
    }

    private static TemplatesData getTemplates(AdditionalServiceProduct product, EntityContainer<BookingFile> bfContainer, EntityStorageContext storageContext) throws Exception {
        List<EntityContainer<TemplateDocument>> templates;
        CertificateOfCompletedFlightData certificateData;
        AdditionalServiceProductRulesHandler additionalServiceRulesHandler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).getAllRulesHandlers().stream().filter(rulesHandler -> AdditionalServiceProductRulesHandler.ID.equals(rulesHandler.getId())).map(AdditionalServiceProductRulesHandler.class::cast).findFirst().orElseThrow(() -> new Exception("AdditionalServiceProductRulesHandler not found in registry"));
        RulesProductHandler additionalServiceHandler = additionalServiceRulesHandler.createRulesHandler();
        RuleProxy ruleProxy = GeneralProductRulesHelper.applyRules((BaseProduct)product, bfContainer, (RulesProductHandler)additionalServiceHandler, new ArrayList(), null, null, (boolean)true, (boolean)false, (boolean)true);
        if (ruleProxy != null && (certificateData = ((AdditionalServiceProductActionSet)ruleProxy.getActionSet()).getCertificateOfCompletedFlightData()) != null && !(templates = certificateData.getTemplates().stream().map(template -> EntityStorageHelper.resolve((EntityReference)template, (EntityStorageContext)storageContext)).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            TemplatesData templateData = new TemplatesData();
            templateData.setTemplates(templates);
            templateData.setCertificateData(certificateData);
            return templateData;
        }
        return null;
    }

    private static TemplatesData getTemplates(HotelProduct product, EntityStorageContext storageContext) {
        EntityContainer<TemplateDocument> template2;
        Reservation oldReservation;
        EntityContainer<BookingFile> oldBookingFile;
        Reservation reservation;
        List<EntityContainer<TemplateDocument>> templates;
        HotelVoucherData voucherData;
        ArrayList messages = new ArrayList();
        List contracts = HotelRulesHelper.getContracts((HotelProduct)product, null, messages);
        RuleProxy ruleProxy = HotelRulesHelper.applyContracts((HotelProduct)product, (List)contracts, messages);
        if (ruleProxy != null && (voucherData = ((HotelActionSet)ruleProxy.getActionSet()).getHotelVoucherData()) != null && !(templates = voucherData.getTemplates().stream().map(template -> EntityStorageHelper.resolve((EntityReference)template, (EntityStorageContext)storageContext)).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            TemplatesData templateData = new TemplatesData();
            templateData.setTemplates(templates);
            templateData.setVoucherData(voucherData);
            return templateData;
        }
        if (product.getStatus() == ProductStatus.SELL && (reservation = product.getReservation()).getStatus() == ReservationStatus.ISSUED && (oldBookingFile = ProductReceiptInterceptor.getOldCtr()) != null && (oldReservation = BookingHelper.findReservationByUid((BookingFile)((BookingFile)oldBookingFile.getEntity()), (String)reservation.getUid())) != null && (oldReservation.getStatus() == ReservationStatus.INTENTION || oldReservation.getStatus() == ReservationStatus.REQUEST) && (template2 = ProductReceiptInterceptor.getDefaultHotelTemplate()) != null) {
            HotelVoucherData voucherData2 = new HotelVoucherData();
            voucherData2.setAgencyContacts(null);
            voucherData2.getTemplates().add(template2.toReference());
            TemplatesData templateData = new TemplatesData();
            templateData.setTemplates(Collections.singleton(template2));
            templateData.setVoucherData(voucherData2);
            return templateData;
        }
        return null;
    }

    private static EntityContainer<TemplateDocument> getDefaultHotelTemplate() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.templateId.name(), (Object)"voucher-template"));
        List indexes = ((EntityStorage)Environment.getPublished(EntityStorage.class)).search(TemplateDocumentIndex.class, query).getData();
        for (TemplateDocumentIndex index : indexes) {
            EntityContainer templateDocumentContainer;
            if (index.getSource() != null && !index.getSource().getUid().equals("voucher-b2b-template") || (templateDocumentContainer = EntityStorage.get().resolve(index.getSource())) == null) continue;
            return templateDocumentContainer;
        }
        return null;
    }

    private static BaseProduct findOldProduct(String uid) {
        return BookingHelper.findProductByUid((String)uid, (BookingFile)((BookingFile)ProductReceiptInterceptor.getOldCtr().getEntity()));
    }

    private static boolean isSameTravelDocInfo(BaseProduct oldProduct, EntityContainer<BookingFile> oldCtr, Collection<FilledTemplateDocument> newReceipts, TemplatesData templatesData) throws Exception {
        if (oldProduct != null) {
            Collection<FilledTemplateDocument> oldReceipts = ProductReceiptInterceptor.renderDocuments(oldProduct, oldCtr, templatesData);
            if (oldReceipts == null || oldReceipts.isEmpty() || newReceipts == null || newReceipts.isEmpty()) {
                return false;
            }
            if (newReceipts.size() != oldReceipts.size()) {
                return false;
            }
            if (Stream.concat(newReceipts.stream(), oldReceipts.stream()).map(FilledTemplateDocument::getTemplate).anyMatch(Objects::isNull)) {
                return false;
            }
            return !newReceipts.stream().anyMatch(newReceipt -> oldReceipts.stream().filter(oldReceipt -> oldReceipt.getTemplate().equals((Object)newReceipt.getTemplate())).anyMatch(oldReceipt -> {
                try {
                    return !ProductReceiptInterceptor.comparePdf(JasperUtil.convertToPdf((byte[])oldReceipt.getContent()), JasperUtil.convertToPdf((byte[])newReceipt.getContent()));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }));
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private static boolean comparePdf(byte[] oldPdf, byte[] newPdf) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) {
    }

    private static class TemplatesData {
        private Collection<EntityContainer<TemplateDocument>> templates;
        private AirItineraryReceiptData receiptData;
        private HotelVoucherData voucherData;
        private CertificateOfCompletedFlightData certificateData;

        private TemplatesData() {
        }

        Collection<EntityContainer<TemplateDocument>> getTemplates() {
            return this.templates;
        }

        void setTemplates(Collection<EntityContainer<TemplateDocument>> templates) {
            this.templates = templates;
        }

        AirItineraryReceiptData getReceiptData() {
            return this.receiptData;
        }

        void setReceiptData(AirItineraryReceiptData receiptData) {
            this.receiptData = receiptData;
        }

        HotelVoucherData getVoucherData() {
            return this.voucherData;
        }

        void setVoucherData(HotelVoucherData voucherData) {
            this.voucherData = voucherData;
        }

        CertificateOfCompletedFlightData getCertificateData() {
            return this.certificateData;
        }

        void setCertificateData(CertificateOfCompletedFlightData certificateData) {
            this.certificateData = certificateData;
        }
    }
}

